/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.fluid;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.fluid.FluidStack;
import dev.architectury.registry.registries.Registries;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.fluid.BoundFluidStackJS;
import dev.latvian.mods.kubejs.fluid.EmptyFluidStackJS;
import dev.latvian.mods.kubejs.fluid.UnboundFluidStackJS;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.Tags;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.kubejs.util.WrappedJS;
import dev.latvian.mods.rhino.mod.util.Copyable;
import dev.latvian.mods.rhino.mod.util.NBTUtils;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public abstract class FluidStackJS
implements WrappedJS,
Copyable {
    private double chance = Double.NaN;

    public static FluidStackJS of(@Nullable Object o) {
        if (o == null) {
            return EmptyFluidStackJS.INSTANCE;
        }
        if (o instanceof FluidStackJS) {
            FluidStackJS js = (FluidStackJS)o;
            return js;
        }
        if (o instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)o;
            return new BoundFluidStackJS(fluidStack);
        }
        if (o instanceof Fluid) {
            Fluid fluid = (Fluid)o;
            UnboundFluidStackJS f = new UnboundFluidStackJS(Registries.getId((Object)fluid, (ResourceKey)Registry.f_122899_));
            return f.isEmpty() ? EmptyFluidStackJS.INSTANCE : f;
        }
        if (o instanceof JsonElement) {
            JsonElement json = (JsonElement)o;
            return FluidStackJS.fromJson(json);
        }
        if (o instanceof CharSequence || o instanceof ResourceLocation) {
            String s = o.toString();
            if (s.isEmpty() || s.equals("-") || s.equals("empty") || s.equals("minecraft:empty")) {
                return EmptyFluidStackJS.INSTANCE;
            }
            String[] s1 = s.split(" ", 2);
            return new UnboundFluidStackJS(new ResourceLocation(s1[0])).withAmount(UtilsJS.parseLong(s1.length == 2 ? s1[1] : "", FluidStack.bucketAmount()));
        }
        MapJS map = MapJS.of(o);
        if (map != null && map.containsKey("fluid")) {
            UnboundFluidStackJS stack = new UnboundFluidStackJS(new ResourceLocation(map.get("fluid").toString()));
            Object v = map.get("amount");
            if (v instanceof Number) {
                Number num = (Number)v;
                ((FluidStackJS)stack).setAmount(num.longValue());
            }
            if (map.containsKey("nbt")) {
                ((FluidStackJS)stack).setNbt(MapJS.nbt(map.get("nbt")));
            }
            return stack;
        }
        return EmptyFluidStackJS.INSTANCE;
    }

    public static FluidStackJS of(@Nullable Object o, long amount, @Nullable CompoundTag nbt) {
        FluidStackJS stack = FluidStackJS.of(o);
        stack.setAmount(amount);
        stack.setNbt(nbt);
        return stack;
    }

    public static FluidStackJS fromJson(JsonElement e) {
        if (!e.isJsonObject()) {
            return FluidStackJS.of(e.getAsString());
        }
        JsonObject json = e.getAsJsonObject();
        FluidStackJS fluid = FluidStackJS.of(json.get("fluid").getAsString());
        if (fluid.isEmpty()) {
            throw new RecipeExceptionJS(json + " is not a valid fluid!");
        }
        long amount = FluidStack.bucketAmount();
        CompoundTag nbt = null;
        if (json.has("amount")) {
            amount = json.get("amount").getAsInt();
        } else if (json.has("count")) {
            amount = json.get("count").getAsInt();
        }
        if (json.has("nbt")) {
            if (json.get("nbt").isJsonObject()) {
                nbt = MapJS.nbt(json.get("nbt"));
            } else {
                try {
                    nbt = TagParser.m_129359_((String)json.get("nbt").getAsString());
                }
                catch (CommandSyntaxException ex) {
                    return EmptyFluidStackJS.INSTANCE;
                }
            }
        }
        return FluidStackJS.of(fluid, amount, nbt);
    }

    public abstract String getId();

    public Collection<ResourceLocation> getTags() {
        return Tags.byFluid(this.getFluid());
    }

    public boolean hasTag(ResourceLocation tag) {
        return Tags.fluids().m_7689_(tag).m_8110_((Object)this.getFluid());
    }

    public Fluid getFluid() {
        Fluid f = (Fluid)KubeJSRegistries.fluids().get(new ResourceLocation(this.getId()));
        return f == null ? Fluids.f_76191_ : f;
    }

    public abstract FluidStack getFluidStack();

    public boolean isEmpty() {
        return this.getAmount() <= 0L;
    }

    public abstract long getAmount();

    public abstract void setAmount(long var1);

    public final FluidStackJS withAmount(long amount) {
        if (amount <= 0L) {
            return EmptyFluidStackJS.INSTANCE;
        }
        FluidStackJS fs = this.copy();
        fs.setAmount(amount);
        return fs;
    }

    @Nullable
    public abstract CompoundTag getNbt();

    public abstract void setNbt(@Nullable CompoundTag var1);

    public final FluidStackJS withNBT(@Nullable CompoundTag nbt) {
        FluidStackJS fs = this.copy();
        fs.setNbt(nbt);
        return fs;
    }

    public abstract FluidStackJS copy();

    public boolean hasChance() {
        return !Double.isNaN(this.chance);
    }

    public void removeChance() {
        this.setChance(Double.NaN);
    }

    public void setChance(double c) {
        this.chance = c;
    }

    public double getChance() {
        return this.chance;
    }

    public final FluidStackJS withChance(double c) {
        if (Double.isNaN(this.chance) && Double.isNaN(c) || this.chance == c) {
            return this;
        }
        FluidStackJS is = this.copy();
        is.setChance(c);
        return is;
    }

    public int hashCode() {
        return Objects.hash(this.getFluid(), this.getNbt());
    }

    public boolean equals(Object o) {
        if (o instanceof CharSequence) {
            return this.getId().equals(o.toString());
        }
        FluidStackJS f = FluidStackJS.of(o);
        if (f.isEmpty()) {
            return false;
        }
        return this.getFluid() == f.getFluid() && Objects.equals(this.getNbt(), f.getNbt());
    }

    public boolean strongEquals(Object o) {
        FluidStackJS f = FluidStackJS.of(o);
        if (f.isEmpty()) {
            return false;
        }
        return this.getAmount() == f.getAmount() && this.getFluid() == f.getFluid() && Objects.equals(this.getNbt(), f.getNbt());
    }

    public String toString() {
        long amount = this.getAmount();
        CompoundTag nbt = this.getNbt();
        StringBuilder builder = new StringBuilder();
        builder.append("Fluid.of('");
        builder.append(this.getId());
        if (amount != FluidStack.bucketAmount()) {
            builder.append(", ");
            builder.append(amount);
        }
        if (nbt != null) {
            builder.append(", ");
            NBTUtils.quoteAndEscapeForJS((StringBuilder)builder, (String)nbt.toString());
        }
        builder.append("')");
        if (this.hasChance()) {
            builder.append(".withChance(");
            builder.append(this.getChance());
            builder.append(')');
        }
        return builder.toString();
    }

    public JsonObject toJson() {
        JsonObject o = new JsonObject();
        o.addProperty("fluid", this.getId());
        if (this.getAmount() != FluidStack.bucketAmount()) {
            o.addProperty("amount", (Number)this.getAmount());
        }
        if (this.getNbt() != null) {
            o.add("nbt", (JsonElement)MapJS.json(this.getNbt()));
        }
        if (this.hasChance()) {
            o.addProperty("chance", (Number)this.getChance());
        }
        return o;
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        this.getFluidStack().write(tag);
        return tag;
    }
}

