/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.latvian.mods.kubejs.item.ItemHandler;
import dev.latvian.mods.kubejs.item.ItemHandlerUtils;
import dev.latvian.mods.kubejs.item.forge.ContainerInventoryImpl;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import org.jetbrains.annotations.NotNull;

public class ContainerInventory
implements ItemHandler.Mutable {
    private final Container container;

    public ContainerInventory(Container container) {
        this.container = container;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerInventory that = (ContainerInventory)o;
        return this.getInv().equals(that.getInv());
    }

    public int hashCode() {
        return this.getInv().hashCode();
    }

    @Override
    public int getSlots() {
        return this.getInv().m_6643_();
    }

    @Override
    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.getInv().m_8020_(slot);
    }

    @Override
    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = this.getInv().m_8020_(slot);
        if (!stackInSlot.m_41619_()) {
            if (stackInSlot.m_41613_() >= Math.min(stackInSlot.m_41741_(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemHandlerUtils.canItemStacksStack(stack, stackInSlot)) {
                return stack;
            }
            if (!this.getInv().m_7013_(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.m_41741_(), this.getSlotLimit(slot)) - stackInSlot.m_41613_();
            if (stack.m_41613_() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.m_41777_();
                    copy.m_41769_(stackInSlot.m_41613_());
                    this.getInv().m_6836_(slot, copy);
                    this.getInv().m_6596_();
                }
                return ItemStack.f_41583_;
            }
            stack = stack.m_41777_();
            if (!simulate) {
                ItemStack copy = stack.m_41620_(m);
                copy.m_41769_(stackInSlot.m_41613_());
                this.getInv().m_6836_(slot, copy);
                this.getInv().m_6596_();
                return stack;
            }
            stack.m_41774_(m);
            return stack;
        }
        if (!this.getInv().m_7013_(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.m_41741_(), this.getSlotLimit(slot));
        if (m < stack.m_41613_()) {
            stack = stack.m_41777_();
            if (!simulate) {
                this.getInv().m_6836_(slot, stack.m_41620_(m));
                this.getInv().m_6596_();
                return stack;
            }
            stack.m_41774_(m);
            return stack;
        }
        if (!simulate) {
            this.getInv().m_6836_(slot, stack);
            this.getInv().m_6596_();
        }
        return ItemStack.f_41583_;
    }

    @Override
    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = this.getInv().m_8020_(slot);
        if (stackInSlot.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (simulate) {
            if (stackInSlot.m_41613_() < amount) {
                return stackInSlot.m_41777_();
            }
            ItemStack copy = stackInSlot.m_41777_();
            copy.m_41764_(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.m_41613_(), amount);
        ItemStack decrStackSize = this.getInv().m_7407_(slot, m);
        this.getInv().m_6596_();
        return decrStackSize;
    }

    @Override
    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.getInv().m_6836_(slot, stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.getInv().m_6893_();
    }

    @Override
    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.getInv().m_7013_(slot, stack);
    }

    public Container getInv() {
        return this.container;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean areCapsCompatible(ItemStack a, ItemStack b) {
        void var1_1;
        return ContainerInventoryImpl.areCapsCompatible(a, (ItemStack)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemStack getContainerItem(ItemStack stack) {
        return ContainerInventoryImpl.getContainerItem(stack);
    }

    @Override
    public int getWidth() {
        int n;
        if (this.container instanceof ChestBlockEntity) {
            return 9;
        }
        Container container = this.container;
        if (container instanceof CraftingContainer) {
            CraftingContainer crafter = (CraftingContainer)container;
            n = crafter.m_39347_();
        } else {
            n = this.getSlots();
        }
        return n;
    }

    @Override
    public int getHeight() {
        int n;
        if (this.container instanceof ChestBlockEntity) {
            return this.getSlots() / 9;
        }
        Container container = this.container;
        if (container instanceof CraftingContainer) {
            CraftingContainer crafter = (CraftingContainer)container;
            n = crafter.m_39346_();
        } else {
            n = 1;
        }
        return n;
    }
}

