/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.bindings.RarityWrapper;
import dev.latvian.mods.kubejs.item.FoodBuilder;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.type.ArmorItemType;
import dev.latvian.mods.kubejs.item.type.BasicItemType;
import dev.latvian.mods.kubejs.item.type.ItemType;
import dev.latvian.mods.kubejs.util.BuilderBase;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import org.jetbrains.annotations.Nullable;

public class ItemBuilder
extends BuilderBase {
    public static final Map<String, Tier> TOOL_TIERS = new HashMap<String, Tier>();
    public static final Map<String, ArmorMaterial> ARMOR_TIERS = new HashMap<String, ArmorMaterial>();
    public transient ItemType type = BasicItemType.INSTANCE;
    public transient int maxStackSize = 64;
    public transient int maxDamage = 0;
    public transient int burnTime = 0;
    public transient String containerItem = "minecraft:air";
    public transient Function<ItemStackJS, Collection<ItemStackJS>> subtypes = null;
    public transient float miningSpeed = 1.0f;
    public transient Float attackDamage;
    public transient Float attackSpeed;
    public transient RarityWrapper rarity = RarityWrapper.COMMON;
    public transient boolean glow = false;
    public final transient List<Component> tooltip = new ArrayList<Component>();
    public transient CreativeModeTab group = KubeJS.tab;
    public transient Int2IntOpenHashMap color = new Int2IntOpenHashMap();
    public String texture;
    public String parentModel;
    public transient FoodBuilder foodBuilder;
    public transient Tier toolTier;
    public transient float attackDamageBaseline;
    public transient float attackSpeedBaseline;
    public transient ArmorMaterial armorTier;
    public transient Item item;
    public JsonObject modelJson;

    public ItemBuilder(String i) {
        super(i);
        this.color.defaultReturnValue(-1);
        this.texture = "";
        this.parentModel = "";
        this.foodBuilder = null;
        this.toolTier = Tiers.IRON;
        this.armorTier = ArmorMaterials.IRON;
        this.displayName = "";
        this.modelJson = null;
    }

    @Override
    public String getBuilderType() {
        return "item";
    }

    public ItemBuilder type(ItemType t) {
        this.type = t;
        this.type.applyDefaults(this);
        return this;
    }

    public ItemBuilder tier(String t) {
        if (this.type == BasicItemType.INSTANCE) {
            return this;
        }
        if (this.type instanceof ArmorItemType) {
            this.armorTier = ARMOR_TIERS.getOrDefault(t, (ArmorMaterial)ArmorMaterials.IRON);
            return this;
        }
        this.toolTier = TOOL_TIERS.getOrDefault(t, (Tier)Tiers.IRON);
        return this;
    }

    public ItemBuilder maxStackSize(int v) {
        this.maxStackSize = v;
        return this;
    }

    public ItemBuilder unstackable() {
        return this.maxStackSize(1);
    }

    public ItemBuilder maxDamage(int v) {
        this.maxDamage = v;
        return this;
    }

    public ItemBuilder burnTime(int v) {
        this.burnTime = v;
        return this;
    }

    public ItemBuilder containerItem(String id) {
        this.containerItem = id;
        return this;
    }

    public ItemBuilder subtypes(Function<ItemStackJS, Collection<ItemStackJS>> fn) {
        this.subtypes = fn;
        return this;
    }

    public ItemBuilder miningSpeed(float f) {
        this.miningSpeed = f;
        ConsoleJS.STARTUP.warn("You should be using a 'pickaxe' or other tool type item if you want to modify mining speed!");
        return this;
    }

    public ItemBuilder attackDamage(float f) {
        this.attackDamage = Float.valueOf(f);
        ConsoleJS.STARTUP.warn("You should be using a 'sword' type item if you want to modify attack damage!");
        return this;
    }

    public ItemBuilder attackSpeed(float f) {
        this.attackSpeed = Float.valueOf(f);
        ConsoleJS.STARTUP.warn("You should be using a 'sword' type item if you want to modify attack speed!");
        return this;
    }

    public ItemBuilder rarity(RarityWrapper v) {
        this.rarity = v;
        return this;
    }

    public ItemBuilder glow(boolean v) {
        this.glow = v;
        return this;
    }

    public ItemBuilder tooltip(Component text) {
        this.tooltip.add(text);
        return this;
    }

    public ItemBuilder group(String g) {
        for (CreativeModeTab ig : CreativeModeTab.f_40748_) {
            if (!ig.m_40783_().equals(g)) continue;
            this.group = ig;
            return this;
        }
        return this;
    }

    public ItemBuilder color(int index, int c) {
        this.color.put(index, 0xFF000000 | c);
        return this;
    }

    public ItemBuilder texture(String tex) {
        this.texture = tex;
        return this;
    }

    public ItemBuilder parentModel(String m) {
        this.parentModel = m;
        return this;
    }

    public ItemBuilder food(Consumer<FoodBuilder> b) {
        this.foodBuilder = new FoodBuilder();
        b.accept(this.foodBuilder);
        return this;
    }

    public float getMiningSpeed() {
        return this.miningSpeed;
    }

    @Nullable
    public Float getAttackDamage() {
        return this.attackDamage;
    }

    @Nullable
    public Float getAttackSpeed() {
        return this.attackSpeed;
    }

    public Item.Properties createItemProperties() {
        Item.Properties properties = new Item.Properties();
        properties.m_41491_(this.group);
        if (this.maxDamage > 0) {
            properties.m_41503_(this.maxDamage);
        } else {
            properties.m_41487_(this.maxStackSize);
        }
        properties.m_41497_(this.rarity.rarity);
        Item item = (Item)KubeJSRegistries.items().get(new ResourceLocation(this.containerItem));
        if (item != Items.f_41852_) {
            properties.m_41495_(item);
        }
        if (this.foodBuilder != null) {
            properties.m_41489_(this.foodBuilder.build());
        }
        return properties;
    }

    static {
        for (Tiers tiers : Tiers.values()) {
            TOOL_TIERS.put(tiers.toString().toLowerCase(), (Tier)tiers);
        }
        for (Tiers tiers : ArmorMaterials.values()) {
            ARMOR_TIERS.put(tiers.toString().toLowerCase(), (ArmorMaterial)tiers);
        }
    }
}

