/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.registry.registries.Registries;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.core.ItemStackKJS;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.item.DummyFluidItemStackJS;
import dev.latvian.mods.kubejs.item.DummyItemStackJSIngredient;
import dev.latvian.mods.kubejs.item.ingredient.GroupIngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.IgnoreNBTIngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientStackJS;
import dev.latvian.mods.kubejs.item.ingredient.MatchAllIngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.ModIngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.RegexIngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.TagIngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.WeakNBTIngredientJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.text.Text;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.Tags;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.mod.util.ChangeListener;
import dev.latvian.mods.rhino.mod.util.NBTSerializable;
import dev.latvian.mods.rhino.mod.util.NBTUtils;
import dev.latvian.mods.rhino.mod.util.TagUtils;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import dev.latvian.mods.rhino.util.SpecialEquality;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class ItemStackJS
implements IngredientJS,
NBTSerializable,
ChangeListener<Tag>,
SpecialEquality {
    public static final ItemStackJS EMPTY = new ItemStackJS(ItemStack.f_41583_){

        @Override
        public String getId() {
            return "minecraft:air";
        }

        @Override
        public Collection<ResourceLocation> getTags() {
            return Collections.emptySet();
        }

        @Override
        public boolean hasTag(ResourceLocation tag) {
            return false;
        }

        @Override
        public Item getItem() {
            return Items.f_41852_;
        }

        @Override
        public ItemStackJS copy() {
            return this;
        }

        @Override
        public void setCount(int c) {
        }

        @Override
        public int getCount() {
            return 0;
        }

        @Override
        public ItemStackJS withCount(int c) {
            return this;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @Nullable
        public CompoundTag getNbt() {
            return null;
        }

        @Override
        public void setNbt(@Nullable CompoundTag tag) {
        }

        @Override
        public boolean hasNBT() {
            return false;
        }

        @Override
        public String getNbtString() {
            return "null";
        }

        @Override
        public ItemStackJS removeNBT() {
            return this;
        }

        @Override
        public ItemStackJS withNBT(CompoundTag nbt) {
            return this;
        }

        @Override
        public void setChance(double c) {
        }

        @Override
        public double getChance() {
            return Double.NaN;
        }

        @Override
        public boolean hasChance() {
            return false;
        }

        @Override
        public String toString() {
            return "Item.empty";
        }

        @Override
        public boolean test(ItemStackJS other) {
            return false;
        }

        @Override
        public boolean testVanilla(ItemStack other) {
            return false;
        }

        @Override
        public boolean testVanillaItem(Item item) {
            return false;
        }

        @Override
        public Set<ItemStackJS> getStacks() {
            return Collections.emptySet();
        }

        @Override
        public Set<Item> getVanillaItems() {
            return Collections.emptySet();
        }

        @Override
        public ItemStackJS getFirst() {
            return this;
        }

        @Override
        public IngredientJS not() {
            return MatchAllIngredientJS.INSTANCE;
        }

        @Override
        public ItemStackJS withName(@Nullable Component displayName) {
            return this;
        }

        @Override
        public MapJS getEnchantments() {
            return new MapJS(){

                @Override
                protected boolean setChangeListener(@Nullable Object v) {
                    return false;
                }
            };
        }

        @Override
        public boolean hasEnchantment(Enchantment enchantment, int level) {
            return false;
        }

        @Override
        public ItemStackJS enchant(MapJS map) {
            return this;
        }

        @Override
        public ItemStackJS enchant(Enchantment enchantment, int level) {
            return this;
        }

        @Override
        public String getMod() {
            return "minecraft";
        }

        @Override
        public boolean areItemsEqual(ItemStackJS other) {
            return other.isEmpty();
        }

        @Override
        public boolean areItemsEqual(ItemStack other) {
            return other.m_41619_();
        }

        @Override
        public boolean isNBTEqual(ItemStackJS other) {
            return !other.hasNBT();
        }

        @Override
        public boolean isNBTEqual(ItemStack other) {
            return !other.m_41782_();
        }

        @Override
        public boolean equals(Object o) {
            return 1.of(o).isEmpty();
        }

        @Override
        public boolean strongEquals(Object o) {
            return 1.of(o).isEmpty();
        }

        @Override
        public JsonElement toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("item", "minecraft:air");
            return json;
        }

        @Override
        public JsonElement toRawResultJson() {
            JsonObject json = new JsonObject();
            json.addProperty("item", "minecraft:air");
            json.addProperty("count", (Number)1);
            return json;
        }

        @Override
        public void onChanged(@Nullable Tag o) {
        }

        @Override
        public String getItemGroup() {
            return "";
        }
    };
    private static List<ItemStackJS> cachedItemList;
    private static ListJS cachedItemListJS;
    private static ListJS cachedItemTypeListJS;
    private final ItemStack stack;
    private double chance = Double.NaN;

    public static ItemStackJS of(@Nullable Object o) {
        if (o instanceof Wrapper) {
            Wrapper w = (Wrapper)o;
            o = w.unwrap();
        }
        if (o == null || o == ItemStack.f_41583_ || o == Items.f_41852_) {
            return EMPTY;
        }
        if (o instanceof ItemStackJS) {
            ItemStackJS js = (ItemStackJS)o;
            return js;
        }
        if (o instanceof FluidStackJS) {
            FluidStackJS fluidStack = (FluidStackJS)o;
            return new DummyFluidItemStackJS(fluidStack);
        }
        if (o instanceof IngredientJS) {
            IngredientJS ingr = (IngredientJS)o;
            return ingr.getFirst();
        }
        if (o instanceof ItemStack) {
            ItemStack stack = (ItemStack)o;
            return stack.m_41619_() ? EMPTY : new ItemStackJS(stack);
        }
        if (o instanceof ResourceLocation) {
            ResourceLocation id = (ResourceLocation)o;
            Item item = (Item)KubeJSRegistries.items().get(id);
            if (item == Items.f_41852_) {
                if (RecipeJS.itemErrors) {
                    throw new RecipeExceptionJS("Item '" + id + "' not found!").error();
                }
                return EMPTY;
            }
            return new ItemStackJS(new ItemStack((ItemLike)item));
        }
        if (o instanceof ItemLike) {
            ItemLike itemLike = (ItemLike)o;
            return new ItemStackJS(new ItemStack((ItemLike)itemLike.m_5456_()));
        }
        if (o instanceof JsonElement) {
            JsonElement json = (JsonElement)o;
            return ItemStackJS.resultFromRecipeJson(json);
        }
        if (o instanceof Pattern || o instanceof NativeRegExp) {
            Pattern reg = UtilsJS.parseRegex(o);
            if (reg != null) {
                return new RegexIngredientJS(reg).getFirst();
            }
            return EMPTY;
        }
        if (o instanceof CharSequence) {
            String s = o.toString().trim();
            int count = 1;
            int spaceIndex = s.indexOf(32);
            if (spaceIndex >= 2 && s.indexOf(120) == spaceIndex - 1) {
                count = Integer.parseInt(s.substring(0, spaceIndex - 1));
                s = s.substring(spaceIndex + 1);
            }
            if (s.isEmpty() || s.equals("-") || s.equals("air") || s.equals("minecraft:air")) {
                return EMPTY;
            }
            if (s.startsWith("#")) {
                return TagIngredientJS.createTag(s.substring(1)).getFirst().withCount(count);
            }
            if (s.startsWith("@")) {
                return new ModIngredientJS(s.substring(1)).getFirst().withCount(count);
            }
            if (s.startsWith("%")) {
                CreativeModeTab group = ItemStackJS.findGroup(s.substring(1));
                if (group == null) {
                    if (RecipeJS.itemErrors) {
                        throw new RecipeExceptionJS("Item group '" + s.substring(1) + "' not found!").error();
                    }
                    return EMPTY;
                }
                return new GroupIngredientJS(group).getFirst().withCount(count);
            }
            Pattern reg = UtilsJS.parseRegex(s);
            if (reg != null) {
                return new RegexIngredientJS(reg).getFirst().withCount(count);
            }
            Item item = (Item)KubeJSRegistries.items().get(new ResourceLocation(s));
            if (item == Items.f_41852_) {
                if (RecipeJS.itemErrors) {
                    throw new RecipeExceptionJS("Item '" + s + "' not found!").error();
                }
                return EMPTY;
            }
            return new ItemStackJS(new ItemStack((ItemLike)item, count));
        }
        MapJS map = MapJS.of(o);
        if (map != null) {
            if (map.containsKey("item")) {
                String id = KubeJS.appendModId(map.get("item").toString());
                Item item = (Item)KubeJSRegistries.items().get(new ResourceLocation(id));
                if (item == Items.f_41852_) {
                    if (RecipeJS.itemErrors) {
                        throw new RecipeExceptionJS("Item '" + id + "' not found!").error();
                    }
                    return EMPTY;
                }
                ItemStack stack = new ItemStack((ItemLike)item);
                Object v = map.get("count");
                if (v instanceof Number) {
                    Number number = (Number)v;
                    stack.m_41764_(number.intValue());
                }
                if (map.containsKey("nbt")) {
                    stack.m_41751_(MapJS.nbt(map.get("nbt")));
                }
                return new ItemStackJS(stack);
            }
            Object id = map.get("tag");
            if (id instanceof CharSequence) {
                CharSequence s = (CharSequence)id;
                ItemStackJS stack = TagIngredientJS.createTag(s.toString()).getFirst();
                if (map.containsKey("count")) {
                    stack.setCount(UtilsJS.parseInt(map.get("count"), 1));
                }
                return stack;
            }
            if (map.get("fluid") instanceof CharSequence) {
                return new DummyFluidItemStackJS(FluidStackJS.of(map));
            }
        }
        return EMPTY;
    }

    public static Item getRawItem(@Nullable Object o) {
        if (o == null) {
            return Items.f_41852_;
        }
        if (o instanceof Item) {
            Item item = (Item)o;
            return item;
        }
        if (o instanceof CharSequence) {
            String s = o.toString();
            if (s.isEmpty()) {
                return Items.f_41852_;
            }
            if (s.charAt(0) != '#') {
                return (Item)KubeJSRegistries.items().get(UtilsJS.getMCID(s));
            }
        }
        return ItemStackJS.of(o).getItem();
    }

    public static ItemStackJS resultFromRecipeJson(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return EMPTY;
        }
        if (json.isJsonPrimitive()) {
            return ItemStackJS.of(json.getAsString());
        }
        if (json.isJsonObject()) {
            ItemStackJS is;
            JsonObject o = json.getAsJsonObject();
            if (RecipeJS.currentRecipe != null && (is = RecipeJS.currentRecipe.resultFromRecipeJson(o)) != null) {
                return is;
            }
            if (o.has("item")) {
                ItemStackJS stack = ItemStackJS.of(o.get("item").getAsString());
                if (o.has("count")) {
                    stack.setCount(o.get("count").getAsInt());
                }
                if (o.has("nbt")) {
                    JsonElement element = o.get("nbt");
                    stack = element.isJsonObject() ? stack.withNBT(MapJS.nbt(element)) : stack.withNBT(MapJS.nbt(element.getAsString()));
                }
                if (o.has("chance")) {
                    boolean locked = o.has("locked") && o.get("locked").getAsBoolean();
                    double c = o.get("chance").getAsDouble();
                    stack.setChance(locked ? -c : c);
                }
                return stack;
            }
            if (o.has("tag")) {
                int c = 1;
                if (o.has("count")) {
                    c = o.get("count").getAsInt();
                } else if (o.has("amount")) {
                    c = o.get("amount").getAsInt();
                }
                return TagIngredientJS.createTag(o.get("tag").getAsString()).getFirst().withCount(c);
            }
        }
        return EMPTY;
    }

    public static List<ItemStackJS> getList() {
        if (cachedItemList != null) {
            return cachedItemList;
        }
        LinkedHashSet<ItemStackJS> set = new LinkedHashSet<ItemStackJS>();
        NonNullList stackList = NonNullList.m_122779_();
        for (Item item : KubeJSRegistries.items()) {
            try {
                item.m_6787_(CreativeModeTab.f_40754_, stackList);
            }
            catch (Throwable throwable) {}
        }
        for (ItemStack stack : stackList) {
            if (stack.m_41619_()) continue;
            set.add(new ItemStackJS(stack).withCount(1));
        }
        cachedItemList = List.of(set.toArray(new ItemStackJS[0]));
        return cachedItemList;
    }

    public static ListJS getListJS() {
        if (cachedItemListJS == null) {
            cachedItemListJS = Objects.requireNonNull(ListJS.of(ItemStackJS.getList()));
        }
        return cachedItemListJS;
    }

    public static void clearListCache() {
        cachedItemList = null;
        cachedItemListJS = null;
    }

    public static ListJS getTypeList() {
        if (cachedItemTypeListJS == null) {
            cachedItemTypeListJS = new ListJS();
            for (ResourceLocation id : KubeJSRegistries.items().getIds()) {
                cachedItemTypeListJS.add(id.toString());
            }
        }
        return cachedItemTypeListJS;
    }

    @Nullable
    public static CreativeModeTab findGroup(String id) {
        for (CreativeModeTab group : CreativeModeTab.f_40748_) {
            if (!id.equals(group.m_40783_())) continue;
            return group;
        }
        return null;
    }

    public ItemStackJS(ItemStack s) {
        this.stack = s;
    }

    public Item getItem() {
        return this.stack.m_41720_();
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public String getId() {
        return Registries.getId((Object)this.getItem(), (ResourceKey)Registry.f_122904_).toString();
    }

    public Collection<ResourceLocation> getTags() {
        return Tags.byItem(this.getItem());
    }

    public boolean hasTag(ResourceLocation tag) {
        return Tags.items().m_7689_(tag).m_8110_((Object)this.getItem());
    }

    @Override
    public ItemStackJS copy() {
        ItemStackJS s = new ItemStackJS(this.stack.m_41777_());
        s.chance = this.chance;
        if (!this.hasNBT()) {
            ((ItemStackKJS)s.stack).removeTagKJS();
        }
        return s;
    }

    public void setCount(int count) {
        this.stack.m_41764_(count);
    }

    @Override
    public int getCount() {
        return this.stack.m_41613_();
    }

    @Override
    public ItemStackJS withCount(int c) {
        if (c <= 0) {
            return EMPTY;
        }
        ItemStackJS is = this.copy();
        is.setCount(c);
        return is;
    }

    @Override
    public boolean isEmpty() {
        return this.stack.m_41619_();
    }

    @Override
    public boolean isInvalidRecipeIngredient() {
        return this.stack.m_41619_();
    }

    public boolean isBlock() {
        return this.stack.m_41720_() instanceof BlockItem;
    }

    @Nullable
    public CompoundTag getNbt() {
        return this.stack.m_41783_();
    }

    public void setNbt(@Nullable CompoundTag tag) {
        this.stack.m_41751_(tag);
    }

    public boolean hasNBT() {
        return this.stack.m_41782_();
    }

    public String getNbtString() {
        return String.valueOf(this.getNbt());
    }

    public ItemStackJS removeNBT() {
        ItemStackJS s = this.copy();
        ((ItemStackKJS)s.stack).removeTagKJS();
        return s;
    }

    public ItemStackJS withNBT(CompoundTag nbt) {
        ItemStack is = this.stack.m_41777_();
        if (is.m_41783_() == null) {
            is.m_41751_(nbt);
        } else if (nbt != null && !nbt.m_128456_()) {
            for (String key : nbt.m_128431_()) {
                is.m_41783_().m_128365_(key, nbt.m_128423_(key));
            }
        }
        return new ItemStackJS(is).withChance(this.getChance());
    }

    public boolean hasChance() {
        return !Double.isNaN(this.chance);
    }

    public void removeChance() {
        this.setChance(Double.NaN);
    }

    public void setChance(double c) {
        this.chance = c;
    }

    public double getChance() {
        return this.chance;
    }

    public final ItemStackJS withChance(double c) {
        if (Double.isNaN(this.chance) && Double.isNaN(c) || this.chance == c) {
            return this;
        }
        ItemStackJS is = this.copy();
        is.setChance(c);
        return is;
    }

    public Text getName() {
        return Text.of(this.getItemStack().m_41786_());
    }

    public ItemStackJS withName(@Nullable Component displayName) {
        ItemStack is = this.stack.m_41777_();
        if (displayName != null) {
            is.m_41714_(displayName);
        } else {
            is.m_41787_();
        }
        return new ItemStackJS(is);
    }

    public String toString() {
        boolean hasChanceOrNbt;
        StringBuilder builder = new StringBuilder();
        int count = this.getCount();
        boolean bl = hasChanceOrNbt = this.hasChance() || this.hasNBT();
        if (count > 1 && !hasChanceOrNbt) {
            builder.append('\'');
            builder.append(count);
            builder.append("x ");
            builder.append(this.getId());
            builder.append('\'');
        } else if (hasChanceOrNbt) {
            builder.append("Item.of('");
            builder.append(this.getId());
            builder.append('\'');
            ArrayList<Pair> enchants = null;
            if (count > 1) {
                builder.append(", ");
                builder.append(count);
            }
            if (this.hasNBT()) {
                CompoundTag t = this.getNbt();
                if (t != null && !t.m_128456_()) {
                    String key;
                    String string = key = this.getItem() == Items.f_42690_ ? "StoredEnchantments" : "Enchantments";
                    if (t.m_128425_(key, 9)) {
                        ListTag l = t.m_128437_(key, 10);
                        enchants = new ArrayList<Pair>(l.size());
                        for (int i = 0; i < l.size(); ++i) {
                            CompoundTag t1 = l.m_128728_(i);
                            enchants.add(Pair.of((Object)t1.m_128461_("id"), (Object)t1.m_128451_("lvl")));
                        }
                        t = t.m_6426_();
                        t.m_128473_(key);
                        if (t.m_128456_()) {
                            t = null;
                        }
                    }
                }
                if (t != null) {
                    builder.append(", ");
                    NBTUtils.quoteAndEscapeForJS((StringBuilder)builder, (String)t.toString());
                }
            }
            builder.append(')');
            if (enchants != null) {
                for (Pair e : enchants) {
                    builder.append(".enchant('");
                    builder.append((String)e.getKey());
                    builder.append("', ");
                    builder.append(e.getValue());
                    builder.append(')');
                }
            }
            if (this.hasChance()) {
                builder.append(".withChance(");
                builder.append(this.getChance());
                builder.append(')');
            }
        } else {
            builder.append('\'');
            builder.append(this.getId());
            builder.append('\'');
        }
        return builder.toString();
    }

    @Override
    public boolean test(ItemStackJS other) {
        return this.testVanilla(other.stack);
    }

    @Override
    public boolean testVanilla(ItemStack other) {
        if (this.stack.m_41720_() == other.m_41720_()) {
            CompoundTag nbt = this.stack.m_41783_();
            CompoundTag nbt2 = other.m_41783_();
            return Objects.equals(nbt, nbt2);
        }
        return false;
    }

    @Override
    public boolean testVanillaItem(Item item) {
        return item == this.getItem();
    }

    @Override
    public Set<ItemStackJS> getStacks() {
        return Collections.singleton(this);
    }

    @Override
    public Set<Item> getVanillaItems() {
        return Collections.singleton(this.getItem());
    }

    @Override
    public ItemStackJS getFirst() {
        return this.copy();
    }

    public int hashCode() {
        return Objects.hash(this.getItem(), this.hasNBT() ? this.getNbt() : Integer.valueOf(0));
    }

    public boolean equals(Object o) {
        if (o instanceof CharSequence) {
            return this.getId().equals(UtilsJS.getID(o.toString()));
        }
        if (o instanceof ItemStack) {
            ItemStack s = (ItemStack)o;
            return !s.m_41619_() && this.areItemsEqual(s) && this.isNBTEqual(s);
        }
        ItemStackJS s = ItemStackJS.of(o);
        return !s.isEmpty() && this.areItemsEqual(s) && this.isNBTEqual(s);
    }

    public boolean strongEquals(Object o) {
        if (o instanceof CharSequence) {
            return this.getId().equals(UtilsJS.getID(o.toString())) && this.getCount() == 1 && !this.hasNBT();
        }
        if (o instanceof ItemStack) {
            ItemStack s = (ItemStack)o;
            return this.getCount() == s.m_41613_() && this.areItemsEqual(s) && this.isNBTEqual(s);
        }
        ItemStackJS s = ItemStackJS.of(o);
        return this.getCount() == s.getCount() && this.areItemsEqual(s) && this.isNBTEqual(s);
    }

    public MapJS getEnchantments() {
        MapJS map = new MapJS();
        for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)this.getItemStack()).entrySet()) {
            ResourceLocation id = KubeJSRegistries.enchantments().getId((Object)((Enchantment)entry.getKey()));
            if (id == null) continue;
            map.put(id.toString(), entry.getValue());
        }
        return map;
    }

    public boolean hasEnchantment(Enchantment enchantment, int level) {
        return EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)this.stack) >= level;
    }

    public ItemStackJS enchant(MapJS enchantments) {
        ItemStackJS is = this;
        for (Map.Entry entry : enchantments.entrySet()) {
            Object v;
            Enchantment enchantment = (Enchantment)KubeJSRegistries.enchantments().get(UtilsJS.getMCID(entry.getKey()));
            if (enchantment == null || !((v = entry.getValue()) instanceof Number)) continue;
            Number number = (Number)v;
            is = is.enchant(enchantment, number.intValue());
        }
        return is;
    }

    public ItemStackJS enchant(Enchantment enchantment, int level) {
        ItemStack is = this.stack.m_41777_();
        if (is.m_41720_() == Items.f_42690_) {
            EnchantedBookItem.m_41153_((ItemStack)is, (EnchantmentInstance)new EnchantmentInstance(enchantment, level));
        } else {
            is.m_41663_(enchantment, level);
        }
        return new ItemStackJS(is).withChance(this.getChance());
    }

    public String getMod() {
        return Registries.getId((Object)this.getItem(), (ResourceKey)Registry.f_122904_).m_135827_();
    }

    public IngredientJS ignoreNBT() {
        return new IgnoreNBTIngredientJS(this);
    }

    public IngredientJS weakNBT() {
        return new WeakNBTIngredientJS(this);
    }

    public boolean areItemsEqual(ItemStackJS other) {
        return this.getItem() == other.getItem();
    }

    public boolean areItemsEqual(ItemStack other) {
        return this.getItem() == other.m_41720_();
    }

    public boolean isNBTEqual(ItemStackJS other) {
        if (this.hasNBT() == other.hasNBT()) {
            CompoundTag nbt = this.stack.m_41783_();
            CompoundTag nbt2 = other.getNbt();
            return Objects.equals(nbt, nbt2);
        }
        return false;
    }

    public boolean isNBTEqual(ItemStack other) {
        if (this.hasNBT() == other.m_41782_()) {
            CompoundTag nbt = this.stack.m_41783_();
            CompoundTag nbt2 = other.m_41783_();
            return Objects.equals(nbt, nbt2);
        }
        return false;
    }

    public float getHarvestSpeed(@Nullable BlockContainerJS block) {
        return this.getItemStack().m_41691_(block == null ? Blocks.f_50016_.m_49966_() : block.getBlockState());
    }

    public float getHarvestSpeed() {
        return this.getHarvestSpeed(null);
    }

    @Override
    public JsonElement toJson() {
        int c = this.getCount();
        if (c == 1) {
            return new DummyItemStackJSIngredient(this).toJson();
        }
        return new IngredientStackJS(new DummyItemStackJSIngredient(this), c).toJson();
    }

    public JsonElement toResultJson() {
        JsonElement e;
        if (RecipeJS.currentRecipe != null && (e = RecipeJS.currentRecipe.serializeItemStack(this)) != null) {
            return e;
        }
        return this.toRawResultJson();
    }

    public JsonElement toRawResultJson() {
        JsonObject json = new JsonObject();
        json.addProperty("item", this.getId());
        json.addProperty("count", (Number)this.getCount());
        CompoundTag nbt = this.getNbt();
        if (nbt != null) {
            if (RecipeJS.currentRecipe != null && RecipeJS.currentRecipe.serializeNBTAsJson()) {
                json.add("nbt", TagUtils.toJson((Tag)nbt));
            } else {
                json.addProperty("nbt", nbt.toString());
            }
        }
        if (this.hasChance()) {
            json.addProperty("chance", (Number)this.getChance());
        }
        return json;
    }

    public CompoundTag toNBT() {
        return this.getItemStack().m_41739_(new CompoundTag());
    }

    public void onChanged(@Nullable Tag o) {
        if (o == null || o instanceof CompoundTag) {
            this.stack.m_41751_((CompoundTag)o);
        }
    }

    public String getItemGroup() {
        if (this.getItem().m_41471_() == null) {
            return "";
        }
        return this.getItem().m_41471_().m_40783_();
    }

    @Override
    public Set<String> getItemIds() {
        return Collections.singleton(this.getId());
    }

    @Nullable
    public FluidStackJS getFluidStack() {
        return null;
    }
}

