/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSObjects;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.block.DetectorInstance;
import dev.latvian.mods.kubejs.core.ItemKJS;
import dev.latvian.mods.kubejs.fluid.FluidBuilder;
import dev.latvian.mods.kubejs.item.BlockItemJS;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.item.ItemCraftedEventJS;
import dev.latvian.mods.kubejs.item.ItemEntityInteractEventJS;
import dev.latvian.mods.kubejs.item.ItemLeftClickEventJS;
import dev.latvian.mods.kubejs.item.ItemPickupEventJS;
import dev.latvian.mods.kubejs.item.ItemRightClickEmptyEventJS;
import dev.latvian.mods.kubejs.item.ItemRightClickEventJS;
import dev.latvian.mods.kubejs.item.ItemSmeltedEventJS;
import dev.latvian.mods.kubejs.item.ItemTossEventJS;
import dev.latvian.mods.kubejs.item.forge.KubeJSItemEventHandlerImpl;
import dev.latvian.mods.kubejs.player.InventoryChangedEventJS;
import java.util.Iterator;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class KubeJSItemEventHandler {
    public static Supplier<Item> DUMMY_FLUID_ITEM = () -> Items.f_42263_;

    public static void init() {
        if (!CommonProperties.get().serverOnly) {
            KubeJSItemEventHandler.registry();
        }
        InteractionEvent.RIGHT_CLICK_ITEM.register(KubeJSItemEventHandler::rightClick);
        InteractionEvent.CLIENT_RIGHT_CLICK_AIR.register(KubeJSItemEventHandler::rightClickEmpty);
        InteractionEvent.CLIENT_LEFT_CLICK_AIR.register(KubeJSItemEventHandler::leftClickEmpty);
        PlayerEvent.PICKUP_ITEM_PRE.register(KubeJSItemEventHandler::pickup);
        PlayerEvent.DROP_ITEM.register(KubeJSItemEventHandler::drop);
        InteractionEvent.INTERACT_ENTITY.register(KubeJSItemEventHandler::entityInteract);
        PlayerEvent.CRAFT_ITEM.register(KubeJSItemEventHandler::crafted);
        PlayerEvent.SMELT_ITEM.register(KubeJSItemEventHandler::smelted);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static BucketItem buildBucket(FluidBuilder builder) {
        return KubeJSItemEventHandlerImpl.buildBucket(builder);
    }

    private static void registry() {
        ItemKJS kjs;
        Item item;
        Iterator<Object> iterator = KubeJSObjects.ITEMS.values().iterator();
        while (iterator.hasNext()) {
            ItemBuilder itemBuilder;
            (itemBuilder = iterator.next()).item = itemBuilder.type.createItem(itemBuilder);
            item = (itemBuilder = iterator.next()).item;
            if (item instanceof ItemKJS) {
                kjs = (ItemKJS)item;
                kjs.setItemBuilderKJS(itemBuilder);
            }
            KubeJSRegistries.items().register(itemBuilder.id, () -> builder.item);
        }
        for (BlockBuilder blockBuilder : KubeJSObjects.BLOCKS.values()) {
            if (blockBuilder.itemBuilder == null) continue;
            blockBuilder.itemBuilder.blockItem = new BlockItemJS(blockBuilder.itemBuilder);
            item = blockBuilder.itemBuilder.blockItem;
            if (item instanceof ItemKJS) {
                kjs = (ItemKJS)item;
                kjs.setItemBuilderKJS(blockBuilder.itemBuilder);
            }
            KubeJSRegistries.items().register(blockBuilder.id, () -> builder.itemBuilder.blockItem);
        }
        for (FluidBuilder fluidBuilder : KubeJSObjects.FLUIDS.values()) {
            fluidBuilder.bucketItem = KubeJSItemEventHandler.buildBucket(fluidBuilder);
            KubeJSRegistries.items().register(fluidBuilder.newID("", "_bucket"), () -> builder.bucketItem);
        }
        for (DetectorInstance detectorInstance : KubeJSObjects.DETECTORS.values()) {
            detectorInstance.item = KubeJSRegistries.items().register(KubeJS.id("detector_" + detectorInstance.id), () -> new BlockItem(detector.block.get(), new Item.Properties().m_41491_(KubeJS.tab)));
        }
        if (!CommonProperties.get().serverOnly) {
            DUMMY_FLUID_ITEM = KubeJSRegistries.items().register(KubeJS.id("dummy_fluid_item"), () -> new Item(new Item.Properties().m_41487_(1).m_41491_(KubeJS.tab)));
        }
    }

    private static CompoundEventResult<ItemStack> rightClick(Player player, InteractionHand hand) {
        if (!player.m_36335_().m_41519_(player.m_21120_(hand).m_41720_()) && new ItemRightClickEventJS(player, hand).post("item.right_click")) {
            return CompoundEventResult.interruptTrue((Object)player.m_21120_(hand));
        }
        return CompoundEventResult.pass();
    }

    private static void rightClickEmpty(Player player, InteractionHand hand) {
        if (player != null && player.f_19853_ != null) {
            new ItemRightClickEmptyEventJS(player, hand).post("item.right_click_empty");
        }
    }

    private static void leftClickEmpty(Player player, InteractionHand hand) {
        if (player != null && player.f_19853_ != null) {
            new ItemLeftClickEventJS(player, hand).post("item.left_click");
        }
    }

    private static EventResult pickup(Player player, ItemEntity entity, ItemStack stack) {
        if (player != null && entity != null && player.f_19853_ != null && new ItemPickupEventJS(player, entity, stack).post("item.pickup")) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static EventResult drop(Player player, ItemEntity entity) {
        if (player != null && entity != null && player.f_19853_ != null && new ItemTossEventJS(player, entity).post("item.toss")) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static EventResult entityInteract(Player player, Entity entity, InteractionHand hand) {
        if (player != null && entity != null && player.f_19853_ != null && new ItemEntityInteractEventJS(player, entity, hand).post("item.entity_interact")) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static void crafted(Player player, ItemStack crafted, Container grid) {
        if (player instanceof ServerPlayer && !crafted.m_41619_()) {
            new ItemCraftedEventJS(player, crafted, grid).post("item.crafted");
            new InventoryChangedEventJS((ServerPlayer)player, crafted, -1).post("player.inventory.changed");
        }
    }

    private static void smelted(Player player, ItemStack smelted) {
        if (player instanceof ServerPlayer && !smelted.m_41619_()) {
            new ItemSmeltedEventJS(player, smelted).post("item.smelted");
            new InventoryChangedEventJS((ServerPlayer)player, smelted, -1).post("player.inventory.changed");
        }
    }
}

