/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item.custom;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import dev.architectury.registry.fuel.FuelRegistry;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class BasicItemJS
extends Item {
    private final ImmutableMultimap<Attribute, AttributeModifier> attributes;
    private ItemStack containerItem;
    private Function<ItemStackJS, Collection<ItemStackJS>> subtypes;

    public BasicItemJS(ItemBuilder p) {
        super(p.createItemProperties());
        Float attackDamage = p.getAttackDamage();
        Float attackSpeed = p.getAttackSpeed();
        if (p.burnTime > 0) {
            FuelRegistry.register((int)p.burnTime, (ItemLike[])new ItemLike[]{this});
        }
        this.subtypes = p.subtypes;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (attackDamage != null) {
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", attackDamage.doubleValue(), AttributeModifier.Operation.ADDITION));
        }
        if (attackSpeed != null) {
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", attackSpeed.doubleValue(), AttributeModifier.Operation.ADDITION));
        }
        this.attributes = builder.build();
    }

    public void m_6787_(CreativeModeTab category, NonNullList<ItemStack> stacks) {
        if (this.subtypes != null) {
            for (ItemStackJS stack : this.subtypes.apply(ItemStackJS.of((Object)this))) {
                stacks.add((Object)stack.getItemStack());
            }
        } else {
            super.m_6787_(category, stacks);
        }
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.attributes : super.m_7167_(slot);
    }
}

