/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.util.Tags;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class TagIngredientJS
implements IngredientJS {
    private static final Map<String, TagIngredientJS> tagIngredientCache = new HashMap<String, TagIngredientJS>();
    private final ResourceLocation tag;
    private Tag<Item> actualTag;

    public static TagIngredientJS createTag(String tag) {
        return tagIngredientCache.computeIfAbsent(tag, TagIngredientJS::new).validateTag();
    }

    public static void clearTagCache() {
        tagIngredientCache.clear();
    }

    private TagIngredientJS(String t) {
        this.tag = UtilsJS.getMCID(t);
    }

    public String getTag() {
        return this.tag.toString();
    }

    public Tag<Item> getActualTag() {
        if (this.actualTag == null) {
            this.actualTag = Tags.items().m_7689_(this.tag);
        }
        return this.actualTag;
    }

    @Override
    public boolean test(ItemStackJS stack) {
        return !stack.isEmpty() && this.getActualTag().m_8110_((Object)stack.getItem());
    }

    @Override
    public boolean testVanilla(ItemStack stack) {
        return !stack.m_41619_() && this.getActualTag().m_8110_((Object)stack.m_41720_());
    }

    @Override
    public boolean testVanillaItem(Item item) {
        return item != Items.f_41852_ && this.getActualTag().m_8110_((Object)item);
    }

    @Override
    public Set<ItemStackJS> getStacks() {
        Tag<Item> t = this.getActualTag();
        if (t.m_6497_().size() > 0) {
            LinkedHashSet<ItemStackJS> set = new LinkedHashSet<ItemStackJS>();
            for (Item item : t.m_6497_()) {
                set.add(new ItemStackJS(new ItemStack((ItemLike)item)));
            }
            return set;
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Item> getVanillaItems() {
        Tag<Item> t = this.getActualTag();
        if (t.m_6497_().size() > 0) {
            return new LinkedHashSet<Item>(t.m_6497_());
        }
        return Collections.emptySet();
    }

    @Override
    public ItemStackJS getFirst() {
        this.validateTag();
        Iterator iterator = this.getActualTag().m_6497_().iterator();
        if (iterator.hasNext()) {
            Item item = (Item)iterator.next();
            return new ItemStackJS(new ItemStack((ItemLike)item));
        }
        return ItemStackJS.EMPTY;
    }

    @Override
    public boolean isEmpty() {
        return this.getActualTag().m_6497_().isEmpty();
    }

    public String toString() {
        return "'#" + this.tag + "'";
    }

    @Override
    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("tag", this.tag.toString());
        return json;
    }

    @Override
    public boolean anyStackMatches(IngredientJS ingredient) {
        if (ingredient instanceof TagIngredientJS) {
            TagIngredientJS tagIngredient = (TagIngredientJS)ingredient;
            if (this.tag.equals((Object)tagIngredient.tag)) {
                return true;
            }
        }
        return IngredientJS.super.anyStackMatches(ingredient);
    }

    private TagIngredientJS validateTag() {
        if (RecipeJS.itemErrors && this.isEmpty()) {
            throw new RecipeExceptionJS(String.format("Tag '#%s' doesn't contain any items!", this.tag)).error();
        }
        return this;
    }

    @Override
    public Ingredient createVanillaIngredient() {
        return Ingredient.m_43911_(this.getActualTag());
    }
}

