/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item.type;

import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.item.custom.AxeItemJS;
import dev.latvian.mods.kubejs.item.custom.HoeItemJS;
import dev.latvian.mods.kubejs.item.custom.PickaxeItemJS;
import dev.latvian.mods.kubejs.item.custom.ShovelItemJS;
import dev.latvian.mods.kubejs.item.custom.SwordItemJS;
import dev.latvian.mods.kubejs.item.type.ItemType;
import java.util.function.Function;
import net.minecraft.world.item.Item;

public class ToolItemType
extends ItemType {
    public static final ToolItemType SWORD = new ToolItemType("sword", SwordItemJS::new, 3.0f, -2.4f);
    public static final ToolItemType PICKAXE = new ToolItemType("pickaxe", PickaxeItemJS::new, 1.0f, -2.8f);
    public static final ToolItemType AXE = new ToolItemType("axe", AxeItemJS::new, 6.0f, -3.1f);
    public static final ToolItemType SHOVEL = new ToolItemType("shovel", ShovelItemJS::new, 1.5f, -3.0f);
    public static final ToolItemType HOE = new ToolItemType("hoe", HoeItemJS::new, -2.0f, -1.0f);
    public final Function<ItemBuilder, Item> factory;
    public final float attackDamageBaseline;
    public final float attackSpeedBaseline;

    public ToolItemType(String n, Function<ItemBuilder, Item> f, float d, float s) {
        super(n);
        this.factory = f;
        this.attackDamageBaseline = d;
        this.attackSpeedBaseline = s;
    }

    @Override
    public Item createItem(ItemBuilder builder) {
        return this.factory.apply(builder);
    }

    @Override
    public void applyDefaults(ItemBuilder builder) {
        super.applyDefaults(builder);
        builder.parentModel = "minecraft:item/handheld";
        builder.attackDamageBaseline = this.attackDamageBaseline;
        builder.attackSpeedBaseline = this.attackSpeedBaseline;
        builder.unstackable();
    }

    @Override
    public void generateAssets(ItemBuilder builder, AssetJsonGenerator generator) {
        generator.itemModel(builder.id, m -> {
            if (!builder.parentModel.isEmpty()) {
                m.parent(builder.parentModel);
            } else {
                m.parent("minecraft:item/handheld");
            }
            m.texture("layer0", builder.texture.isEmpty() ? builder.newID("item/", "").toString() : builder.texture);
        });
    }
}

