/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.level;

import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.registries.Registries;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.block.MaterialJS;
import dev.latvian.mods.kubejs.block.MaterialListJS;
import dev.latvian.mods.kubejs.entity.EntityJS;
import dev.latvian.mods.kubejs.item.InventoryJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.level.ExplosionJS;
import dev.latvian.mods.kubejs.level.FireworksJS;
import dev.latvian.mods.kubejs.level.LevelJS;
import dev.latvian.mods.kubejs.level.forge.BlockContainerJSImpl;
import dev.latvian.mods.kubejs.player.EntityArrayList;
import dev.latvian.mods.kubejs.player.PlayerJS;
import dev.latvian.mods.kubejs.player.ServerPlayerJS;
import dev.latvian.mods.kubejs.util.Tags;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.util.SpecialEquality;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class BlockContainerJS
implements SpecialEquality {
    private static final ResourceLocation AIR_ID = new ResourceLocation("minecraft:air");
    public final Level minecraftLevel;
    private final BlockPos pos;
    private BlockState cachedState;
    private BlockEntity cachedEntity;

    public BlockContainerJS(Level w, BlockPos p) {
        this.minecraftLevel = w;
        this.pos = p;
    }

    public void clearCache() {
        this.cachedState = null;
        this.cachedEntity = null;
    }

    public LevelJS getLevel() {
        return UtilsJS.getLevel(this.minecraftLevel);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public String getDimension() {
        return this.minecraftLevel.m_46472_().m_135782_().toString();
    }

    public int getX() {
        return this.getPos().m_123341_();
    }

    public int getY() {
        return this.getPos().m_123342_();
    }

    public int getZ() {
        return this.getPos().m_123343_();
    }

    public BlockContainerJS offset(Direction f, int d) {
        return new BlockContainerJS(this.minecraftLevel, this.getPos().m_5484_(f, d));
    }

    public BlockContainerJS offset(Direction f) {
        return this.offset(f, 1);
    }

    public BlockContainerJS offset(int x, int y, int z) {
        return new BlockContainerJS(this.minecraftLevel, this.getPos().m_142082_(x, y, z));
    }

    public BlockContainerJS getDown() {
        return this.offset(Direction.DOWN);
    }

    public BlockContainerJS getUp() {
        return this.offset(Direction.UP);
    }

    public BlockContainerJS getNorth() {
        return this.offset(Direction.NORTH);
    }

    public BlockContainerJS getSouth() {
        return this.offset(Direction.SOUTH);
    }

    public BlockContainerJS getWest() {
        return this.offset(Direction.WEST);
    }

    public BlockContainerJS getEast() {
        return this.offset(Direction.EAST);
    }

    public BlockState getBlockState() {
        if (this.cachedState == null) {
            this.cachedState = this.minecraftLevel.m_8055_(this.getPos());
        }
        return this.cachedState;
    }

    public void setBlockState(BlockState state, int flags) {
        this.minecraftLevel.m_7731_(this.getPos(), state, flags);
        this.clearCache();
    }

    public String getId() {
        return Registries.getId((Object)this.getBlockState().m_60734_(), (ResourceKey)Registry.f_122901_).toString();
    }

    public Collection<ResourceLocation> getTags() {
        return Tags.byBlockState(this.getBlockState());
    }

    public boolean hasTag(ResourceLocation tag) {
        return Tags.blocks().m_7689_(tag).m_8110_((Object)this.getBlockState().m_60734_());
    }

    public void set(ResourceLocation id, Map<?, ?> properties, int flags) {
        Block block = (Block)KubeJSRegistries.blocks().get(id);
        BlockState state = block.m_49966_();
        if (!properties.isEmpty() && state.m_60734_() != Blocks.f_50016_) {
            HashMap<String, Property> pmap = new HashMap<String, Property>();
            for (Property property : state.m_61147_()) {
                pmap.put(property.m_61708_(), property);
            }
            for (Map.Entry entry : properties.entrySet()) {
                Property property = (Property)pmap.get(String.valueOf(entry.getKey()));
                if (property == null) continue;
                state = (BlockState)state.m_61124_(property, (Comparable)UtilsJS.cast(property.m_6215_(String.valueOf(entry.getValue())).get()));
            }
        }
        this.setBlockState(state, flags);
    }

    public void set(ResourceLocation id, Map<?, ?> properties) {
        this.set(id, properties, 3);
    }

    public void set(ResourceLocation id) {
        this.set(id, Collections.emptyMap());
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        BlockState state = this.getBlockState();
        for (Property property : state.m_61147_()) {
            map.put(property.m_61708_(), property.m_6940_(state.m_61143_(property)));
        }
        return map;
    }

    @Nullable
    public BlockEntity getEntity() {
        if (this.cachedEntity == null || this.cachedEntity.m_58901_()) {
            this.cachedEntity = this.minecraftLevel.m_7702_(this.pos);
        }
        return this.cachedEntity;
    }

    public String getEntityId() {
        BlockEntity entity = this.getEntity();
        return entity == null ? "minecraft:air" : Registries.getId((Object)entity.m_58903_(), (ResourceKey)Registry.f_122907_).toString();
    }

    @Nullable
    public CompoundTag getEntityData() {
        BlockEntity entity = this.getEntity();
        if (entity != null) {
            return entity.m_187480_();
        }
        return null;
    }

    public void setEntityData(@Nullable CompoundTag tag) {
        BlockEntity entity;
        if (tag != null && (entity = this.getEntity()) != null) {
            entity.m_142466_(tag);
        }
    }

    public void mergeEntityData(@Nullable CompoundTag tag) {
        CompoundTag t = this.getEntityData();
        if (t == null) {
            this.setEntityData(tag);
        } else if (tag != null && !tag.m_128456_()) {
            for (String s : tag.m_128431_()) {
                t.m_128365_(s, tag.m_128423_(s));
            }
        }
        this.setEntityData(t);
    }

    public int getLight() {
        return this.minecraftLevel.m_46803_(this.pos);
    }

    public boolean getCanSeeSky() {
        return this.minecraftLevel.m_46861_(this.pos);
    }

    public String toString() {
        String id = this.getId();
        Map<String, String> properties = this.getProperties();
        if (properties.isEmpty()) {
            return id;
        }
        StringBuilder builder = new StringBuilder(id);
        builder.append('[');
        boolean first = true;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(entry.getKey());
            builder.append('=');
            builder.append(entry.getValue());
        }
        builder.append(']');
        return builder.toString();
    }

    public ExplosionJS createExplosion() {
        return new ExplosionJS((LevelAccessor)this.minecraftLevel, (double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5);
    }

    @Nullable
    public EntityJS createEntity(ResourceLocation id) {
        EntityJS entity = this.getLevel().createEntity(id);
        if (entity != null) {
            entity.setPosition(this);
        }
        return entity;
    }

    public void spawnLightning(boolean effectOnly, @Nullable EntityJS player) {
        if (this.minecraftLevel instanceof ServerLevel) {
            ServerPlayer serverPlayer;
            LightningBolt e = (LightningBolt)EntityType.f_20465_.m_20615_(this.minecraftLevel);
            e.m_6027_((double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5);
            if (player instanceof ServerPlayerJS) {
                ServerPlayerJS serverPlayer2 = (ServerPlayerJS)player;
                serverPlayer = (ServerPlayer)serverPlayer2.minecraftPlayer;
            } else {
                serverPlayer = null;
            }
            e.m_20879_(serverPlayer);
            e.m_20874_(effectOnly);
            this.minecraftLevel.m_7967_((Entity)e);
        }
    }

    public void spawnLightning(boolean effectOnly) {
        this.spawnLightning(effectOnly, null);
    }

    public void spawnFireworks(FireworksJS fireworks) {
        this.minecraftLevel.m_7967_((Entity)fireworks.createFireworkRocket(this.minecraftLevel, (double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5));
    }

    @Nullable
    public InventoryJS getInventory(Direction facing) {
        BlockEntity tileEntity = this.getEntity();
        if (tileEntity != null) {
            return BlockContainerJS.getInventoryFromBlockEntity(tileEntity, facing);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static InventoryJS getInventoryFromBlockEntity(BlockEntity tileEntity, Direction facing) {
        void var1_1;
        return BlockContainerJSImpl.getInventoryFromBlockEntity(tileEntity, (Direction)var1_1);
    }

    public MaterialJS getMaterial() {
        return MaterialListJS.INSTANCE.get(this.getBlockState().m_60767_());
    }

    public ItemStackJS getItem() {
        BlockState state = this.getBlockState();
        return ItemStackJS.of(state.m_60734_().m_7397_((BlockGetter)this.minecraftLevel, this.pos, state));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CharSequence || obj instanceof ResourceLocation) {
            return this.getId().equals(obj.toString());
        }
        return super.equals(obj);
    }

    private static boolean isReal(Player p) {
        return !PlayerHooks.isFake((Player)p);
    }

    public EntityArrayList getPlayersInRadius(double radius) {
        EntityArrayList list = new EntityArrayList(this.getLevel(), 1);
        for (Player player : this.minecraftLevel.m_6443_(Player.class, new AABB((double)this.pos.m_123341_() - radius, (double)this.pos.m_123342_() - radius, (double)this.pos.m_123343_() - radius, (double)this.pos.m_123341_() + 1.0 + radius, (double)this.pos.m_123342_() + 1.0 + radius, (double)this.pos.m_123343_() + 1.0 + radius), BlockContainerJS::isReal)) {
            PlayerJS p = this.getLevel().getPlayer((Entity)player);
            if (p == null) continue;
            list.add(p);
        }
        return list;
    }

    public EntityArrayList getPlayersInRadius() {
        return this.getPlayersInRadius(8.0);
    }

    public String getBiomeId() {
        Optional key = this.minecraftLevel.m_45837_(this.pos);
        return key.isPresent() ? ((ResourceKey)key.get()).m_135782_().toString() : "";
    }

    public boolean specialEquals(Object o, boolean shallow) {
        if (o instanceof CharSequence || o instanceof ResourceLocation) {
            return this.getId().equals(o.toString());
        }
        return this.equals(o);
    }
}

