/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.level;

import dev.latvian.mods.kubejs.entity.EntityJS;
import dev.latvian.mods.kubejs.entity.ItemEntityJS;
import dev.latvian.mods.kubejs.entity.ItemFrameEntityJS;
import dev.latvian.mods.kubejs.entity.LivingEntityJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.level.ExplosionJS;
import dev.latvian.mods.kubejs.level.FireworksJS;
import dev.latvian.mods.kubejs.player.EntityArrayList;
import dev.latvian.mods.kubejs.player.PlayerDataJS;
import dev.latvian.mods.kubejs.player.PlayerJS;
import dev.latvian.mods.kubejs.player.ServerPlayerJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.GameRulesJS;
import dev.latvian.mods.kubejs.server.ServerJS;
import dev.latvian.mods.kubejs.util.AttachedData;
import dev.latvian.mods.kubejs.util.WithAttachedData;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class LevelJS
implements WithAttachedData {
    public final Level minecraftLevel;
    private AttachedData data;

    public LevelJS(Level w) {
        this.minecraftLevel = w;
    }

    public abstract ScriptType getSide();

    @Override
    public AttachedData getData() {
        if (this.data == null) {
            this.data = new AttachedData(this);
        }
        return this.data;
    }

    public GameRulesJS getGameRules() {
        return new GameRulesJS(this.minecraftLevel.m_46469_());
    }

    @Nullable
    public ServerJS getServer() {
        return null;
    }

    public long getTime() {
        return this.minecraftLevel.m_46467_();
    }

    public long getLocalTime() {
        return this.minecraftLevel.m_46468_();
    }

    public String getDimension() {
        return this.minecraftLevel.m_46472_().m_135782_().toString();
    }

    public boolean isOverworld() {
        return this.minecraftLevel.m_46472_() == Level.f_46428_;
    }

    public boolean isDaytime() {
        return this.minecraftLevel.m_46461_();
    }

    public boolean isRaining() {
        return this.minecraftLevel.m_46471_();
    }

    public boolean isThundering() {
        return this.minecraftLevel.m_46470_();
    }

    public void setRainStrength(float strength) {
        this.minecraftLevel.m_46734_(strength);
    }

    public BlockContainerJS getBlock(int x, int y, int z) {
        return this.getBlock(new BlockPos(x, y, z));
    }

    public BlockContainerJS getBlock(BlockPos pos) {
        return new BlockContainerJS(this.minecraftLevel, pos);
    }

    public BlockContainerJS getBlock(BlockEntity blockEntity) {
        return this.getBlock(blockEntity.m_58899_());
    }

    public abstract PlayerDataJS getPlayerData(Player var1);

    @Nullable
    public EntityJS getEntity(@Nullable Entity e) {
        if (e == null) {
            return null;
        }
        if (e instanceof Player) {
            Player player = (Player)e;
            return this.getPlayerData(player).getPlayer();
        }
        if (e instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)e;
            return new LivingEntityJS(this, living);
        }
        if (e instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)e;
            return new ItemEntityJS(this, item);
        }
        if (e instanceof ItemFrame) {
            ItemFrame frame = (ItemFrame)e;
            return new ItemFrameEntityJS(this, frame);
        }
        return new EntityJS(this, e);
    }

    @Nullable
    public LivingEntityJS getLivingEntity(@Nullable Entity entity) {
        LivingEntityJS living;
        EntityJS e = this.getEntity(entity);
        return e instanceof LivingEntityJS ? (living = (LivingEntityJS)e) : null;
    }

    @Nullable
    public PlayerJS getPlayer(@Nullable Entity entity) {
        PlayerJS player;
        if (!(entity instanceof Player)) {
            return null;
        }
        EntityJS e = this.getEntity(entity);
        return e instanceof PlayerJS ? (player = (PlayerJS)e) : null;
    }

    public EntityArrayList createEntityList(Collection<? extends Entity> entities) {
        return new EntityArrayList(this, entities);
    }

    public EntityArrayList getPlayers() {
        return this.createEntityList(this.minecraftLevel.m_6907_());
    }

    public EntityArrayList getEntities() {
        return new EntityArrayList(this, 0);
    }

    public ExplosionJS createExplosion(double x, double y, double z) {
        return new ExplosionJS((LevelAccessor)this.minecraftLevel, x, y, z);
    }

    @Nullable
    public EntityJS createEntity(ResourceLocation id) {
        EntityType type = (EntityType)Registry.f_122826_.m_7745_(id);
        if (type == null) {
            return null;
        }
        return this.getEntity(type.m_20615_(this.minecraftLevel));
    }

    public void spawnLightning(double x, double y, double z, boolean effectOnly, @Nullable EntityJS player) {
        if (this.minecraftLevel instanceof ServerLevel) {
            ServerPlayer serverPlayer;
            LightningBolt e = (LightningBolt)EntityType.f_20465_.m_20615_(this.minecraftLevel);
            e.m_6027_(x, y, z);
            if (player instanceof ServerPlayerJS) {
                ServerPlayerJS serverPlayer2 = (ServerPlayerJS)player;
                serverPlayer = (ServerPlayer)serverPlayer2.minecraftPlayer;
            } else {
                serverPlayer = null;
            }
            e.m_20879_(serverPlayer);
            e.m_20874_(effectOnly);
            this.minecraftLevel.m_7967_((Entity)e);
        }
    }

    public void spawnLightning(double x, double y, double z, boolean effectOnly) {
        this.spawnLightning(x, y, z, effectOnly, null);
    }

    public void spawnFireworks(double x, double y, double z, FireworksJS f) {
        this.minecraftLevel.m_7967_((Entity)f.createFireworkRocket(this.minecraftLevel, x, y, z));
    }

    public EntityArrayList getEntitiesWithin(AABB aabb) {
        return new EntityArrayList(this, this.minecraftLevel.m_45933_(null, aabb));
    }

    @ApiStatus.OverrideOnly
    public Level getMinecraftLevel() {
        return this.minecraftLevel;
    }
}

