/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.level;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.latvian.mods.kubejs.level.LevelJS;
import dev.latvian.mods.kubejs.level.WorldlyCommandSender;
import dev.latvian.mods.kubejs.player.EntityArrayList;
import dev.latvian.mods.kubejs.player.FakeServerPlayerDataJS;
import dev.latvian.mods.kubejs.player.ServerPlayerDataJS;
import dev.latvian.mods.kubejs.script.AttachDataEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.ServerJS;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ServerLevelData;

public class ServerLevelJS
extends LevelJS {
    private final ServerJS server;
    public final CompoundTag persistentData;

    public ServerLevelJS(ServerJS s, ServerLevel w) {
        super((Level)w);
        this.server = s;
        String t = w.m_46472_().m_135782_().toString();
        this.persistentData = s.persistentData.m_128469_(t);
        s.persistentData.m_128365_(t, (Tag)this.persistentData);
    }

    @Override
    public ScriptType getSide() {
        return ScriptType.SERVER;
    }

    @Override
    public ServerJS getServer() {
        return this.server;
    }

    public long getSeed() {
        return this.getMinecraftLevel().m_7328_();
    }

    public void setTime(long time) {
        ((ServerLevelData)this.minecraftLevel.m_6106_()).m_6253_(time);
    }

    public void setLocalTime(long time) {
        ((ServerLevelData)this.minecraftLevel.m_6106_()).m_6247_(time);
    }

    @Override
    public ServerPlayerDataJS getPlayerData(Player player) {
        ServerPlayerDataJS data = this.server.playerMap.get(player.m_142081_());
        if (data != null) {
            return data;
        }
        FakeServerPlayerDataJS fakeData = this.server.fakePlayerMap.get(player.m_142081_());
        if (fakeData == null) {
            fakeData = new FakeServerPlayerDataJS(this.server, (ServerPlayer)player);
            AttachDataEvent.forPlayer(fakeData).invoke();
        }
        fakeData.player = (ServerPlayer)player;
        return fakeData;
    }

    public String toString() {
        return "ServerWorld:" + this.getDimension();
    }

    @Override
    public EntityArrayList getEntities() {
        return new EntityArrayList((LevelJS)this, Lists.newArrayList((Iterable)this.getMinecraftLevel().m_8583_()));
    }

    public ServerLevel getMinecraftLevel() {
        return (ServerLevel)super.getMinecraftLevel();
    }

    public EntityArrayList getEntities(String filter) {
        if (filter.equals("@e")) {
            return this.getEntities();
        }
        if (filter.equals("@a")) {
            return this.getPlayers();
        }
        try {
            return this.createEntityList(new EntitySelectorParser(new StringReader(filter), true).m_121377_().m_121160_((CommandSourceStack)new WorldlyCommandSender(this)));
        }
        catch (CommandSyntaxException e) {
            return new EntityArrayList((LevelJS)this, 0);
        }
    }
}

