/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.level.gen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import dev.architectury.hooks.level.biome.BiomeProperties;
import dev.architectury.registry.level.biome.BiomeModifications;
import dev.latvian.mods.kubejs.core.RegistryGetterKJS;
import dev.latvian.mods.kubejs.event.StartupEventJS;
import dev.latvian.mods.kubejs.level.gen.filter.biome.BiomeFilter;
import dev.latvian.mods.kubejs.level.gen.properties.RemoveOresProperties;
import dev.latvian.mods.kubejs.level.gen.properties.RemoveSpawnsProperties;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ReplaceBlockConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.jetbrains.annotations.Nullable;

public class WorldgenRemoveEventJS
extends StartupEventJS {
    private static ResourceLocation getId(Supplier<PlacedFeature> feature) {
        if (feature instanceof RegistryGetterKJS) {
            RegistryGetterKJS reg = (RegistryGetterKJS)((Object)feature);
            return reg.getId();
        }
        return BuiltinRegistries.f_194653_.m_7981_((Object)feature.get());
    }

    private static <T> List<T> padListAndGet(List<List<T>> features, int i) {
        while (features.size() <= i) {
            features.add(Lists.newArrayList());
        }
        return features.get(i);
    }

    protected static boolean checkTree(ConfiguredFeature<?, ?> configuredFeature, Predicate<FeatureConfiguration> predicate) {
        return predicate.test(configuredFeature.f_65378_) || configuredFeature.f_65378_.m_7817_().anyMatch(cf -> WorldgenRemoveEventJS.checkTree(cf, predicate));
    }

    protected static boolean check(PlacedFeature feature, Predicate<FeatureConfiguration> predicate) {
        return feature.m_191781_().anyMatch(cf -> WorldgenRemoveEventJS.checkTree(cf, predicate));
    }

    private void removeFeature(BiomeFilter filter, GenerationStep.Decoration decoration, Predicate<FeatureConfiguration> predicate) {
        BiomeModifications.replaceProperties((Predicate)filter, (ctx, properties) -> WorldgenRemoveEventJS.padListAndGet(properties.getGenerationProperties().getFeatures(), decoration.ordinal()).removeIf(UtilsJS.onMatchDo(sup -> WorldgenRemoveEventJS.check((PlacedFeature)sup.get(), predicate), value -> ConsoleJS.STARTUP.debug("Removing feature %s from generation step %s in biome %s".formatted(WorldgenRemoveEventJS.getId(value), decoration.name().toLowerCase(), ctx.getKey())))));
    }

    private void removeSpawn(BiomeFilter filter, BiPredicate<MobCategory, MobSpawnSettings.SpawnerData> predicate) {
        BiomeModifications.replaceProperties((Predicate)filter, (ctx, properties) -> properties.getSpawnProperties().removeSpawns(predicate));
    }

    public void printFeatures() {
        this.printFeatures(null);
    }

    public void printFiltered() {
        this.printFiltered(null);
    }

    public void printFeatures(@Nullable GenerationStep.Decoration type) {
        this.printFeatures(type, BiomeFilter.ALWAYS_TRUE);
    }

    public void printFiltered(@Nullable GenerationStep.Decoration type) {
        this.printFiltered(type, BiomeFilter.ALWAYS_TRUE);
    }

    public void printFeatures(@Nullable GenerationStep.Decoration type, BiomeFilter filter) {
        this.printFeaturesForType(type, filter, false);
    }

    public void printFiltered(@Nullable GenerationStep.Decoration type, BiomeFilter filter) {
        this.printFeaturesForType(type, filter, true);
    }

    public void printFeaturesForType(final @Nullable GenerationStep.Decoration type, BiomeFilter filter, boolean afterRemoval) {
        if (type == null) {
            for (GenerationStep.Decoration step : GenerationStep.Decoration.values()) {
                this.printFeaturesForType(step, filter, afterRemoval);
            }
        } else {
            BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable> printer = new BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>(){
                boolean called = false;

                @Override
                public void accept(BiomeModifications.BiomeContext ctx, BiomeProperties.Mutable properties) {
                    if (this.called) {
                        return;
                    }
                    this.called = true;
                    ResourceLocation biome = ctx.getKey();
                    List<Supplier> features = WorldgenRemoveEventJS.padListAndGet(properties.getGenerationProperties().getFeatures(), type.ordinal());
                    ConsoleJS.STARTUP.info("Features with type '%s' in biome '%s':".formatted(type.name().toLowerCase(), biome));
                    int unknown = 0;
                    for (Supplier feature : features) {
                        ResourceLocation id = WorldgenRemoveEventJS.getId(feature);
                        if (id == null) {
                            ++unknown;
                            continue;
                        }
                        ConsoleJS.STARTUP.info("- " + id);
                    }
                    if (unknown > 0) {
                        ConsoleJS.STARTUP.info("- " + unknown + " features with unknown id");
                    }
                }
            };
            if (afterRemoval) {
                BiomeModifications.postProcessProperties((Predicate)filter, (BiConsumer)printer);
            } else {
                BiomeModifications.removeProperties((Predicate)filter, (BiConsumer)printer);
            }
        }
    }

    public void removeFeatureById(BiomeFilter filter, GenerationStep.Decoration decoration, ResourceLocation[] id) {
        HashSet ids = Sets.newHashSet((Object[])id);
        BiomeModifications.replaceProperties((Predicate)filter, (ctx, properties) -> WorldgenRemoveEventJS.padListAndGet(properties.getGenerationProperties().getFeatures(), decoration.ordinal()).removeIf(sup -> ids.contains(WorldgenRemoveEventJS.getId(sup))));
    }

    public void removeFeatureById(GenerationStep.Decoration type, ResourceLocation[] id) {
        this.removeFeatureById(BiomeFilter.ALWAYS_TRUE, type, id);
    }

    public void removeAllFeatures(BiomeFilter filter, GenerationStep.Decoration type) {
        this.removeFeature(filter, type, configuredFeature -> true);
    }

    public void removeAllFeatures(BiomeFilter filter) {
        for (GenerationStep.Decoration decoration : GenerationStep.Decoration.values()) {
            this.removeAllFeatures(filter, decoration);
        }
    }

    public void removeAllFeatures() {
        this.removeAllFeatures(BiomeFilter.ALWAYS_TRUE);
    }

    public void removeOres(Consumer<RemoveOresProperties> p) {
        RemoveOresProperties properties = new RemoveOresProperties();
        p.accept(properties);
        this.removeFeature(properties.biomes, properties.worldgenLayer, fc -> {
            if (fc instanceof OreConfiguration) {
                OreConfiguration ore = (OreConfiguration)fc;
                return properties.blocks.check(ore.f_161005_);
            }
            if (fc instanceof ReplaceBlockConfiguration) {
                ReplaceBlockConfiguration rb = (ReplaceBlockConfiguration)fc;
                return properties.blocks.check(rb.f_161083_);
            }
            return false;
        });
    }

    public void printSpawns(@Nullable MobCategory category) {
        BiomeModifications.addProperties((ctx, properties) -> {
            ResourceLocation biome = ctx.getKey();
            Map spawns = properties.getSpawnProperties().getSpawners();
            ImmutableSet cats = category == null ? spawns.keySet() : ImmutableSet.of((Object)category);
            for (MobCategory cat : cats) {
                ConsoleJS.STARTUP.info("Mob spawns with type '%s' in biome '%s':".formatted(cat.m_21607_(), biome));
                for (MobSpawnSettings.SpawnerData data : (List)spawns.get(cat)) {
                    ConsoleJS.STARTUP.info("- " + data.toString());
                }
            }
        });
    }

    public void printSpawns() {
        this.printSpawns(null);
    }

    public void removeSpawns(Consumer<RemoveSpawnsProperties> p) {
        RemoveSpawnsProperties properties = new RemoveSpawnsProperties();
        p.accept(properties);
        this.removeSpawn(properties.biomes, properties.mobs);
    }

    public void removeAllSpawns() {
        this.removeSpawn(BiomeFilter.ALWAYS_TRUE, (mobCategory, spawnerData) -> true);
    }
}

