/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.player;

import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.entity.RayTraceResultJS;
import dev.latvian.mods.kubejs.net.SendDataFromClientMessage;
import dev.latvian.mods.kubejs.player.ClientPlayerDataJS;
import dev.latvian.mods.kubejs.player.PlayerJS;
import dev.latvian.mods.kubejs.player.PlayerStatsJS;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class ClientPlayerJS
extends PlayerJS<Player> {
    private final boolean isSelf;

    public ClientPlayerJS(ClientPlayerDataJS d, Player p, boolean s) {
        super(d, d.getLevel(), p);
        this.isSelf = s;
    }

    public boolean isSelf() {
        return this.isSelf;
    }

    @Override
    public PlayerStatsJS getStats() {
        if (!this.isSelf()) {
            throw new IllegalStateException("Can't access other player stats!");
        }
        return new PlayerStatsJS(this, ((LocalPlayer)this.minecraftPlayer).m_108630_());
    }

    @Override
    public void paint(CompoundTag tag) {
        if (this.isSelf()) {
            KubeJS.PROXY.paint(tag);
        }
    }

    @Override
    public boolean isMiningBlock() {
        return this.isSelf() && Minecraft.m_91087_().f_91072_.m_105296_();
    }

    @Override
    public void sendData(String channel, @Nullable CompoundTag data) {
        if (!channel.isEmpty() && this.isSelf()) {
            new SendDataFromClientMessage(channel, data).sendToServer();
        }
    }

    @Override
    public RayTraceResultJS rayTrace(double distance) {
        return this.isSelf ? new RayTraceResultJS(this, Minecraft.m_91087_().f_91077_, distance) : super.rayTrace(distance);
    }
}

