/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.player;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.ChatEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.core.EntityKJS;
import dev.latvian.mods.kubejs.player.ChestEventJS;
import dev.latvian.mods.kubejs.player.InventoryEventJS;
import dev.latvian.mods.kubejs.player.InventoryListener;
import dev.latvian.mods.kubejs.player.PlayerAdvancementEventJS;
import dev.latvian.mods.kubejs.player.PlayerChatEventJS;
import dev.latvian.mods.kubejs.player.ServerPlayerDataJS;
import dev.latvian.mods.kubejs.player.SimplePlayerEventJS;
import dev.latvian.mods.kubejs.script.AttachDataEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.ServerJS;
import dev.latvian.mods.kubejs.stages.Stages;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.TextFilter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.NotNull;

public class KubeJSPlayerEventHandler {
    public static void init() {
        PlayerEvent.PLAYER_JOIN.register(KubeJSPlayerEventHandler::loggedIn);
        PlayerEvent.PLAYER_QUIT.register(KubeJSPlayerEventHandler::loggedOut);
        PlayerEvent.PLAYER_RESPAWN.register(KubeJSPlayerEventHandler::respawn);
        PlayerEvent.PLAYER_CLONE.register(KubeJSPlayerEventHandler::cloned);
        TickEvent.PLAYER_POST.register(KubeJSPlayerEventHandler::tick);
        ChatEvent.SERVER.register(KubeJSPlayerEventHandler::chat);
        PlayerEvent.PLAYER_ADVANCEMENT.register(KubeJSPlayerEventHandler::advancement);
        PlayerEvent.OPEN_MENU.register(KubeJSPlayerEventHandler::inventoryOpened);
        PlayerEvent.CLOSE_MENU.register(KubeJSPlayerEventHandler::inventoryClosed);
    }

    public static void loggedIn(ServerPlayer player) {
        if (ServerJS.instance != null) {
            ServerPlayerDataJS p = new ServerPlayerDataJS(ServerJS.instance, player.m_142081_(), player.m_36316_().getName(), KubeJS.nextClientHasClientMod);
            KubeJS.nextClientHasClientMod = false;
            p.getServer().playerMap.put(p.getId(), p);
            AttachDataEvent.forPlayer(p).invoke();
            new SimplePlayerEventJS((Player)player).post("player.logged_in");
            player.f_36095_.m_38893_((ContainerListener)new InventoryListener(player));
        }
        if (!ScriptType.SERVER.errors.isEmpty() && !CommonProperties.get().hideServerScriptErrors) {
            player.m_5661_((Component)new TextComponent("KubeJS errors found [" + ScriptType.SERVER.errors.size() + "]! Run '/kubejs errors' for more info").m_130940_(ChatFormatting.DARK_RED), false);
        }
        Stages.get((Player)player).sync();
    }

    private static void respawn(ServerPlayer player, boolean b) {
        Stages.get((Player)player).sync();
    }

    public static void loggedOut(ServerPlayer player) {
        if (ServerJS.instance == null || !ServerJS.instance.playerMap.containsKey(player.m_142081_())) {
            return;
        }
        new SimplePlayerEventJS((Player)player).post("player.logged_out");
        ServerJS.instance.playerMap.remove(player.m_142081_());
    }

    public static void cloned(ServerPlayer oldPlayer, ServerPlayer newPlayer, boolean wonGame) {
        ((EntityKJS)newPlayer).getPersistentDataKJS().m_128391_(((EntityKJS)oldPlayer).getPersistentDataKJS());
        newPlayer.f_36095_.m_38893_((ContainerListener)new InventoryListener(newPlayer));
    }

    public static void tick(Player player) {
        if (ServerJS.instance != null && player instanceof ServerPlayer) {
            new SimplePlayerEventJS(player).post("player.tick");
        }
    }

    @NotNull
    public static EventResult chat(ServerPlayer player, TextFilter.FilteredText message, ChatEvent.ChatComponent component) {
        PlayerChatEventJS event = new PlayerChatEventJS(player, message.m_143719_(), component.getRaw());
        component.setRaw(event.component);
        if (event.post("player.chat")) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public static void advancement(ServerPlayer player, Advancement advancement) {
        new PlayerAdvancementEventJS(player, advancement).post("player.advancement");
    }

    public static void inventoryOpened(Player player, AbstractContainerMenu menu) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!(menu instanceof InventoryMenu)) {
                menu.m_38893_((ContainerListener)new InventoryListener(serverPlayer));
            }
        }
        new InventoryEventJS(player, menu).post("player.inventory.opened");
        if (menu instanceof ChestMenu) {
            new ChestEventJS(player, menu).post("player.chest.opened");
        }
    }

    public static void inventoryClosed(Player player, AbstractContainerMenu menu) {
        new InventoryEventJS(player, menu).post("player.inventory.closed");
        if (menu instanceof ChestMenu) {
            new ChestEventJS(player, menu).post("player.chest.closed");
        }
    }
}

