/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.player;

import com.mojang.authlib.GameProfile;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.latvian.mods.kubejs.core.PlayerKJS;
import dev.latvian.mods.kubejs.entity.LivingEntityJS;
import dev.latvian.mods.kubejs.item.InventoryJS;
import dev.latvian.mods.kubejs.item.ItemHandlerUtils;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.level.LevelJS;
import dev.latvian.mods.kubejs.player.PlayerDataJS;
import dev.latvian.mods.kubejs.player.PlayerStatsJS;
import dev.latvian.mods.kubejs.stages.Stages;
import dev.latvian.mods.kubejs.util.AttachedData;
import dev.latvian.mods.kubejs.util.WithAttachedData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerJS<E extends Player>
extends LivingEntityJS
implements WithAttachedData {
    public final E minecraftPlayer;
    private final PlayerDataJS playerData;
    private InventoryJS inventory;

    public PlayerJS(PlayerDataJS d, LevelJS l, E p) {
        super(l, (LivingEntity)p);
        this.playerData = d;
        this.minecraftPlayer = p;
    }

    @Override
    public AttachedData getData() {
        return this.playerData.getData();
    }

    @Override
    public boolean isPlayer() {
        return true;
    }

    public boolean isFake() {
        return PlayerHooks.isFake(this.minecraftPlayer);
    }

    @Override
    public String toString() {
        return this.minecraftPlayer.m_36316_().getName();
    }

    @Override
    public GameProfile getProfile() {
        return this.minecraftPlayer.m_36316_();
    }

    public InventoryJS getInventory() {
        if (this.inventory == null) {
            this.inventory = new InventoryJS((Container)this.minecraftPlayer.m_150109_()){

                @Override
                public void markDirty() {
                    PlayerJS.this.sendInventoryUpdate();
                }
            };
        }
        return this.inventory;
    }

    public void sendInventoryUpdate() {
        this.minecraftPlayer.m_150109_().m_6596_();
        ((Player)this.minecraftPlayer).f_36095_.m_38946_();
    }

    public void give(ItemStackJS item) {
        ItemHandlerUtils.giveItemToPlayer(this.minecraftPlayer, item.getItemStack(), -1);
    }

    public void giveInHand(ItemStackJS item) {
        ItemHandlerUtils.giveItemToPlayer(this.minecraftPlayer, item.getItemStack(), this.getSelectedSlot());
    }

    public int getSelectedSlot() {
        return this.minecraftPlayer.m_150109_().f_35977_;
    }

    public void setSelectedSlot(int index) {
        this.minecraftPlayer.m_150109_().f_35977_ = Mth.m_14045_((int)index, (int)0, (int)8);
    }

    public ItemStackJS getMouseItem() {
        if (((Player)this.minecraftPlayer).f_36096_ != null) {
            return ItemStackJS.of(((Player)this.minecraftPlayer).f_36096_.m_142621_());
        }
        return ItemStackJS.of(((Player)this.minecraftPlayer).f_36095_.m_142621_());
    }

    public void setMouseItem(ItemStackJS item) {
        if (((Player)this.minecraftPlayer).f_36096_ != null) {
            ((Player)this.minecraftPlayer).f_36096_.m_142503_(item.getItemStack());
        } else {
            ((Player)this.minecraftPlayer).f_36095_.m_142503_(item.getItemStack());
        }
    }

    @Override
    public void setPositionAndRotation(double x, double y, double z, float yaw, float pitch) {
        super.setPositionAndRotation(x, y, z, yaw, pitch);
        if (this.minecraftPlayer instanceof ServerPlayer) {
            ((ServerPlayer)this.minecraftPlayer).f_8906_.m_9774_(x, y, z, yaw, pitch);
        }
    }

    @Override
    public void setStatusMessage(Component message) {
        this.minecraftPlayer.m_5661_(message, true);
    }

    public boolean isCreativeMode() {
        return this.minecraftPlayer.m_7500_();
    }

    public boolean isSpectator() {
        return this.minecraftPlayer.m_5833_();
    }

    public abstract PlayerStatsJS getStats();

    @Override
    public void spawn() {
    }

    public void sendData(String channel, @Nullable CompoundTag data) {
    }

    public void addFood(int f, float m) {
        this.minecraftPlayer.m_36324_().m_38707_(f, m);
    }

    public int getFoodLevel() {
        return this.minecraftPlayer.m_36324_().m_38702_();
    }

    public void setFoodLevel(int foodLevel) {
        this.minecraftPlayer.m_36324_().m_38705_(foodLevel);
    }

    public void addExhaustion(float exhaustion) {
        this.minecraftPlayer.m_36399_(exhaustion);
    }

    public void addXP(int xp) {
        this.minecraftPlayer.m_6756_(xp);
    }

    public void addXPLevels(int l) {
        this.minecraftPlayer.m_6749_(l);
    }

    public void setXp(int xp) {
        ((Player)this.minecraftPlayer).f_36079_ = 0;
        ((Player)this.minecraftPlayer).f_36080_ = 0.0f;
        ((Player)this.minecraftPlayer).f_36078_ = 0;
        this.minecraftPlayer.m_6756_(xp);
    }

    public int getXp() {
        return ((Player)this.minecraftPlayer).f_36079_;
    }

    public void setXpLevel(int l) {
        ((Player)this.minecraftPlayer).f_36079_ = 0;
        ((Player)this.minecraftPlayer).f_36080_ = 0.0f;
        ((Player)this.minecraftPlayer).f_36078_ = 0;
        this.minecraftPlayer.m_6749_(l);
    }

    public int getXpLevel() {
        return ((Player)this.minecraftPlayer).f_36078_;
    }

    public abstract void paint(CompoundTag var1);

    public void boostElytraFlight() {
        if (this.minecraftPlayer.m_21255_()) {
            Vec3 v = this.minecraftPlayer.m_20154_();
            double d0 = 1.5;
            double d1 = 0.1;
            Vec3 m = this.minecraftPlayer.m_20184_();
            this.minecraftPlayer.m_20256_(m.m_82520_(v.f_82479_ * 0.1 + (v.f_82479_ * 1.5 - m.f_82479_) * 0.5, v.f_82480_ * 0.1 + (v.f_82480_ * 1.5 - m.f_82480_) * 0.5, v.f_82481_ * 0.1 + (v.f_82481_ * 1.5 - m.f_82481_) * 0.5));
        }
    }

    public void closeInventory() {
        this.minecraftPlayer.m_6915_();
    }

    public AbstractContainerMenu getOpenInventory() {
        return ((Player)this.minecraftPlayer).f_36096_;
    }

    public abstract boolean isMiningBlock();

    public void addItemCooldown(Item item, int ticks) {
        this.minecraftPlayer.m_36335_().m_41524_(item, ticks);
    }

    public int getAirSupply() {
        return this.minecraftPlayer.m_20146_();
    }

    public void setAirSupply(int air) {
        this.minecraftPlayer.m_20301_(air);
    }

    public int getMaxAirSupply() {
        return this.minecraftPlayer.m_6062_();
    }

    public Stages getStages() {
        return ((PlayerKJS)this.minecraftPlayer).getStagesKJS();
    }
}

