/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.player;

import com.mojang.authlib.GameProfile;
import dev.latvian.mods.kubejs.level.LevelJS;
import dev.latvian.mods.kubejs.level.ServerLevelJS;
import dev.latvian.mods.kubejs.player.PlayerDataJS;
import dev.latvian.mods.kubejs.player.ServerPlayerJS;
import dev.latvian.mods.kubejs.server.ServerJS;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class ServerPlayerDataJS
extends PlayerDataJS<ServerPlayer, ServerPlayerJS> {
    private final ServerJS server;
    private final UUID id;
    private final String name;
    private final GameProfile profile;
    private final boolean hasClientMod;

    public ServerPlayerDataJS(ServerJS s, UUID i, String n, boolean h) {
        this.server = s;
        this.id = i;
        this.name = n;
        this.profile = new GameProfile(this.id, this.name);
        this.hasClientMod = h;
    }

    public ServerJS getServer() {
        return this.server;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public GameProfile getProfile() {
        return this.profile;
    }

    @Override
    public LevelJS getOverworld() {
        return this.server.getOverworld();
    }

    @Override
    @Nullable
    public ServerPlayer getMinecraftPlayer() {
        return this.server.getMinecraftServer().m_6846_().m_11259_(this.getId());
    }

    @Override
    public ServerPlayerJS getPlayer() {
        ServerPlayer p = this.getMinecraftPlayer();
        if (p == null) {
            throw new NullPointerException("Player entity for " + this.getName() + " not found!");
        }
        return new ServerPlayerJS(this, (ServerLevelJS)this.server.getLevel(p.f_19853_), p);
    }

    @Override
    public boolean hasClientMod() {
        return this.hasClientMod;
    }
}

