/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.special;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.architectury.core.AbstractRecipeSerializer;
import dev.latvian.mods.kubejs.recipe.KubeJSRecipeEventHandler;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class ShapedKubeJSRecipe
extends ShapedRecipe {
    private String group;
    private int width;
    private int height;
    private NonNullList<Ingredient> ingredients;
    private ItemStack result;
    private boolean mirror;
    private boolean shrink;
    private List<IngredientAction> ingredientActions;

    public ShapedKubeJSRecipe(ResourceLocation _id) {
        super(_id, "", 0, 0, NonNullList.m_122780_((int)0, (Object)Ingredient.f_43901_), ItemStack.f_41583_);
    }

    public RecipeSerializer<?> m_7707_() {
        return KubeJSRecipeEventHandler.SHAPED.get();
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public boolean m_8004_(int w, int h) {
        return w >= this.width && h >= this.height;
    }

    public boolean m_5818_(CraftingContainer craftingContainer, Level level) {
        for (int x = 0; x <= craftingContainer.m_39347_() - this.width; ++x) {
            for (int y = 0; y <= craftingContainer.m_39346_() - this.height; ++y) {
                if (this.mirror && this.matches(craftingContainer, x, y, true)) {
                    return true;
                }
                if (!this.matches(craftingContainer, x, y, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(CraftingContainer craftingContainer, int x0, int y0, boolean mirrorPattern) {
        for (int x = 0; x < craftingContainer.m_39347_(); ++x) {
            for (int y = 0; y < craftingContainer.m_39346_(); ++y) {
                int m = x - x0;
                int n = y - y0;
                Ingredient ingredient = Ingredient.f_43901_;
                if (m >= 0 && n >= 0 && m < this.width && n < this.height) {
                    ingredient = mirrorPattern ? (Ingredient)this.ingredients.get(this.width - m - 1 + n * this.width) : (Ingredient)this.ingredients.get(m + n * this.width);
                }
                if (ingredient.test(craftingContainer.m_8020_(x + y * craftingContainer.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack m_5874_(CraftingContainer craftingContainer) {
        return this.m_8043_().m_41777_();
    }

    public int m_44220_() {
        return this.width;
    }

    public int m_44221_() {
        return this.height;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList list = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, (Object)IngredientAction.getRemaining(container, i, this.ingredientActions));
        }
        return list;
    }

    private static NonNullList<Ingredient> dissolvePattern(String[] pattern, Map<String, Ingredient> key, int w, int h) {
        NonNullList nonNullList = NonNullList.m_122780_((int)(w * h), (Object)Ingredient.f_43901_);
        HashSet set = Sets.newHashSet(key.keySet());
        set.remove(" ");
        for (int k = 0; k < pattern.length; ++k) {
            for (int l = 0; l < pattern[k].length(); ++l) {
                String string = pattern[k].substring(l, l + 1);
                Ingredient ingredient = key.get(string);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + string + "' but it's not defined in the key");
                }
                set.remove(string);
                nonNullList.set(l + w * k, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonNullList;
    }

    private static String[] shrink(String[] strings) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int m = 0; m < strings.length; ++m) {
            String string = strings[m];
            i = Math.min(i, ShapedKubeJSRecipe.firstNonSpace(string));
            int n = ShapedKubeJSRecipe.lastNonSpace(string);
            j = Math.max(j, n);
            if (n < 0) {
                if (k == m) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (strings.length == l) {
            return new String[0];
        }
        String[] strings2 = new String[strings.length - l - k];
        for (int o = 0; o < strings2.length; ++o) {
            strings2[o] = strings[o + k].substring(i, j + 1);
        }
        return strings2;
    }

    private static int firstNonSpace(String string) {
        int i;
        for (i = 0; i < string.length() && string.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String string) {
        int i;
        for (i = string.length() - 1; i >= 0 && string.charAt(i) == ' '; --i) {
        }
        return i;
    }

    private static String[] patternFromJson(JsonArray jsonArray) {
        String[] strings = new String[jsonArray.size()];
        if (strings.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (strings.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < strings.length; ++i) {
            String string = GsonHelper.m_13805_((JsonElement)jsonArray.get(i), (String)("pattern[" + i + "]"));
            if (string.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && strings[0].length() != string.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            strings[i] = string;
        }
        return strings;
    }

    private static Map<String, Ingredient> keyFromJson(JsonObject jsonObject) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : jsonObject.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    public static class SerializerKJS
    extends AbstractRecipeSerializer<ShapedKubeJSRecipe> {
        public ShapedKubeJSRecipe fromJson(ResourceLocation id, JsonObject json) {
            ShapedKubeJSRecipe r = new ShapedKubeJSRecipe(id);
            r.mirror = !json.has("mirror") || json.get("mirror").getAsBoolean();
            r.shrink = !json.has("shrink") || json.get("shrink").getAsBoolean();
            r.group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Map<String, Ingredient> key = ShapedKubeJSRecipe.keyFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] pattern = ShapedKubeJSRecipe.patternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern"));
            if (r.shrink) {
                pattern = ShapedKubeJSRecipe.shrink(pattern);
            }
            r.width = pattern[0].length();
            r.height = pattern.length;
            r.ingredients = ShapedKubeJSRecipe.dissolvePattern(pattern, key, r.width, r.height);
            r.result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            r.ingredientActions = IngredientAction.parseList(json.get("kubejs_actions"));
            return r;
        }

        public ShapedKubeJSRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            ShapedKubeJSRecipe r = new ShapedKubeJSRecipe(id);
            r.group = buf.m_130136_(Short.MAX_VALUE);
            r.width = buf.m_130242_();
            r.height = buf.m_130242_();
            r.ingredients = NonNullList.m_122780_((int)(r.width * r.height), (Object)Ingredient.f_43901_);
            for (int i = 0; i < r.width * r.height; ++i) {
                r.ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            r.result = buf.m_130267_();
            r.mirror = buf.readBoolean();
            r.shrink = buf.readBoolean();
            r.ingredientActions = IngredientAction.readList(buf);
            return r;
        }

        public void toNetwork(FriendlyByteBuf buf, ShapedKubeJSRecipe r) {
            buf.m_130070_(r.group);
            buf.m_130130_(r.width);
            buf.m_130130_(r.height);
            for (Ingredient ingredient : r.ingredients) {
                ingredient.m_43923_(buf);
            }
            buf.m_130055_(r.result);
            buf.writeBoolean(r.mirror);
            buf.writeBoolean(r.shrink);
            IngredientAction.writeList(buf, r.ingredientActions);
        }
    }
}

