/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.special;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.architectury.core.AbstractRecipeSerializer;
import dev.latvian.mods.kubejs.recipe.KubeJSRecipeEventHandler;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientAction;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;

public class ShapelessKubeJSRecipe
extends ShapelessRecipe {
    private String group;
    private ItemStack result;
    private NonNullList<Ingredient> ingredients;
    private List<IngredientAction> ingredientActions;

    public ShapelessKubeJSRecipe(ResourceLocation _id) {
        super(_id, "", ItemStack.f_41583_, NonNullList.m_122780_((int)0, (Object)Ingredient.f_43901_));
    }

    public RecipeSerializer<?> m_7707_() {
        return KubeJSRecipeEventHandler.SHAPELESS.get();
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public boolean m_5818_(CraftingContainer craftingContainer, Level level) {
        StackedContents stackedContents = new StackedContents();
        int count = 0;
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            ItemStack stack = craftingContainer.m_8020_(i);
            if (stack.m_41619_()) continue;
            ++count;
            stackedContents.m_36468_(stack, 1);
        }
        return count == this.ingredients.size() && stackedContents.m_36475_((Recipe)this, null);
    }

    public ItemStack m_5874_(CraftingContainer craftingContainer) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int w, int h) {
        return w * h >= this.ingredients.size();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList list = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, (Object)IngredientAction.getRemaining(container, i, this.ingredientActions));
        }
        return list;
    }

    public static class SerializerKJS
    extends AbstractRecipeSerializer<ShapelessKubeJSRecipe> {
        public ShapelessKubeJSRecipe fromJson(ResourceLocation id, JsonObject json) {
            ShapelessKubeJSRecipe r = new ShapelessKubeJSRecipe(id);
            r.group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            r.ingredients = SerializerKJS.itemsFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (r.ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (r.ingredients.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe");
            }
            r.result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            r.ingredientActions = IngredientAction.parseList(json.get("kubejs_actions"));
            return r;
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray a) {
            NonNullList list = NonNullList.m_122779_();
            for (int i = 0; i < a.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)a.get(i));
                if (ingredient.m_43947_()) continue;
                list.add((Object)ingredient);
            }
            return list;
        }

        public ShapelessKubeJSRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            ShapelessKubeJSRecipe r = new ShapelessKubeJSRecipe(id);
            r.group = buf.m_130136_(Short.MAX_VALUE);
            int s = buf.m_130242_();
            r.ingredients = NonNullList.m_122780_((int)s, (Object)Ingredient.f_43901_);
            for (int i = 0; i < s; ++i) {
                r.ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            r.result = buf.m_130267_();
            r.ingredientActions = IngredientAction.readList(buf);
            return r;
        }

        public void toNetwork(FriendlyByteBuf buf, ShapelessKubeJSRecipe r) {
            buf.m_130070_(r.group);
            buf.m_130130_(r.ingredients.size());
            for (Ingredient ingredient : r.ingredients) {
                ingredient.m_43923_(buf);
            }
            buf.m_130055_(r.result);
            IngredientAction.writeList(buf, r.ingredientActions);
        }
    }
}

