/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script.data;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import dev.latvian.mods.kubejs.KubeJSObjects;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.util.BuilderBase;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.ResourcePackFileNotFoundException;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import org.jetbrains.annotations.Nullable;

public abstract class KubeJSResourcePack
implements PackResources {
    private final PackType packType;
    private Map<ResourceLocation, JsonElement> cachedResources;

    public KubeJSResourcePack(PackType t) {
        this.packType = t;
    }

    private static String getFullPath(PackType type, ResourceLocation location) {
        return String.format("%s/%s/%s", type.m_10305_(), location.m_135827_(), location.m_135815_());
    }

    public InputStream m_5542_(String fileName) throws IOException {
        if (fileName.equals("pack.png")) {
            return KubeJSResourcePack.class.getResourceAsStream("/kubejs_logo.png");
        }
        throw new ResourcePackFileNotFoundException(KubeJSPaths.DIRECTORY.toFile(), fileName);
    }

    public InputStream m_8031_(PackType type, ResourceLocation location) throws IOException {
        JsonElement json;
        String resourcePath = KubeJSResourcePack.getFullPath(type, location);
        if (type != this.packType) {
            throw new IllegalStateException(this.packType.m_10305_() + " KubeJS pack can't load " + resourcePath + "!");
        }
        Path file = KubeJSPaths.DIRECTORY.resolve(resourcePath);
        if (Files.exists(file, new LinkOption[0])) {
            return Files.newInputStream(file, new OpenOption[0]);
        }
        if (location.m_135815_().endsWith(".json") && (json = this.getCachedResources().get(location)) != null) {
            return new ByteArrayInputStream(json.toString().getBytes(StandardCharsets.UTF_8));
        }
        throw new ResourcePackFileNotFoundException(KubeJSPaths.DIRECTORY.toFile(), resourcePath);
    }

    public boolean m_7211_(PackType type, ResourceLocation location) {
        JsonElement json;
        if (location.m_135815_().endsWith(".json") && (json = this.getCachedResources().get(location)) != null) {
            return true;
        }
        return type == this.packType && Files.exists(KubeJSPaths.DIRECTORY.resolve(KubeJSResourcePack.getFullPath(type, location)), new LinkOption[0]);
    }

    public Map<ResourceLocation, JsonElement> getCachedResources() {
        if (this.cachedResources == null) {
            HashMap<ResourceLocation, JsonElement> map = new HashMap<ResourceLocation, JsonElement>();
            this.generateJsonFiles(map);
            this.cachedResources = new HashMap<ResourceLocation, JsonElement>();
            for (Map.Entry entry : map.entrySet()) {
                this.cachedResources.put(new ResourceLocation(((ResourceLocation)entry.getKey()).m_135827_(), ((ResourceLocation)entry.getKey()).m_135815_() + ".json"), (JsonElement)entry.getValue());
            }
        }
        return this.cachedResources;
    }

    public void generateJsonFiles(Map<ResourceLocation, JsonElement> map) {
    }

    public Collection<ResourceLocation> m_7466_(PackType type, String namespace, String path, int maxDepth, Predicate<String> filter) {
        if (type != this.packType) {
            return Collections.emptySet();
        }
        ArrayList list = Lists.newArrayList();
        if (type == PackType.CLIENT_RESOURCES) {
            if (path.equals("lang")) {
                list.add(new ResourceLocation("kubejs", "lang/en_us.json"));
            }
        } else if (path.equals("loot_tables")) {
            for (ResourceLocation id : KubeJSObjects.BLOCKS.keySet()) {
                list.add(new ResourceLocation(id.m_135827_(), "loot_tables/blocks/" + id.m_135815_() + ".json"));
            }
        }
        UtilsJS.tryIO(() -> {
            Path root = KubeJSPaths.get(type).toAbsolutePath();
            if (Files.exists(root, new LinkOption[0]) && Files.isDirectory(root, new LinkOption[0])) {
                Path inputPath = root.getFileSystem().getPath(path, new String[0]);
                Files.walk(root, new FileVisitOption[0]).map(p -> root.relativize(p.toAbsolutePath())).filter(p -> p.getNameCount() > 1 && p.getNameCount() - 1 <= maxDepth).filter(p -> !p.toString().endsWith(".mcmeta")).filter(p -> p.subpath(1, p.getNameCount()).startsWith(inputPath)).filter(p -> filter.test(p.getFileName().toString())).map(p -> new ResourceLocation(p.getName(0).toString(), Joiner.on((char)'/').join((Iterable)p.subpath(1, Math.min(maxDepth, p.getNameCount()))))).forEach(list::add);
            }
        });
        return list;
    }

    public Set<String> m_5698_(PackType type) {
        if (type != this.packType) {
            return Collections.emptySet();
        }
        HashSet<String> namespaces = new HashSet<String>();
        namespaces.add("kubejs_generated");
        namespaces.add("kubejs");
        for (BuilderBase builder : KubeJSObjects.ALL) {
            namespaces.add(builder.id.m_135827_());
        }
        UtilsJS.tryIO(() -> {
            Path root = KubeJSPaths.get(type).toAbsolutePath();
            if (Files.exists(root, new LinkOption[0]) && Files.isDirectory(root, new LinkOption[0])) {
                Files.walk(root, 1, new FileVisitOption[0]).map(path -> root.relativize(path.toAbsolutePath())).filter(path -> path.getNameCount() > 0).map(p -> p.toString().replaceAll("/$", "")).filter(s -> !s.isEmpty()).forEach(namespaces::add);
            }
        });
        return namespaces;
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> serializer) {
        return null;
    }

    public String m_8017_() {
        return "KubeJS Resource Pack [" + this.packType.m_10305_() + "]";
    }

    public void close() {
        this.cachedResources = null;
    }
}

