/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script.data;

import com.google.common.collect.Lists;
import dev.latvian.mods.kubejs.server.ServerSettings;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import org.jetbrains.annotations.Nullable;

public class VirtualKubeJSDataPack
extends AbstractPackResources {
    public final boolean high;
    private final Map<ResourceLocation, String> locationToData;
    private final Map<String, String> pathToData;
    private final Set<String> namespaces;

    public VirtualKubeJSDataPack(boolean h) {
        super(new File("dummy"));
        this.high = h;
        this.locationToData = new HashMap<ResourceLocation, String>();
        this.pathToData = new HashMap<String, String>();
        this.namespaces = new HashSet<String>();
    }

    public void addData(ResourceLocation id, String data) {
        this.locationToData.put(id, data);
        this.pathToData.put("data/" + id.m_135827_() + "/" + id.m_135815_(), data);
        this.namespaces.add(id.m_135827_());
        if (ServerSettings.instance.dataPackOutput) {
            ConsoleJS.SERVER.info("Registered virtual file [" + (this.high ? "high" : "low") + " priority] '" + id + "': " + data);
        }
    }

    public InputStream m_5541_(String path) throws IOException {
        String s = this.pathToData.get(path);
        if (s != null) {
            if (ServerSettings.instance.dataPackOutput) {
                ConsoleJS.SERVER.info("Served virtual file [" + (this.high ? "high" : "low") + " priority] '" + path + "': " + s);
            }
            return new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));
        }
        throw new FileNotFoundException(path);
    }

    public InputStream m_8031_(PackType type, ResourceLocation location) throws IOException {
        String s = this.locationToData.get(location);
        if (s != null) {
            if (ServerSettings.instance.dataPackOutput) {
                ConsoleJS.SERVER.info("Served virtual file [" + (this.high ? "high" : "low") + " priority] '" + location + "': " + s);
            }
            return new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));
        }
        throw new FileNotFoundException(location.toString());
    }

    public boolean m_6105_(String path) {
        return this.pathToData.containsKey(path);
    }

    public boolean m_7211_(PackType type, ResourceLocation location) {
        return type == PackType.SERVER_DATA && this.locationToData.containsKey(location);
    }

    public Collection<ResourceLocation> m_7466_(PackType type, String namespace, String path, int maxDepth, Predicate<String> filter) {
        ArrayList list = Lists.newArrayList();
        for (ResourceLocation key : this.locationToData.keySet()) {
            if (!namespace.equals(key.m_135827_())) continue;
            try {
                String p;
                int i = key.m_135815_().lastIndexOf(47);
                String string = p = i == -1 ? key.m_135815_() : key.m_135815_().substring(i + 1);
                if (!key.m_135815_().startsWith(path) || !filter.test(p)) continue;
                list.add(key);
            }
            catch (Exception exception) {}
        }
        return list;
    }

    public Set<String> m_5698_(PackType type) {
        return new HashSet<String>(this.namespaces);
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> serializer) {
        return null;
    }

    public String m_8017_() {
        return "KubeJS Virtual Data Pack [" + (this.high ? "high" : "low") + " priority]";
    }

    public void close() {
    }

    public boolean hasNamespace(String key) {
        return this.namespaces.contains(key);
    }
}

