/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.server;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.CommandPerformEvent;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.latvian.mods.kubejs.command.KubeJSCommands;
import dev.latvian.mods.kubejs.level.ServerLevelJS;
import dev.latvian.mods.kubejs.level.SimpleLevelEventJS;
import dev.latvian.mods.kubejs.player.PlayerDataJS;
import dev.latvian.mods.kubejs.player.SimplePlayerEventJS;
import dev.latvian.mods.kubejs.script.AttachDataEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.CommandEventJS;
import dev.latvian.mods.kubejs.server.ScheduledEvent;
import dev.latvian.mods.kubejs.server.ServerEventJS;
import dev.latvian.mods.kubejs.server.ServerJS;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.rhino.RhinoException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;

public class KubeJSServerEventHandler {
    private static final LevelResource PERSISTENT_DATA = new LevelResource("kubejs_persistent_data.nbt");

    public static void init() {
        LifecycleEvent.SERVER_BEFORE_START.register(KubeJSServerEventHandler::serverAboutToStart);
        CommandRegistrationEvent.EVENT.register(KubeJSServerEventHandler::registerCommands);
        LifecycleEvent.SERVER_STARTED.register(KubeJSServerEventHandler::serverStarted);
        LifecycleEvent.SERVER_STOPPING.register(KubeJSServerEventHandler::serverStopping);
        LifecycleEvent.SERVER_LEVEL_SAVE.register(KubeJSServerEventHandler::serverWorldSave);
        TickEvent.SERVER_POST.register(KubeJSServerEventHandler::serverTick);
        CommandPerformEvent.EVENT.register(KubeJSServerEventHandler::command);
    }

    public static void serverAboutToStart(MinecraftServer server) {
        if (ServerJS.instance != null) {
            KubeJSServerEventHandler.destroyServer();
        }
        ServerJS.instance = new ServerJS(server, ServerScriptManager.instance);
        Path p = server.m_129843_(PERSISTENT_DATA);
        if (Files.exists(p, new LinkOption[0])) {
            try {
                CompoundTag tag = NbtIo.m_128937_((File)p.toFile());
                if (tag != null) {
                    ServerJS.instance.persistentData.m_128391_(tag);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection selection) {
        KubeJSCommands.register(dispatcher);
    }

    public static void serverStarted(MinecraftServer server) {
        ServerJS.instance.overworld = new ServerLevelJS(ServerJS.instance, server.m_129880_(Level.f_46428_));
        ServerJS.instance.levelMap.put("minecraft:overworld", ServerJS.instance.overworld);
        ServerJS.instance.allLevels.add(ServerJS.instance.overworld);
        for (ServerLevel serverLevel : server.m_129785_()) {
            if (serverLevel == ServerJS.instance.overworld.minecraftLevel) continue;
            ServerLevelJS l = new ServerLevelJS(ServerJS.instance, serverLevel);
            ServerJS.instance.levelMap.put(serverLevel.m_46472_().m_135782_().toString(), l);
        }
        ServerJS.instance.updateWorldList();
        AttachDataEvent.forServer(ServerJS.instance).invoke();
        new ServerEventJS().post(ScriptType.SERVER, "server.load");
        for (ServerLevelJS serverLevelJS : ServerJS.instance.allLevels) {
            AttachDataEvent.forLevel(serverLevelJS).invoke();
            new SimpleLevelEventJS(serverLevelJS).post("level.load");
        }
    }

    public static void serverStopping(MinecraftServer server) {
        KubeJSServerEventHandler.destroyServer();
    }

    public static void destroyServer() {
        ServerJS s = ServerJS.instance;
        for (PlayerDataJS playerDataJS : s.playerMap.values()) {
            new SimplePlayerEventJS((Player)playerDataJS.getMinecraftPlayer()).post("player.logged_out");
        }
        for (ServerLevelJS serverLevelJS : s.levelMap.values()) {
            new SimpleLevelEventJS(serverLevelJS).post("level.unload");
        }
        new ServerEventJS().post(ScriptType.SERVER, "server.unload");
        s.release();
        ServerJS.instance = null;
    }

    private static void serverWorldSave(ServerLevel level) {
        ServerJS s = ServerJS.instance;
        Path p = level.m_142572_().m_129843_(PERSISTENT_DATA);
        if (s != null && level.m_46472_() == Level.f_46428_) {
            Util.m_183992_().execute(() -> {
                try {
                    NbtIo.m_128944_((CompoundTag)s.persistentData, (File)p.toFile());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
        }
    }

    public static void serverTick(MinecraftServer server) {
        Object e;
        ArrayList<Object> list;
        Iterator<ScheduledEvent> eventIterator;
        long now;
        ServerJS s = ServerJS.instance;
        if (!s.scheduledEvents.isEmpty()) {
            now = System.currentTimeMillis();
            eventIterator = s.scheduledEvents.iterator();
            list = new ArrayList<Object>();
            while (eventIterator.hasNext()) {
                e = eventIterator.next();
                if (now < ((ScheduledEvent)e).getEndTime()) continue;
                list.add(e);
                eventIterator.remove();
            }
            for (ScheduledEvent scheduledEvent : list) {
                try {
                    scheduledEvent.call();
                }
                catch (RhinoException ex) {
                    ConsoleJS.SERVER.error("Error occurred while handling scheduled event callback: " + ex.getMessage());
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (!s.scheduledTickEvents.isEmpty()) {
            now = s.getOverworld().getTime();
            eventIterator = s.scheduledTickEvents.iterator();
            list = new ArrayList();
            while (eventIterator.hasNext()) {
                e = eventIterator.next();
                if (now < ((ScheduledEvent)e).getEndTime()) continue;
                list.add(e);
                eventIterator.remove();
            }
            for (ScheduledEvent scheduledEvent : list) {
                try {
                    scheduledEvent.call();
                }
                catch (RhinoException ex) {
                    ConsoleJS.SERVER.error("Error occurred while handling scheduled event callback: " + ex.getMessage());
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        }
        new ServerEventJS().post(ScriptType.SERVER, "server.tick");
    }

    public static EventResult command(CommandPerformEvent event) {
        if (new CommandEventJS(event).post(ScriptType.SERVER, "command.run")) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }
}

