/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.server;

import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.item.ingredient.IngredientWithCustomPredicateJS;
import dev.latvian.mods.kubejs.recipe.RecipeEventJS;
import dev.latvian.mods.kubejs.recipe.RecipeTypeJS;
import dev.latvian.mods.kubejs.recipe.RecipeTypeRegistryEventJS;
import dev.latvian.mods.kubejs.recipe.RegisterRecipeHandlersEvent;
import dev.latvian.mods.kubejs.recipe.ingredientaction.CustomIngredientAction;
import dev.latvian.mods.kubejs.script.ScriptFile;
import dev.latvian.mods.kubejs.script.ScriptFileInfo;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.kubejs.script.ScriptPack;
import dev.latvian.mods.kubejs.script.ScriptPackInfo;
import dev.latvian.mods.kubejs.script.ScriptSource;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.data.DataPackEventJS;
import dev.latvian.mods.kubejs.script.data.VirtualKubeJSDataPack;
import dev.latvian.mods.kubejs.server.KubeJSServerResourcePack;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.KubeJSPlugins;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleReloadableResourceManager;

public class ServerScriptManager {
    public static ServerScriptManager instance;
    public final ScriptManager scriptManager = new ScriptManager(ScriptType.SERVER, KubeJSPaths.SERVER_SCRIPTS, "/data/kubejs/example_server_script.js");

    public void init(ServerResources serverResources) {
        try {
            if (Files.notExists(KubeJSPaths.DATA, new LinkOption[0])) {
                Files.createDirectories(KubeJSPaths.DATA, new FileAttribute[0]);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException("KubeJS failed to register it's script loader!", ex);
        }
    }

    public void reloadScriptManager(ResourceManager resourceManager) {
        this.scriptManager.unload();
        this.scriptManager.loadFromDirectory();
        HashMap<String, List> packs = new HashMap<String, List>();
        for (ResourceLocation resourceLocation : resourceManager.m_6540_("kubejs", s -> s.endsWith(".js"))) {
            packs.computeIfAbsent(resourceLocation.m_135827_(), s -> new ArrayList()).add(resourceLocation);
        }
        for (Map.Entry entry : packs.entrySet()) {
            ScriptPack pack = new ScriptPack(this.scriptManager, new ScriptPackInfo((String)entry.getKey(), "kubejs/"));
            for (ResourceLocation id : (List)entry.getValue()) {
                pack.info.scripts.add(new ScriptFileInfo(pack.info, id.m_135815_().substring(7)));
            }
            for (ScriptFileInfo fileInfo : pack.info.scripts) {
                ScriptSource.FromResource scriptSource = info -> resourceManager.m_142591_(info.id);
                Throwable error = fileInfo.preload(scriptSource);
                if (fileInfo.isIgnored()) continue;
                if (error == null) {
                    pack.scripts.add(new ScriptFile(pack, fileInfo, scriptSource));
                    continue;
                }
                KubeJS.LOGGER.error("Failed to pre-load script file " + fileInfo.location + ": " + error);
            }
            pack.scripts.sort(null);
            this.scriptManager.packs.put(pack.info.namespace, pack);
        }
        this.scriptManager.load();
    }

    public List<PackResources> resourcePackList(List<PackResources> list0) {
        VirtualKubeJSDataPack virtualDataPackLow = new VirtualKubeJSDataPack(false);
        VirtualKubeJSDataPack virtualDataPackHigh = new VirtualKubeJSDataPack(true);
        ArrayList<PackResources> list = new ArrayList<PackResources>();
        list.add((PackResources)virtualDataPackLow);
        list.addAll(list0);
        list.add(new KubeJSServerResourcePack());
        list.add((PackResources)virtualDataPackHigh);
        SimpleReloadableResourceManager resourceManager = new SimpleReloadableResourceManager(PackType.SERVER_DATA);
        for (PackResources p : list) {
            resourceManager.m_10880_(p);
        }
        this.reloadScriptManager((ResourceManager)resourceManager);
        ConsoleJS.SERVER.setLineNumber(true);
        new DataPackEventJS(virtualDataPackLow).post(ScriptType.SERVER, "server.datapack.last");
        new DataPackEventJS(virtualDataPackLow).post(ScriptType.SERVER, "server.datapack.low_priority");
        new DataPackEventJS(virtualDataPackHigh).post(ScriptType.SERVER, "server.datapack.first");
        new DataPackEventJS(virtualDataPackHigh).post(ScriptType.SERVER, "server.datapack.high_priority");
        UtilsJS.postModificationEvents();
        ConsoleJS.SERVER.setLineNumber(false);
        ConsoleJS.SERVER.info("Scripts loaded");
        HashMap<ResourceLocation, RecipeTypeJS> typeMap = new HashMap<ResourceLocation, RecipeTypeJS>();
        RegisterRecipeHandlersEvent modEvent = new RegisterRecipeHandlersEvent(typeMap);
        KubeJSPlugins.forEachPlugin(plugin -> plugin.addRecipes(modEvent));
        new RecipeTypeRegistryEventJS(typeMap).post(ScriptType.SERVER, "recipes.type_registry");
        if (Platform.isForge()) {
            RecipeEventJS.customIngredientMap = new HashMap<UUID, IngredientWithCustomPredicateJS>();
        }
        CustomIngredientAction.MAP.clear();
        RecipeEventJS.instance = new RecipeEventJS(typeMap);
        return list;
    }
}

