/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.server;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.registry.registries.Registrar;
import dev.latvian.mods.kubejs.KubeJSObjects;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.core.TagBuilderKJS;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.ServerSettings;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import org.jetbrains.annotations.Nullable;

public class TagEventJS<T>
extends EventJS {
    private final String type;
    private final Map<ResourceLocation, Tag.Builder> map;
    private final Function<ResourceLocation, Optional<T>> registry;
    private Map<ResourceLocation, TagWrapper<T>> tags;
    private int addedCount;
    private int removedCount;
    private List<Predicate<String>> globalPriorityList;
    private Registrar<T> registrar;

    private static String getIdOfEntry(String s) {
        if (s.length() > 0 && s.charAt(s.length() - 1) == '?') {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    @Nullable
    private static List<Predicate<String>> parsePriorityList(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        ArrayList<Predicate<String>> list = new ArrayList<Predicate<String>>();
        for (Object o1 : ListJS.orSelf(o)) {
            String m;
            String s = String.valueOf(o1);
            if (s.startsWith("@")) {
                m = s.substring(1);
                list.add(id -> id.startsWith(m));
                continue;
            }
            if (s.startsWith("!@")) {
                m = s.substring(2);
                list.add(id -> !id.startsWith(m));
                continue;
            }
            list.add(id -> id.equals(s));
        }
        return list.isEmpty() ? null : list;
    }

    public TagEventJS(String t, Map<ResourceLocation, Tag.Builder> m, Function<ResourceLocation, Optional<T>> r) {
        this.type = t;
        this.map = m;
        this.registry = r;
        this.addedCount = 0;
        this.removedCount = 0;
        this.globalPriorityList = null;
        this.registrar = null;
        switch (this.type) {
            case "items": {
                this.registrar = (Registrar)UtilsJS.cast(KubeJSRegistries.items());
                break;
            }
            case "blocks": {
                this.registrar = (Registrar)UtilsJS.cast(KubeJSRegistries.blocks());
                break;
            }
            case "fluids": {
                this.registrar = (Registrar)UtilsJS.cast(KubeJSRegistries.fluids());
                break;
            }
            case "entity_types": {
                this.registrar = (Registrar)UtilsJS.cast(KubeJSRegistries.entityTypes());
            }
        }
    }

    public String getType() {
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    public void post(String event) {
        Path dumpFile = KubeJSPaths.EXPORTED.resolve("tags/" + this.type + ".txt");
        if (!Files.exists(dumpFile, new LinkOption[0])) {
            try {
                if (!Files.exists(dumpFile.getParent(), new LinkOption[0])) {
                    Files.createDirectories(dumpFile.getParent(), new FileAttribute[0]);
                }
                ArrayList<CallSite> lines = new ArrayList<CallSite>();
                this.map.forEach((tagId, tagBuilder) -> {
                    lines.add((CallSite)((Object)""));
                    lines.add((CallSite)((Object)("#" + tagId)));
                    tagBuilder.m_13330_().forEach(builderEntry -> lines.add((CallSite)((Object)("- " + builderEntry.m_13347_()))));
                });
                lines.add(0, (CallSite)((Object)("To refresh this file, delete it and run /reload command again! Last updated: " + DateFormat.getDateTimeInstance().format(new Date()))));
                Files.write(dumpFile, lines, new OpenOption[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.tags = new HashMap<ResourceLocation, TagWrapper<T>>();
        for (Map.Entry<ResourceLocation, Tag.Builder> entry : this.map.entrySet()) {
            TagWrapper tagWrapper = new TagWrapper(this, entry.getKey(), entry.getValue());
            this.tags.put(entry.getKey(), tagWrapper);
            ConsoleJS.SERVER.debug(this.type + "/#" + entry.getKey() + "; " + tagWrapper.proxyList.size());
        }
        if (this.type.equals("items")) {
            for (ItemBuilder itemBuilder : KubeJSObjects.ITEMS.values()) {
                for (ResourceLocation s : itemBuilder.defaultTags) {
                    this.add(s, itemBuilder.id);
                }
                for (BlockBuilder block : KubeJSObjects.BLOCKS.values()) {
                    if (block.itemBuilder == null) continue;
                    for (ResourceLocation s : block.itemBuilder.defaultTags) {
                        this.add(s, block.itemBuilder.id);
                    }
                }
            }
        } else if (this.type.equals("blocks")) {
            for (BlockBuilder blockBuilder : KubeJSObjects.BLOCKS.values()) {
                for (ResourceLocation s : blockBuilder.defaultTags) {
                    this.add(s, blockBuilder.id);
                }
            }
        }
        ConsoleJS.SERVER.setLineNumber(true);
        this.post(ScriptType.SERVER, event);
        ConsoleJS.SERVER.setLineNumber(false);
        int reordered = 0;
        for (TagWrapper<T> tagWrapper : this.tags.values()) {
            if (tagWrapper.priorityList == null) {
                tagWrapper.priorityList = this.globalPriorityList;
            }
            if (tagWrapper.priorityList == null || !tagWrapper.sort()) continue;
            ++reordered;
        }
        if (ServerSettings.dataExport != null && this.registrar != null) {
            void var4_15;
            JsonObject jsonObject;
            JsonObject jsonObject2 = ServerSettings.dataExport.getAsJsonObject("tags");
            if (jsonObject2 == null) {
                JsonObject jsonObject3 = new JsonObject();
                ServerSettings.dataExport.add("tags", (JsonElement)jsonObject3);
            }
            if ((jsonObject = var4_15.getAsJsonObject(this.type)) == null) {
                JsonObject jsonObject4 = new JsonObject();
                var4_15.add(this.type, (JsonElement)jsonObject4);
            }
            for (Map.Entry<ResourceLocation, Tag.Builder> entry : this.map.entrySet()) {
                void var5_27;
                JsonArray a = new JsonArray();
                entry.getValue().m_13330_().forEach(e -> a.add(e.m_13347_().toString()));
                var5_27.add(entry.getKey().toString(), (JsonElement)a);
            }
        }
        ConsoleJS.SERVER.info("[" + this.type + "] Found " + this.tags.size() + " tags, added " + this.addedCount + " objects, removed " + this.removedCount + " objects");
    }

    public TagWrapper<T> get(ResourceLocation id) {
        TagWrapper<T> t = this.tags.get(id);
        if (t == null) {
            t = new TagWrapper(this, id, Tag.Builder.m_13304_());
            this.tags.put(id, t);
            this.map.put(id, t.builder);
        }
        return t;
    }

    public TagWrapper<T> add(ResourceLocation tag, Object ids) {
        return this.get(tag).add(ids);
    }

    public TagWrapper<T> remove(ResourceLocation tag, Object ids) {
        return this.get(tag).remove(ids);
    }

    public TagWrapper<T> removeAll(ResourceLocation tag) {
        return this.get(tag).removeAll();
    }

    public void removeAllTagsFrom(Object ids) {
        for (Object o : ListJS.orSelf(ids)) {
            String id = String.valueOf(o);
            for (TagWrapper<T> tagWrapper : this.tags.values()) {
                tagWrapper.proxyList.removeIf(proxy -> TagEventJS.getIdOfEntry(proxy.m_13347_().toString()).equals(id));
            }
        }
    }

    public void setGlobalPriorityList(@Nullable Object o) {
        this.globalPriorityList = TagEventJS.parsePriorityList(o);
    }

    public static class TagWrapper<T> {
        private final TagEventJS<T> event;
        private final ResourceLocation id;
        private final Tag.Builder builder;
        private final List<Tag.BuilderEntry> proxyList;
        private List<Predicate<String>> priorityList;

        private TagWrapper(TagEventJS<T> e, ResourceLocation i, Tag.Builder t) {
            this.event = e;
            this.id = i;
            this.builder = t;
            this.proxyList = ((TagBuilderKJS)this.builder).getProxyListKJS();
            this.priorityList = null;
        }

        public String toString() {
            return this.event.type + ":" + this.id;
        }

        public TagWrapper<T> add(Object ids) {
            for (Object o : ListJS.orSelf(ids)) {
                String s = String.valueOf(o);
                if (s.startsWith("#")) {
                    TagWrapper<T> w = this.event.get(new ResourceLocation(s.substring(1)));
                    this.builder.m_13335_(w.id, "kubejs");
                    this.event.addedCount += w.proxyList.size();
                    if (!ConsoleJS.SERVER.shouldPrintDebug()) continue;
                    ConsoleJS.SERVER.debug("+ " + this + " // " + w.id);
                    continue;
                }
                Pattern pattern = UtilsJS.parseRegex(s);
                if (pattern != null && this.event.registrar != null) {
                    for (ResourceLocation sid : this.event.registrar.getIds()) {
                        if (!pattern.matcher(sid.toString()).find()) continue;
                        Optional v = this.event.registry.apply(sid);
                        if (v.isPresent()) {
                            this.builder.m_13327_(sid, "kubejs");
                            ++this.event.addedCount;
                            if (!ConsoleJS.SERVER.shouldPrintDebug()) continue;
                            ConsoleJS.SERVER.debug("+ " + this + " // " + s + " [" + v.get().getClass().getName() + "]");
                            continue;
                        }
                        ConsoleJS.SERVER.error("+ " + this + " // " + s + " [Not found!]");
                    }
                    continue;
                }
                ResourceLocation sid = new ResourceLocation(s);
                Optional v = this.event.registry.apply(sid);
                if (v.isPresent()) {
                    this.builder.m_13327_(sid, "kubejs");
                    ++this.event.addedCount;
                    if (!ConsoleJS.SERVER.shouldPrintDebug()) continue;
                    ConsoleJS.SERVER.debug("+ " + this + " // " + s + " [" + v.get().getClass().getName() + "]");
                    continue;
                }
                ConsoleJS.SERVER.error("+ " + this + " // " + s + " [Not found!]");
            }
            return this;
        }

        public TagWrapper<T> remove(Object ids) {
            for (Object o : ListJS.orSelf(ids)) {
                String s = String.valueOf(o);
                if (s.startsWith("#")) {
                    TagWrapper<T> w = this.event.get(new ResourceLocation(s.substring(1)));
                    String entryId = w.id.toString();
                    int originalSize = this.proxyList.size();
                    this.proxyList.removeIf(proxy -> TagEventJS.getIdOfEntry(proxy.m_13347_().toString()).equals(s));
                    int removedCount = this.proxyList.size() - originalSize;
                    if (removedCount == 0) {
                        if (!ServerSettings.instance.logSkippedRecipes) continue;
                        ConsoleJS.SERVER.warn(s + " didn't contain tag " + this + ", skipped");
                        continue;
                    }
                    this.event.removedCount -= removedCount;
                    if (!ConsoleJS.SERVER.shouldPrintDebug()) continue;
                    ConsoleJS.SERVER.debug("- " + this + " // " + w.id);
                    continue;
                }
                Pattern pattern = UtilsJS.parseRegex(s);
                if (pattern != null && this.event.registrar != null) {
                    for (ResourceLocation sid : this.event.registrar.getIds()) {
                        if (!pattern.matcher(sid.toString()).find()) continue;
                        Optional v = this.event.registry.apply(sid);
                        if (v.isPresent()) {
                            int originalSize = this.proxyList.size();
                            this.proxyList.removeIf(proxy -> TagEventJS.getIdOfEntry(proxy.m_13347_().toString()).equals(s));
                            int removedCount = this.proxyList.size() - originalSize;
                            if (removedCount == 0) {
                                if (!ServerSettings.instance.logSkippedRecipes) continue;
                                ConsoleJS.SERVER.warn(s + " didn't contain tag " + this.id + ", skipped");
                                continue;
                            }
                            this.event.removedCount -= removedCount;
                            if (!ConsoleJS.SERVER.shouldPrintDebug()) continue;
                            ConsoleJS.SERVER.debug("- " + this + " // " + s + " [" + v.get().getClass().getName() + "]");
                            continue;
                        }
                        ConsoleJS.SERVER.error("- " + this + " // " + s + " [Not found!]");
                    }
                    continue;
                }
                ResourceLocation sid = new ResourceLocation(s);
                Optional v = this.event.registry.apply(sid);
                if (v.isPresent()) {
                    int originalSize = this.proxyList.size();
                    this.proxyList.removeIf(proxy -> TagEventJS.getIdOfEntry(proxy.m_13347_().toString()).equals(s));
                    int removedCount = this.proxyList.size() - originalSize;
                    if (removedCount == 0) {
                        if (!ServerSettings.instance.logSkippedRecipes) continue;
                        ConsoleJS.SERVER.warn(s + " didn't contain tag " + this.id + ", skipped");
                        continue;
                    }
                    this.event.removedCount -= removedCount;
                    if (!ConsoleJS.SERVER.shouldPrintDebug()) continue;
                    ConsoleJS.SERVER.debug("- " + this + " // " + s + " [" + v.get().getClass().getName() + "]");
                    continue;
                }
                ConsoleJS.SERVER.error("- " + this + " // " + s + " [Not found!]");
            }
            return this;
        }

        public TagWrapper<T> removeAll() {
            if (ConsoleJS.SERVER.shouldPrintDebug()) {
                ConsoleJS.SERVER.debug("- " + this + " // (all)");
            }
            if (!this.proxyList.isEmpty()) {
                this.event.removedCount += this.proxyList.size();
                this.proxyList.clear();
            } else if (ServerSettings.instance.logSkippedRecipes) {
                ConsoleJS.SERVER.warn("Tag " + this + " didn't contain any elements, skipped");
            }
            return this;
        }

        public void setPriorityList(@Nullable Object o) {
            this.priorityList = TagEventJS.parsePriorityList(o);
        }

        private void gatherAllItemIDs(HashSet<String> set, Tag.Entry entry) {
            TagWrapper w;
            if (entry instanceof Tag.ElementEntry) {
                set.add(entry.toString());
            } else if (entry instanceof Tag.TagEntry && (w = this.event.tags.get(new ResourceLocation(entry.toString().substring(1)))) != null && w != this) {
                for (Tag.BuilderEntry proxy : w.proxyList) {
                    this.gatherAllItemIDs(set, proxy.m_13347_());
                }
            }
        }

        public boolean sort() {
            ArrayList listOfLists = new ArrayList();
            for (int i = 0; i < this.priorityList.size() + 1; ++i) {
                listOfLists.add(new ArrayList());
            }
            for (Tag.BuilderEntry proxy : this.proxyList) {
                boolean bl = false;
                HashSet<String> set = new HashSet<String>();
                this.gatherAllItemIDs(set, proxy.m_13347_());
                block2: for (String id : set) {
                    for (int i = 0; i < this.priorityList.size(); ++i) {
                        if (!this.priorityList.get(i).test(id)) continue;
                        ((List)listOfLists.get(i)).add(proxy);
                        bl = true;
                        continue block2;
                    }
                }
                if (bl) continue;
                ((List)listOfLists.get(this.priorityList.size())).add(proxy);
            }
            ArrayList<Tag.BuilderEntry> proxyList0 = new ArrayList<Tag.BuilderEntry>(this.proxyList);
            this.proxyList.clear();
            for (List list : listOfLists) {
                this.proxyList.addAll(list);
            }
            if (!proxyList0.equals(this.proxyList)) {
                if (ConsoleJS.SERVER.shouldPrintDebug()) {
                    ConsoleJS.SERVER.debug("* Re-arranged " + this);
                }
                return true;
            }
            return false;
        }
    }
}

