/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.text;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.text.Text;
import dev.latvian.mods.kubejs.util.JsonIO;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class TextTranslate
extends Text {
    private static final Object[] NO_OBJECTS = new Object[0];
    private final String key;
    private final Object[] objects;

    public TextTranslate(String k, Object[] o) {
        this.key = k;
        this.objects = o;
        for (int i = 0; i < this.objects.length; ++i) {
            if (!(this.objects[i] instanceof Component) && (this.objects[i] instanceof Text || JsonIO.toPrimitive(JsonIO.of(this.objects[i])) != null)) continue;
            this.objects[i] = TextTranslate.of(this.objects[i]);
        }
    }

    public TextTranslate(String k) {
        this.key = k;
        this.objects = NO_OBJECTS;
    }

    public String getKey() {
        return this.key;
    }

    public Object[] getObjects() {
        return this.objects;
    }

    public TranslatableComponent rawComponent() {
        Object[] o = new Object[this.objects.length];
        for (int i = 0; i < this.objects.length; ++i) {
            Object object = this.objects[i];
            if (object instanceof Text) {
                Text text = (Text)object;
                o[i] = text.component();
                continue;
            }
            object = this.objects[i];
            if (object instanceof Component) {
                Component component = (Component)object;
                o[i] = component.m_6881_();
                continue;
            }
            o[i] = this.objects[i];
        }
        return new TranslatableComponent(this.key, o);
    }

    @Override
    public Text rawCopy() {
        Object[] o = new Object[this.objects.length];
        for (int i = 0; i < this.objects.length; ++i) {
            Object object = this.objects[i];
            if (object instanceof Text) {
                Text text = (Text)object;
                o[i] = text.copy();
                continue;
            }
            object = this.objects[i];
            if (object instanceof Component) {
                Component component = (Component)object;
                o[i] = component.m_6881_();
                continue;
            }
            o[i] = this.objects[i];
        }
        return new TextTranslate(this.key, o);
    }

    public JsonObject toJson() {
        JsonObject o = this.getStyleAndSiblingJson();
        o.addProperty("translate", this.key);
        if (this.objects.length > 0) {
            JsonArray array = new JsonArray();
            for (Object ob : this.objects) {
                array.add(JsonIO.of(ob));
            }
            o.add("with", (JsonElement)array);
        }
        return o;
    }

    @Override
    public boolean equals(Object obj) {
        TextTranslate translate;
        block7: {
            block6: {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof TextTranslate)) break block6;
                translate = (TextTranslate)obj;
                if (this.key.equals(translate.key)) break block7;
            }
            return false;
        }
        Object[] o = translate.objects;
        if (this.objects.length == o.length) {
            for (int i = 0; i < this.objects.length; ++i) {
                if (Objects.equals(this.objects[i], o[i])) continue;
                return false;
            }
            return super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (this.key.hashCode() * 31 + Objects.hash(this.objects)) * 31 + super.hashCode();
    }
}

