/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public abstract class BuilderBase {
    public final ResourceLocation id;
    public String translationKey;
    public String displayName;
    public transient Set<ResourceLocation> defaultTags;

    public BuilderBase(String s) {
        this.id = UtilsJS.getMCID(KubeJS.appendModId(s));
        this.translationKey = this.getBuilderType() + "." + this.id.m_135827_() + "." + this.id.m_135815_();
        this.displayName = Arrays.stream(this.id.m_135815_().split("_")).map(UtilsJS::toTitleCase).collect(Collectors.joining(" "));
        this.defaultTags = new HashSet<ResourceLocation>();
    }

    public abstract String getBuilderType();

    public BuilderBase translationKey(String key) {
        this.translationKey = key;
        return this;
    }

    public BuilderBase displayName(String name) {
        this.displayName = name;
        return this;
    }

    public BuilderBase tag(ResourceLocation tag) {
        this.defaultTags.add(tag);
        return this;
    }

    public ResourceLocation newID(String pre, String post) {
        if (pre.isEmpty() && post.isEmpty()) {
            return this.id;
        }
        return new ResourceLocation(this.id.m_135827_() + ":" + pre + this.id.m_135815_() + post);
    }
}

