/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors;

import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.server.ServerResources;
import net.minecraft.tags.TagCollection;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.roguelogix.biggerreactors.machine.client.CyaniteReprocessorScreen;
import net.roguelogix.biggerreactors.machine.containers.CyaniteReprocessorContainer;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.gui.container.HeatExchangerCoolantPortContainer;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.gui.container.HeatExchangerTerminalContainer;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.gui.screen.HeatExchangerCoolantPortScreen;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.gui.screen.HeatExchangerTerminalScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.client.CommonReactorTerminalScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.client.ReactorAccessPortScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.client.ReactorControlRodScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.client.ReactorCoolantPortScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.client.ReactorRedstonePortScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorAccessPortContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorControlRodContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorCoolantPortContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorRedstonePortContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorTerminalContainer;
import net.roguelogix.biggerreactors.multiblocks.turbine.client.BladeRenderer;
import net.roguelogix.biggerreactors.multiblocks.turbine.client.TurbineCoolantPortScreen;
import net.roguelogix.biggerreactors.multiblocks.turbine.client.TurbineTerminalScreen;
import net.roguelogix.biggerreactors.multiblocks.turbine.containers.TurbineCoolantPortContainer;
import net.roguelogix.biggerreactors.multiblocks.turbine.containers.TurbineTerminalContainer;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbineRotorBearingTile;
import net.roguelogix.biggerreactors.registries.FluidTransitionRegistry;
import net.roguelogix.biggerreactors.registries.ReactorModeratorRegistry;
import net.roguelogix.biggerreactors.registries.TurbineCoilRegistry;
import net.roguelogix.phosphophyllite.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="biggerreactors")
public class BiggerReactors {
    public static final String modid = "biggerreactors";
    public static final Logger LOGGER = LogManager.getLogger();
    public static ServerResources dataPackRegistries;
    public static long lastRenderTime;
    private static String version;

    public BiggerReactors() {
        new Registry();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        MinecraftForge.EVENT_BUS.addListener(this::onTagsUpdatedEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onAddReloadListenerEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStopped);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            MinecraftForge.EVENT_BUS.addListener(this::onRenderWorldLast);
        }
        version = FMLLoader.getLoadingModList().getModFileById(modid).versionString();
    }

    public void onAddReloadListenerEvent(AddReloadListenerEvent reloadListenerEvent) {
        dataPackRegistries = reloadListenerEvent.getDataPackRegistries();
    }

    public void onServerStopped(ServerStoppedEvent serverStoppedEvent) {
        dataPackRegistries = null;
    }

    public void onTagsUpdatedEvent(TagsUpdatedEvent tagsUpdatedEvent) {
        if (dataPackRegistries == null) {
            return;
        }
        ReactorModeratorRegistry.loadRegistry(tagsUpdatedEvent.getTagManager());
        TurbineCoilRegistry.loadRegistry((TagCollection<Block>)tagsUpdatedEvent.getTagManager().m_144452_(net.minecraft.core.Registry.f_122901_));
        FluidTransitionRegistry.loadRegistry((TagCollection<Fluid>)tagsUpdatedEvent.getTagManager().m_144452_(net.minecraft.core.Registry.f_122899_));
    }

    public void onClientSetup(FMLClientSetupEvent e) {
        MenuScreens.m_96206_(CyaniteReprocessorContainer.INSTANCE, CyaniteReprocessorScreen::new);
        MenuScreens.m_96206_(ReactorTerminalContainer.INSTANCE, CommonReactorTerminalScreen::new);
        MenuScreens.m_96206_(ReactorCoolantPortContainer.INSTANCE, ReactorCoolantPortScreen::new);
        MenuScreens.m_96206_(ReactorAccessPortContainer.INSTANCE, ReactorAccessPortScreen::new);
        MenuScreens.m_96206_(ReactorControlRodContainer.INSTANCE, ReactorControlRodScreen::new);
        MenuScreens.m_96206_(ReactorRedstonePortContainer.INSTANCE, ReactorRedstonePortScreen::new);
        MenuScreens.m_96206_(TurbineTerminalContainer.INSTANCE, TurbineTerminalScreen::new);
        MenuScreens.m_96206_(TurbineCoolantPortContainer.INSTANCE, TurbineCoolantPortScreen::new);
        MenuScreens.m_96206_(HeatExchangerTerminalContainer.INSTANCE, HeatExchangerTerminalScreen::new);
        MenuScreens.m_96206_(HeatExchangerCoolantPortContainer.INSTANCE, HeatExchangerCoolantPortScreen::new);
        BlockEntityRenderers.m_173590_(TurbineRotorBearingTile.TYPE, BladeRenderer::new);
    }

    public void onRenderWorldLast(RenderLevelLastEvent event) {
        lastRenderTime = System.nanoTime();
    }

    public static String modVersion() {
        return version;
    }

    static {
        lastRenderTime = 0L;
    }
}

