/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors;

import net.roguelogix.phosphophyllite.config.ConfigFormat;
import net.roguelogix.phosphophyllite.config.ConfigValue;
import net.roguelogix.phosphophyllite.registry.RegisterConfig;

public class Config {
    @RegisterConfig(format=ConfigFormat.TOML)
    public static final Config CONFIG = new Config();
    @ConfigValue(hidden=true, enableAdvanced=true)
    private final boolean EnableAdvancedConfig = false;
    @ConfigValue(advanced=true)
    public final Mode mode = Mode.MODERN;
    @ConfigValue
    public final WorldGen WorldGen = new WorldGen();
    @ConfigValue
    public final Reactor Reactor = new Reactor();
    @ConfigValue
    public final Turbine Turbine = new Turbine();
    @ConfigValue
    public final HeatExchanger HeatExchanger = new HeatExchanger();
    @ConfigValue
    public final CyaniteReprocessor CyaniteReprocessor = new CyaniteReprocessor();

    public static enum Mode {
        MODERN,
        EXPERIMENTAL,
        MULTITHREADED,
        OPENCL;

    }

    public static final class WorldGen {
        @ConfigValue(range="[1,)")
        public final int UraniumOreMaxClustersPerChunk;
        @ConfigValue(range="[1,)")
        public final int UraniumMaxOrePerCluster;
        @ConfigValue(range="[5,)")
        public final int UraniumOreMaxSpawnY;
        @ConfigValue
        public final boolean EnableUraniumGeneration;

        public WorldGen() {
            this.UraniumOreMaxClustersPerChunk = 5;
            this.UraniumMaxOrePerCluster = 10;
            this.UraniumOreMaxSpawnY = 50;
            this.EnableUraniumGeneration = true;
        }
    }

    public static final class Reactor {
        @ConfigValue(range="[3,)")
        public final int MaxLength;
        @ConfigValue(range="[3,)")
        public final int MaxWidth;
        @ConfigValue(range="[3,)")
        public final int MaxHeight;
        @ConfigValue(range="(0,)")
        public final double FuelUsageMultiplier;
        @ConfigValue(range="(0,)")
        public final double OutputMultiplier;
        @ConfigValue(range="(0,)", advanced=true)
        public final double PassiveOutputMultiplier;
        @ConfigValue(range="(0,)", advanced=true)
        public final double ActiveOutputMultiplier;
        @ConfigValue(range="(0,)", advanced=true)
        public final long FuelMBPerIngot;
        @ConfigValue(range="[1,)", advanced=true)
        public final long PerFuelRodCapacity;
        @ConfigValue(range="(0,)", advanced=true)
        public final double FuelFertilityMinimumDecay;
        @ConfigValue(range="(0,)", advanced=true)
        public final double FuelFertilityDecayDenominator;
        @ConfigValue(range="(0,)", advanced=true)
        public final double FuelFertilityDecayDenominatorInactiveMultiplier;
        @ConfigValue(range="(0,)", advanced=true)
        public final double CasingHeatTransferRFMKT;
        @ConfigValue(range="(0,)", advanced=true)
        public final double FuelToStackRFKTMultiplier;
        @ConfigValue(range="(0,)", advanced=true)
        public final double StackToCoolantRFMKT;
        @ConfigValue(range="(0,)", advanced=true)
        public final double StackToAmbientRFMKT;
        @ConfigValue(range="(0,)", advanced=true)
        public final long PassiveBatteryPerExternalBlock;
        @ConfigValue(range="(0,)", advanced=true)
        public final double PassiveCoolingTransferEfficiency;
        @ConfigValue(range="(0,)", advanced=true)
        public final long CoolantTankAmountPerFuelRod;
        @ConfigValue(range="(0,)", advanced=true)
        public final double CaseFEPerUnitVolumeKelvin;
        @ConfigValue(range="(0,)", advanced=true)
        public final double RodFEPerUnitVolumeKelvin;
        @ConfigValue(range="(0,)", advanced=true)
        public final double FuelReactivity;
        @ConfigValue(range="(0,)", advanced=true)
        public final double FissionEventsPerFuelUnit;
        @ConfigValue(range="(0,)", advanced=true)
        public final double FEPerRadiationUnit;
        @ConfigValue(range="(0,)", advanced=true)
        public final double FuelPerRadiationUnit;
        @ConfigValue(range="(0,)", advanced=true)
        public final long IrradiationDistance;
        @ConfigValue(range="(0,)", advanced=true)
        public final double FuelHardnessDivisor;
        @ConfigValue(range="[0,1]", advanced=true)
        public final double FuelAbsorptionCoefficient;
        @ConfigValue(range="(0,)", advanced=true)
        public final double FuelModerationFactor;
        @ConfigValue(range="(0,1]", advanced=true)
        public final double RadIntensityScalingMultiplier;
        @ConfigValue(range="(0,)", advanced=true)
        public final double RadIntensityScalingRateExponentMultiplier;
        @ConfigValue(range="(0,)", advanced=true)
        public final double RadIntensityScalingShiftMultiplier;
        @ConfigValue(range="(0,)", advanced=true)
        public final double RadPenaltyShiftMultiplier;
        @ConfigValue(range="(0,)", advanced=true)
        public final double RadPenaltyRateMultiplier;
        @ConfigValue(range="(0,1]", advanced=true)
        public final double FuelAbsorptionScalingMultiplier;
        @ConfigValue(range="(0,)", advanced=true)
        public final double FuelAbsorptionScalingShiftMultiplier;
        @ConfigValue(range="(0,)", advanced=true)
        public final double FuelAbsorptionScalingRateExponentMultiplier;
        @ConfigValue(range="[18,)", advanced=true)
        public final int SimulationRays;
        @ConfigValue
        public final Experimental Experimental = new Experimental();
        @ConfigValue
        public final GUI GUI = new GUI();

        public Reactor() {
            this.MaxLength = 128;
            this.MaxWidth = 128;
            this.MaxHeight = 192;
            this.FuelUsageMultiplier = 1.0;
            this.OutputMultiplier = 1.0;
            this.PassiveOutputMultiplier = 0.5;
            this.ActiveOutputMultiplier = 1.0;
            this.FuelMBPerIngot = 1000L;
            this.PerFuelRodCapacity = 4000L;
            this.FuelFertilityMinimumDecay = 0.1f;
            this.FuelFertilityDecayDenominator = 20.0;
            this.FuelFertilityDecayDenominatorInactiveMultiplier = 200.0;
            this.CasingHeatTransferRFMKT = 0.6;
            this.FuelToStackRFKTMultiplier = 1.0;
            this.StackToCoolantRFMKT = 0.6;
            this.StackToAmbientRFMKT = 0.001;
            this.PassiveBatteryPerExternalBlock = 100000L;
            this.PassiveCoolingTransferEfficiency = 0.2f;
            this.CoolantTankAmountPerFuelRod = 10000L;
            this.CaseFEPerUnitVolumeKelvin = 10.0;
            this.RodFEPerUnitVolumeKelvin = 10.0;
            this.FuelReactivity = 1.05f;
            this.FissionEventsPerFuelUnit = 0.1f;
            this.FEPerRadiationUnit = 10.0;
            this.FuelPerRadiationUnit = 7.0E-4f;
            this.IrradiationDistance = 4L;
            this.FuelHardnessDivisor = 1.0;
            this.FuelAbsorptionCoefficient = 0.5;
            this.FuelModerationFactor = 1.5;
            this.RadIntensityScalingMultiplier = 0.95f;
            this.RadIntensityScalingRateExponentMultiplier = 1.2f;
            this.RadIntensityScalingShiftMultiplier = 1.0;
            this.RadPenaltyShiftMultiplier = 15.0;
            this.RadPenaltyRateMultiplier = 2.5;
            this.FuelAbsorptionScalingMultiplier = 0.95f;
            this.FuelAbsorptionScalingShiftMultiplier = 1.0;
            this.FuelAbsorptionScalingRateExponentMultiplier = 2.2f;
            this.SimulationRays = 100;
        }

        public static final class Experimental {
            @ConfigValue(range="(0,)", advanced=true)
            public final int RodBatchSize;

            public Experimental() {
                this.RodBatchSize = 4096;
            }
        }

        public static final class GUI {
            @ConfigValue
            public final long HeatDisplayMax;

            public GUI() {
                this.HeatDisplayMax = 2000L;
            }
        }
    }

    public static final class Turbine {
        @ConfigValue(range="[5,)")
        public final int MaxLength;
        @ConfigValue(range="[5,)")
        public final int MaxWidth;
        @ConfigValue(range="[4,)")
        public final int MaxHeight;
        @ConfigValue(range="(0,)", advanced=true)
        public final long FlowRatePerBlock;
        @ConfigValue(range="(0,)", advanced=true)
        public final long TankVolumePerBlock;
        @ConfigValue(range="(0,)", advanced=true)
        public final double FluidPerBladeLinerKilometre;
        @ConfigValue(range="(0,)", advanced=true)
        public final double RotorAxialMassPerShaft;
        @ConfigValue(range="(0,)", advanced=true)
        public final double RotorAxialMassPerBlade;
        @ConfigValue(range="(0,)", advanced=true)
        public final double FrictionDragMultiplier;
        @ConfigValue(range="(0,)", advanced=true)
        public final double AerodynamicDragMultiplier;
        @ConfigValue(range="(0,)", advanced=true)
        public final double CoilDragMultiplier;
        @ConfigValue(range="(0,)", advanced=true)
        public final long BatterySizePerCoilBlock;

        public Turbine() {
            this.MaxLength = 32;
            this.MaxWidth = 32;
            this.MaxHeight = 192;
            this.FlowRatePerBlock = 5000L;
            this.TankVolumePerBlock = 10000L;
            this.FluidPerBladeLinerKilometre = 20.0;
            this.RotorAxialMassPerShaft = 100.0;
            this.RotorAxialMassPerBlade = 100.0;
            this.FrictionDragMultiplier = 1.0E-4;
            this.AerodynamicDragMultiplier = 1.0E-4;
            this.CoilDragMultiplier = 10.0;
            this.BatterySizePerCoilBlock = 300000L;
        }
    }

    public static final class HeatExchanger {
        @ConfigValue(range="[3,)")
        public final int MaxLength;
        @ConfigValue(range="[3,)")
        public final int MaxWidth;
        @ConfigValue(range="[4,)")
        public final int MaxHeight;
        @ConfigValue(range="(0,)", advanced=true)
        public final long ChannelTankVolumePerBlock;
        @ConfigValue(range="(0,)", advanced=true)
        public final double ChannelToChannelHeatConductivityMultiplier;
        @ConfigValue(range="(0,)", advanced=true)
        public final double ChannelFEPerKelvinUnitVolume;
        @ConfigValue(range="(0,)", advanced=true)
        public final double ChannelFEPerKelvinMetreSquared;
        @ConfigValue(range="(0,)", advanced=true)
        public final double ChannelInternalSurfaceArea;
        @ConfigValue(range="(0,)", advanced=true)
        public final double AirFEPerKelvinUnitVolume;
        @ConfigValue(range="(0,)", advanced=true)
        public final double AirFEPerKelvinMetreSquared;
        @ConfigValue(range="(0,)", advanced=true)
        public final double AmbientFEPerKelvinMetreSquared;
        @ConfigValue
        public final Reactor.GUI gui = new Reactor.GUI();

        public HeatExchanger() {
            this.MaxLength = 64;
            this.MaxWidth = 64;
            this.MaxHeight = 96;
            this.ChannelTankVolumePerBlock = 10000L;
            this.ChannelToChannelHeatConductivityMultiplier = 0.5;
            this.ChannelFEPerKelvinUnitVolume = 1000.0;
            this.ChannelFEPerKelvinMetreSquared = 50.0;
            this.ChannelInternalSurfaceArea = 80.0;
            this.AirFEPerKelvinUnitVolume = 10.0;
            this.AirFEPerKelvinMetreSquared = 0.5;
            this.AmbientFEPerKelvinMetreSquared = 0.2f;
        }

        public static final class GUI {
            @ConfigValue
            public final long HeatDisplayMax;

            public GUI() {
                this.HeatDisplayMax = 2000L;
            }
        }
    }

    public static final class CyaniteReprocessor {
        @ConfigValue(range="(0,)", comment="Max transfer rate of fluids and energy.")
        public final int TransferRate;
        @ConfigValue(range="(0,)", comment="Max energy capacity.")
        public final int EnergyTankCapacity;
        @ConfigValue(range="(0,)", comment="Max water capacity")
        public final int WaterTankCapacity;
        @ConfigValue(range="(0,)", comment="Power usage per tick of work.")
        public final int EnergyConsumptionPerTick;
        @ConfigValue(range="(0,)", comment="Water usage per tick of work.")
        public final int WaterConsumptionPerTick;
        @ConfigValue(range="(0,)", comment="Time (in ticks) it takes to complete a job.")
        public final int TotalWorkTime;

        public CyaniteReprocessor() {
            this.TransferRate = 500;
            this.EnergyTankCapacity = 5000;
            this.WaterTankCapacity = 5000;
            this.EnergyConsumptionPerTick = 1;
            this.WaterConsumptionPerTick = 1;
            this.TotalWorkTime = 200;
        }
    }
}

