/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.roguelogix.phosphophyllite.client.gui.RenderHelper;
import net.roguelogix.phosphophyllite.client.gui.elements.RenderedElement;

@OnlyIn(value=Dist.CLIENT)
public class CommonRender {
    public static final ResourceLocation COMMON_RESOURCE_TEXTURE = new ResourceLocation("biggerreactors", "textures/screen/common.png");

    public static <T extends AbstractContainerMenu> void renderEnergyGauge(@Nonnull PoseStack poseStack, @Nonnull RenderedElement<T> symbol, long energyStored, long energyCapacity) {
        ResourceLocation preservedResource = RenderHelper.getCurrentResource();
        RenderHelper.bindTexture((ResourceLocation)COMMON_RESOURCE_TEXTURE);
        if (energyCapacity > 0L) {
            int renderSize = (int)((long)symbol.height * energyStored / energyCapacity);
            symbol.blit(poseStack, 54, 0);
            symbol.blit(poseStack, symbol.width, symbol.height - renderSize, 36, 0);
        }
        symbol.blit(poseStack, 0, 0);
        symbol.tooltip = new TextComponent(String.format("%s/%s", RenderHelper.formatValue((double)energyStored, (String)"RF"), RenderHelper.formatValue((double)energyCapacity, (String)"RF")));
        RenderHelper.clearRenderColor();
        RenderHelper.bindTexture((ResourceLocation)preservedResource);
    }

    public static <T extends AbstractContainerMenu> void renderFluidGauge(@Nonnull PoseStack poseStack, @Nonnull RenderedElement<T> symbol, long fluidStored, long fluidCapacity, Fluid fluid) {
        ResourceLocation preservedResource = RenderHelper.getCurrentResource();
        RenderHelper.bindTexture((ResourceLocation)COMMON_RESOURCE_TEXTURE);
        if (fluidCapacity > 0L) {
            int renderSize = (int)((long)symbol.height * fluidStored / fluidCapacity);
            RenderHelper.drawFluidGrid((PoseStack)poseStack, (int)(symbol.x + 1), (int)symbol.y, (int)symbol.getBlitOffset(), (int)16, (int)16, (Fluid)fluid, (int)1, (int)4);
            symbol.blit(poseStack, symbol.width, symbol.height - renderSize, 18, 0);
        }
        symbol.blit(poseStack, 0, 0);
        symbol.blit(poseStack, 72, 0);
        symbol.tooltip = new TextComponent(String.format("%s/%s of %s", RenderHelper.formatValue((double)((double)fluidStored / 1000.0), (String)"B", (boolean)true), RenderHelper.formatValue((double)((double)fluidCapacity / 1000.0), (String)"B", (boolean)true), new FluidStack(fluid, 1).getDisplayName().getString().toLowerCase(Locale.US)));
        RenderHelper.clearRenderColor();
        RenderHelper.bindTexture((ResourceLocation)preservedResource);
    }
}

