/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import javax.annotation.Nonnull;
import net.minecraft.SharedConstants;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.roguelogix.biggerreactors.BiggerReactors;
import net.roguelogix.biggerreactors.client.CommonRender;
import net.roguelogix.phosphophyllite.client.gui.RenderHelper;
import net.roguelogix.phosphophyllite.client.gui.elements.InteractiveElement;
import net.roguelogix.phosphophyllite.client.gui.screens.PhosphophylliteScreen;

@OnlyIn(value=Dist.CLIENT)
public class TextBox<T extends AbstractContainerMenu>
extends InteractiveElement<T> {
    private boolean focusEnable;
    private int cursorPos;
    private int selectionPos;
    private int cursorAnimationTime;
    private final int cursorAnimationTimeTotal;
    private final int charLimit;
    private final StringBuffer textBuffer;
    private final Font fontRenderer;

    public TextBox(@Nonnull PhosphophylliteScreen<T> parent, @Nonnull Font fontRenderer, int x, int y, int width, int charLimit, String initialText) {
        super(parent, x, y, width, 16, 0, 158, null);
        this.textBuffer = new StringBuffer(initialText);
        this.fontRenderer = fontRenderer;
        this.selectionPos = this.cursorPos = this.textBuffer.length();
        this.charLimit = charLimit;
        this.cursorAnimationTime = 30;
        this.cursorAnimationTimeTotal = 60;
    }

    public String getContents() {
        if (this.textBuffer.length() > 0) {
            return this.textBuffer.toString();
        }
        return "";
    }

    public void render(@Nonnull PoseStack poseStack, int mouseX, int mouseY) {
        if (this.renderEnable) {
            ResourceLocation preservedResource = RenderHelper.getCurrentResource();
            RenderHelper.bindTexture((ResourceLocation)CommonRender.COMMON_RESOURCE_TEXTURE);
            this.blit(poseStack, this.x, this.y, 0, 158, 3, 16);
            for (int i = 0; i <= this.width; i += 6) {
                this.blit(poseStack, this.x + 3 + i, this.y, 6, 158, 6, 16);
            }
            this.blit(poseStack, this.x + 6 + 6 * this.charLimit, this.y, 3, 158, 3, 16);
            this.fontRenderer.m_92750_(poseStack, this.textBuffer.toString(), (float)(this.x + 3), (float)(this.y + 4), 0xFFFFFF);
            this.renderCursor();
            this.renderSelection();
            RenderHelper.clearRenderColor();
            RenderHelper.bindTexture((ResourceLocation)preservedResource);
            if (this.onRender != null) {
                this.onRender.trigger(poseStack, mouseX, mouseY);
            }
        }
    }

    private void renderCursor() {
        ++this.cursorAnimationTime;
        if (this.cursorAnimationTime > this.cursorAnimationTimeTotal) {
            this.cursorAnimationTime = 0;
        }
        if (!this.focusEnable || !this.renderEnable || this.cursorAnimationTime < this.cursorAnimationTimeTotal / 2) {
            return;
        }
        int cursorRenderPos = this.x + 2;
        if (this.textBuffer.length() >= this.cursorPos) {
            cursorRenderPos = this.fontRenderer.m_92895_(this.textBuffer.substring(0, this.cursorPos)) + (this.x + 2);
        }
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder renderBuffer = tessellator.m_85915_();
        RenderHelper.setRenderColor((float)255.0f, (float)255.0f, (float)255.0f, (float)255.0f);
        RenderSystem.m_69472_();
        renderBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        renderBuffer.m_5483_((double)(cursorRenderPos + 1), (double)(this.y + 3), 0.0).m_5752_();
        renderBuffer.m_5483_((double)cursorRenderPos, (double)(this.y + 3), 0.0).m_5752_();
        renderBuffer.m_5483_((double)cursorRenderPos, (double)(this.y + 13), 0.0).m_5752_();
        renderBuffer.m_5483_((double)(cursorRenderPos + 1), (double)(this.y + 13), 0.0).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69493_();
        RenderHelper.clearRenderColor();
    }

    private void renderSelection() {
        if (!this.renderEnable || this.cursorPos == this.selectionPos) {
            return;
        }
        int cursorRenderPos = this.x + 2;
        if (this.textBuffer.length() >= this.cursorPos) {
            cursorRenderPos = this.fontRenderer.m_92895_(this.textBuffer.substring(0, this.cursorPos)) + (this.x + 2);
        }
        int selectionRenderPos = this.x + 2;
        if (this.textBuffer.length() >= this.selectionPos) {
            selectionRenderPos = this.fontRenderer.m_92895_(this.textBuffer.substring(0, this.selectionPos)) + (this.x + 2);
        }
        int leftRenderPos = this.selectionPos > this.cursorPos ? cursorRenderPos : selectionRenderPos;
        int rightRenderPos = this.selectionPos > this.cursorPos ? selectionRenderPos : cursorRenderPos;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder renderBuffer = tessellator.m_85915_();
        RenderHelper.setRenderColor((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        RenderSystem.m_69472_();
        RenderSystem.m_69479_();
        RenderSystem.m_69835_((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        renderBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        renderBuffer.m_5483_((double)rightRenderPos, (double)(this.y + 2), 0.0).m_5752_();
        renderBuffer.m_5483_((double)leftRenderPos, (double)(this.y + 2), 0.0).m_5752_();
        renderBuffer.m_5483_((double)leftRenderPos, (double)(this.y + 14), 0.0).m_5752_();
        renderBuffer.m_5483_((double)rightRenderPos, (double)(this.y + 14), 0.0).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69462_();
        RenderSystem.m_69493_();
        RenderHelper.clearRenderColor();
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        int relativeX = this.parent.getGuiLeft() + this.x;
        int relativeY = this.parent.getGuiTop() + this.y;
        return mouseX > (double)relativeX && mouseX < (double)(relativeX + (this.width + 6)) && mouseY > (double)relativeY && mouseY < (double)(relativeY + this.height);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.cursorPos = this.selectionPos;
        this.focusEnable = this.m_5953_(mouseX, mouseY) && this.actionEnable;
        return this.focusEnable;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.actionEnable && this.focusEnable) {
            if (Screen.m_96634_((int)keyCode)) {
                this.cursorPos = this.textBuffer.length();
                this.selectionPos = 0;
                return true;
            }
            if (Screen.m_96632_((int)keyCode)) {
                this.parent.getMinecraft().f_91068_.m_90911_(this.getSelection());
                return true;
            }
            if (Screen.m_96628_((int)keyCode)) {
                this.parent.getMinecraft().f_91068_.m_90911_(this.getSelection());
                this.deleteSelection();
                return true;
            }
            if (Screen.m_96630_((int)keyCode)) {
                this.write(this.parent.getMinecraft().f_91068_.m_90876_());
                return true;
            }
            switch (keyCode) {
                case 256: {
                    return false;
                }
                case 259: {
                    this.deleteCharacter();
                    if (!Screen.m_96637_()) break;
                    this.deleteWord();
                    break;
                }
                case 263: {
                    this.shiftCursorLeft();
                    break;
                }
                case 262: {
                    this.shiftCursorRight();
                    break;
                }
                case 268: {
                    this.cursorPos = 0;
                    break;
                }
                case 269: {
                    this.cursorPos = this.textBuffer.length();
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.actionEnable && this.focusEnable) {
            this.write(Character.toString(codePoint));
            return true;
        }
        return false;
    }

    public void shiftCursorLeft() {
        if (this.cursorPos > 0) {
            if (Screen.m_96638_() && Screen.m_96637_()) {
                this.cursorPos = this.findBreakCharacter(this.cursorPos, true);
            } else if (Screen.m_96637_()) {
                this.selectionPos = this.cursorPos = this.findBreakCharacter(this.cursorPos, true);
            } else if (Screen.m_96638_()) {
                --this.cursorPos;
            } else {
                --this.cursorPos;
                this.selectionPos = this.cursorPos;
            }
        }
    }

    public void shiftCursorRight() {
        if (this.cursorPos < this.textBuffer.length()) {
            if (Screen.m_96638_() && Screen.m_96637_()) {
                this.cursorPos = this.findBreakCharacter(this.cursorPos, false);
            } else if (Screen.m_96637_()) {
                this.selectionPos = this.cursorPos = this.findBreakCharacter(this.cursorPos, false);
            } else if (Screen.m_96638_()) {
                ++this.cursorPos;
            } else {
                ++this.cursorPos;
                this.selectionPos = this.cursorPos;
            }
        }
    }

    public int findBreakCharacter(int start, boolean reverse) {
        if (start < 0) {
            return 0;
        }
        if (start > this.textBuffer.length()) {
            return this.textBuffer.length();
        }
        if (reverse) {
            for (int i = start - 1; i >= 0; --i) {
                if (i == 0) {
                    return 0;
                }
                if (!this.isBreakCharacter(this.textBuffer.codePointAt(i))) continue;
                return i;
            }
            return this.textBuffer.length();
        }
        for (int i = start + 1; i <= this.textBuffer.length(); ++i) {
            if (i == this.textBuffer.length()) {
                return this.textBuffer.length();
            }
            if (!this.isBreakCharacter(this.textBuffer.codePointAt(i))) continue;
            return i;
        }
        return 0;
    }

    public boolean isBreakCharacter(int codePoint) {
        switch (codePoint) {
            case 32: 
            case 44: 
            case 46: 
            case 47: 
            case 59: 
            case 92: {
                return true;
            }
        }
        return false;
    }

    public String getSelection() {
        try {
            if (this.selectionPos > this.cursorPos) {
                return this.textBuffer.substring(this.cursorPos, this.selectionPos);
            }
            return this.textBuffer.substring(this.selectionPos, this.cursorPos);
        }
        catch (StringIndexOutOfBoundsException err) {
            BiggerReactors.LOGGER.error("Failed to write text: ", (Throwable)err);
            return "";
        }
    }

    public void deleteSelection() {
        try {
            int charsDeleted = 0;
            if (this.selectionPos > this.cursorPos) {
                this.textBuffer.delete(this.cursorPos, this.selectionPos);
                charsDeleted = this.selectionPos - this.cursorPos;
            } else {
                this.textBuffer.delete(this.selectionPos, this.cursorPos);
                charsDeleted = this.cursorPos - this.selectionPos;
            }
            this.cursorPos -= charsDeleted;
            this.selectionPos = this.cursorPos;
        }
        catch (StringIndexOutOfBoundsException err) {
            BiggerReactors.LOGGER.error("Failed to write text: ", (Throwable)err);
        }
    }

    public void deleteWord() {
        try {
            for (int i = this.cursorPos; i > 0; --i) {
                if (this.textBuffer.codePointAt(i - 1) == 32) {
                    return;
                }
                this.textBuffer.deleteCharAt(i - 1);
                this.selectionPos = --this.cursorPos;
            }
        }
        catch (StringIndexOutOfBoundsException err) {
            BiggerReactors.LOGGER.error("Failed to delete word: ", (Throwable)err);
        }
    }

    public void deleteCharacter() {
        try {
            if (this.cursorPos > 0) {
                this.textBuffer.deleteCharAt(this.cursorPos - 1);
                --this.cursorPos;
                this.selectionPos = this.cursorPos;
            }
        }
        catch (StringIndexOutOfBoundsException err) {
            BiggerReactors.LOGGER.error("Failed to write text: ", (Throwable)err);
        }
    }

    public void clear() {
        this.cursorPos = 0;
        this.selectionPos = 0;
        if (this.textBuffer.length() > 0) {
            this.textBuffer.delete(0, this.textBuffer.length());
        }
    }

    public String set(String text) {
        String buffer = this.textBuffer.toString();
        this.clear();
        this.write(text);
        return buffer;
    }

    public void write(String text) {
        try {
            if (this.textBuffer.length() >= this.charLimit) {
                this.playSound(SoundEvents.f_12507_);
                return;
            }
            String filteredText = SharedConstants.m_136190_((String)text);
            if (this.cursorPos >= this.textBuffer.length() || this.cursorPos < 0) {
                this.textBuffer.append(filteredText);
            } else {
                this.textBuffer.insert(this.cursorPos, filteredText);
            }
            this.cursorPos += text.length();
            this.selectionPos = this.cursorPos;
        }
        catch (StringIndexOutOfBoundsException err) {
            BiggerReactors.LOGGER.error("Failed to write text: ", (Throwable)err);
        }
    }
}

