/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.heatexchanger;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.blocks.HeatExchangerBaseBlock;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.blocks.HeatExchangerCasingBlock;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.tiles.HeatExchangerBaseTile;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.tiles.HeatExchangerCondenserChannelTile;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.tiles.HeatExchangerCoolantPortTile;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.tiles.HeatExchangerEvaporatorChannelTile;
import net.roguelogix.biggerreactors.util.FluidTransitionTank;
import net.roguelogix.phosphophyllite.Phosphophyllite;
import net.roguelogix.phosphophyllite.modular.block.IConnectedTexture;
import net.roguelogix.phosphophyllite.multiblock.MultiblockTileModule;
import net.roguelogix.phosphophyllite.multiblock.ValidationError;
import net.roguelogix.phosphophyllite.multiblock.Validator;
import net.roguelogix.phosphophyllite.multiblock.rectangular.RectangularMultiblockController;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3i;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3ic;
import net.roguelogix.phosphophyllite.util.HeatBody;
import net.roguelogix.phosphophyllite.util.Util;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class HeatExchangerMultiblockController
extends RectangularMultiblockController<HeatExchangerBaseTile, HeatExchangerMultiblockController> {
    public final Set<HeatExchangerCondenserChannelTile> condenserChannels = new LinkedHashSet<HeatExchangerCondenserChannelTile>();
    public final Set<HeatExchangerEvaporatorChannelTile> evaporatorChannels = new LinkedHashSet<HeatExchangerEvaporatorChannelTile>();
    private final Set<HeatExchangerCoolantPortTile> coolantPorts = new LinkedHashSet<HeatExchangerCoolantPortTile>();
    public final ReadWriteLock locks = new ReentrantReadWriteLock();
    public final FluidTransitionTank evaporatorTank = new FluidTransitionTank(false);
    public final FluidTransitionTank condenserTank = new FluidTransitionTank(true);
    public final HeatBody ambientHeatBody = new HeatBody();
    public final HeatBody airHeatBody = new HeatBody();
    public final HeatBody condenserHeatBody = new HeatBody();
    public final HeatBody evaporatorHeatBody = new HeatBody();
    public double channelRFKT;
    public double evaporatorAirRFKT;
    public double condenserAirRFKT;
    public double airAmbientRFKT;

    public HeatExchangerMultiblockController(Level world) {
        super(world, tile -> tile instanceof HeatExchangerBaseTile, block -> block instanceof HeatExchangerBaseBlock);
        this.minSize.set(4, 3, 3);
        this.maxSize.set(Config.CONFIG.HeatExchanger.MaxLength, Config.CONFIG.HeatExchanger.MaxHeight, Config.CONFIG.HeatExchanger.MaxWidth);
        this.setAssemblyValidator(HeatExchangerMultiblockController::validate);
        this.frameValidator = block -> block instanceof HeatExchangerCasingBlock;
        this.exteriorValidator = Validator.or((Validator)this.frameValidator, block -> false);
        this.interiorValidator = block -> block instanceof AirBlock;
    }

    private boolean validate() {
        BlockPos channelPos;
        if (this.condenserChannels.isEmpty() || this.evaporatorChannels.isEmpty()) {
            throw new ValidationError((Component)new TranslatableComponent("multiblock.error.biggerreactors.heat_exchanger.missing_channel_type"));
        }
        if (this.coolantPorts.size() != 4) {
            throw new ValidationError((Component)new TranslatableComponent("multiblock.error.biggerreactors.heat_exchanger.invalid_port_count"));
        }
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int condenserPorts = 0;
        int evaporatorPorts = 0;
        for (HeatExchangerCoolantPortTile coolantPort : this.coolantPorts) {
            BlockPos portPos = coolantPort.m_58899_();
            boolean channelFound = false;
            for (Direction value : Direction.values()) {
                mutableBlockPos.m_122190_((Vec3i)portPos);
                mutableBlockPos.m_122173_(value);
                BlockEntity tile = this.blocks.getTile((BlockPos)mutableBlockPos);
                if (tile instanceof HeatExchangerEvaporatorChannelTile) {
                    ++evaporatorPorts;
                    channelFound = true;
                    break;
                }
                if (!(tile instanceof HeatExchangerCondenserChannelTile)) continue;
                ++condenserPorts;
                channelFound = true;
                break;
            }
            if (channelFound) continue;
            throw new ValidationError((Component)new TranslatableComponent("multiblock.error.biggerreactors.heat_exchanger.coolant_port_unconnected", new Object[]{portPos.m_123341_(), portPos.m_123342_(), portPos.m_123343_()}));
        }
        if (condenserPorts != 2 || evaporatorPorts != 2) {
            throw new ValidationError((Component)new TranslatableComponent("multiblock.error.biggerreactors.heat_exchanger.duplicate_port_types"));
        }
        this.verifyFluidChannels(this.condenserChannels);
        this.verifyFluidChannels(this.evaporatorChannels);
        long tick = Phosphophyllite.tickNumber();
        block2: for (HeatExchangerCoolantPortTile coolantPort : this.coolantPorts) {
            if (coolantPort.lastCheckedTick == tick) continue;
            Direction nextDirection = null;
            for (Direction value : Direction.values()) {
                mutableBlockPos.m_122190_((Vec3i)coolantPort.m_58899_());
                mutableBlockPos.m_122173_(value);
                HeatExchangerBaseTile tile = (HeatExchangerBaseTile)this.blocks.getTile((BlockPos)mutableBlockPos);
                if (!(tile instanceof HeatExchangerCondenserChannelTile) && !(tile instanceof HeatExchangerEvaporatorChannelTile)) continue;
                nextDirection = value;
                break;
            }
            mutableBlockPos.m_122190_((Vec3i)coolantPort.m_58899_());
            if (nextDirection == null) {
                throw new ValidationError("Unknown channel verification error, this shouldn't be possible " + mutableBlockPos);
            }
            MultiblockTileModule currentModule = coolantPort.multiblockModule();
            while (true) {
                mutableBlockPos.m_122173_(nextDirection);
                currentModule = currentModule.getNeighbor(nextDirection);
                if (currentModule == null) {
                    throw new ValidationError("Unknown channel verification error, this shouldn't be possible " + mutableBlockPos);
                }
                HeatExchangerBaseTile channelTile = (HeatExchangerBaseTile)currentModule.iface;
                if (channelTile instanceof HeatExchangerCoolantPortTile) continue block2;
                if (!(channelTile instanceof HeatExchangerCondenserChannelTile) && !(channelTile instanceof HeatExchangerEvaporatorChannelTile)) {
                    throw new ValidationError("Unknown channel verification error, this shouldn't be possible " + mutableBlockPos);
                }
                if (channelTile instanceof HeatExchangerCondenserChannelTile) {
                    ((HeatExchangerCondenserChannelTile)channelTile).lastCheckedTick = tick;
                }
                if (channelTile instanceof HeatExchangerEvaporatorChannelTile) {
                    ((HeatExchangerEvaporatorChannelTile)channelTile).lastCheckedTick = tick;
                }
                BlockState channelState = channelTile.m_58900_();
                if (nextDirection != Direction.DOWN && ((Boolean)channelState.m_61143_((Property)IConnectedTexture.Module.TOP_CONNECTED_PROPERTY)).booleanValue()) {
                    nextDirection = Direction.UP;
                    continue;
                }
                if (nextDirection != Direction.UP && ((Boolean)channelState.m_61143_((Property)IConnectedTexture.Module.BOTTOM_CONNECTED_PROPERTY)).booleanValue()) {
                    nextDirection = Direction.DOWN;
                    continue;
                }
                if (nextDirection != Direction.SOUTH && ((Boolean)channelState.m_61143_((Property)IConnectedTexture.Module.NORTH_CONNECTED_PROPERTY)).booleanValue()) {
                    nextDirection = Direction.NORTH;
                    continue;
                }
                if (nextDirection != Direction.NORTH && ((Boolean)channelState.m_61143_((Property)IConnectedTexture.Module.SOUTH_CONNECTED_PROPERTY)).booleanValue()) {
                    nextDirection = Direction.SOUTH;
                    continue;
                }
                if (nextDirection != Direction.WEST && ((Boolean)channelState.m_61143_((Property)IConnectedTexture.Module.EAST_CONNECTED_PROPERTY)).booleanValue()) {
                    nextDirection = Direction.EAST;
                    continue;
                }
                if (nextDirection == Direction.EAST || !((Boolean)channelState.m_61143_((Property)IConnectedTexture.Module.WEST_CONNECTED_PROPERTY)).booleanValue()) break;
                nextDirection = Direction.WEST;
            }
            throw new ValidationError("Unknown channel verification error, this shouldn't be possible " + mutableBlockPos);
        }
        for (HeatExchangerCondenserChannelTile condenserChannel : this.condenserChannels) {
            if (condenserChannel.lastCheckedTick == tick) continue;
            channelPos = condenserChannel.m_58899_();
            throw new ValidationError((Component)new TranslatableComponent("multiblock.error.biggerreactors.heat_exchanger.dangling_channel", new Object[]{channelPos.m_123341_(), channelPos.m_123342_(), channelPos.m_123343_()}));
        }
        for (HeatExchangerEvaporatorChannelTile evaporatorChannel : this.evaporatorChannels) {
            if (evaporatorChannel.lastCheckedTick == tick) continue;
            channelPos = evaporatorChannel.m_58899_();
            throw new ValidationError((Component)new TranslatableComponent("multiblock.error.biggerreactors.heat_exchanger.dangling_channel", new Object[]{channelPos.m_123341_(), channelPos.m_123342_(), channelPos.m_123343_()}));
        }
        Util.chunkCachedBlockStateIteration((Vector3ic)this.minCoord(), (Vector3ic)this.maxCoord(), (Level)this.world, (block, pos) -> {
            if (block.m_60734_() instanceof HeatExchangerBaseBlock) {
                mutableBlockPos.m_122178_(pos.x, pos.y, pos.z);
                if (!this.blocks.containsPos((BlockPos)mutableBlockPos)) {
                    throw new ValidationError((Component)new TranslatableComponent("multiblock.error.biggerreactors.heat_exchanger.dangling_internal_part", new Object[]{pos.x, pos.y, pos.z}));
                }
            }
        });
        return true;
    }

    private void verifyFluidChannels(Set<? extends HeatExchangerBaseTile> channels) {
        channels.forEach(tile -> {
            BlockState state = tile.m_58900_();
            int connectedSides = 0;
            connectedSides += (Boolean)state.m_61143_((Property)IConnectedTexture.Module.TOP_CONNECTED_PROPERTY) != false ? 1 : 0;
            connectedSides += (Boolean)state.m_61143_((Property)IConnectedTexture.Module.BOTTOM_CONNECTED_PROPERTY) != false ? 1 : 0;
            connectedSides += (Boolean)state.m_61143_((Property)IConnectedTexture.Module.NORTH_CONNECTED_PROPERTY) != false ? 1 : 0;
            connectedSides += (Boolean)state.m_61143_((Property)IConnectedTexture.Module.SOUTH_CONNECTED_PROPERTY) != false ? 1 : 0;
            connectedSides += (Boolean)state.m_61143_((Property)IConnectedTexture.Module.EAST_CONNECTED_PROPERTY) != false ? 1 : 0;
            if ((connectedSides += (Boolean)state.m_61143_((Property)IConnectedTexture.Module.WEST_CONNECTED_PROPERTY) != false ? 1 : 0) != 2) {
                throw new ValidationError("all fluid channels must have exactly two connections " + tile.m_58899_());
            }
        });
    }

    protected void onPartPlaced(HeatExchangerBaseTile placed) {
        this.onPartAttached(placed);
    }

    protected void onPartAttached(HeatExchangerBaseTile toAttach) {
        if (toAttach instanceof HeatExchangerCondenserChannelTile) {
            this.condenserChannels.add((HeatExchangerCondenserChannelTile)toAttach);
        }
        if (toAttach instanceof HeatExchangerEvaporatorChannelTile) {
            this.evaporatorChannels.add((HeatExchangerEvaporatorChannelTile)toAttach);
        }
        if (toAttach instanceof HeatExchangerCoolantPortTile) {
            this.coolantPorts.add((HeatExchangerCoolantPortTile)toAttach);
        }
    }

    protected void onPartBroken(HeatExchangerBaseTile broken) {
        this.onPartDetached(broken);
    }

    protected void onPartDetached(HeatExchangerBaseTile toDetach) {
        if (toDetach instanceof HeatExchangerCondenserChannelTile) {
            this.condenserChannels.remove((Object)toDetach);
        }
        if (toDetach instanceof HeatExchangerEvaporatorChannelTile) {
            this.evaporatorChannels.remove((Object)toDetach);
        }
        if (toDetach instanceof HeatExchangerCoolantPortTile) {
            this.coolantPorts.remove((Object)toDetach);
        }
    }

    protected void onAssembled() {
        this.onUnpaused();
        double ambientTemperature = this.world.m_6042_().m_63951_() ? 423.15 : 293.15;
        this.ambientHeatBody.setTemperature(ambientTemperature);
        this.airHeatBody.setTemperature(ambientTemperature);
        this.condenserHeatBody.setTemperature(ambientTemperature);
        this.evaporatorHeatBody.setTemperature(ambientTemperature);
    }

    protected void onUnpaused() {
        HeatExchangerBaseTile tile;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        this.condenserHeatBody.setRfPerKelvin((double)this.condenserChannels.size() * Config.CONFIG.HeatExchanger.ChannelFEPerKelvinUnitVolume);
        this.evaporatorHeatBody.setRfPerKelvin((double)this.evaporatorChannels.size() * Config.CONFIG.HeatExchanger.ChannelFEPerKelvinUnitVolume);
        this.condenserTank.perSideCapacity = (long)this.condenserChannels.size() * Config.CONFIG.HeatExchanger.ChannelTankVolumePerBlock;
        this.evaporatorTank.perSideCapacity = (long)this.evaporatorChannels.size() * Config.CONFIG.HeatExchanger.ChannelTankVolumePerBlock;
        Vector3i vec = new Vector3i(this.maxCoord()).sub(this.minCoord()).add(1, 1, 1);
        int airVolume = vec.x * vec.y * vec.z;
        airVolume -= this.condenserChannels.size();
        this.airHeatBody.setRfPerKelvin((double)(airVolume -= this.evaporatorChannels.size()) * Config.CONFIG.HeatExchanger.AirFEPerKelvinUnitVolume);
        int channelContactArea = 0;
        int evaporatorAirContactArea = 0;
        int condenserAirContactArea = 0;
        int airAmbientContactArea = 0;
        for (HeatExchangerCondenserChannelTile heatExchangerCondenserChannelTile : this.condenserChannels) {
            for (Direction value : Direction.values()) {
                mutableBlockPos.m_122190_((Vec3i)heatExchangerCondenserChannelTile.m_58899_());
                mutableBlockPos.m_122173_(value);
                tile = (HeatExchangerBaseTile)this.blocks.getTile((BlockPos)mutableBlockPos);
                if (tile instanceof HeatExchangerEvaporatorChannelTile) {
                    ++channelContactArea;
                    continue;
                }
                if (tile instanceof HeatExchangerCondenserChannelTile) continue;
                ++condenserAirContactArea;
            }
        }
        for (HeatExchangerEvaporatorChannelTile heatExchangerEvaporatorChannelTile : this.evaporatorChannels) {
            for (Direction value : Direction.values()) {
                mutableBlockPos.m_122190_((Vec3i)heatExchangerEvaporatorChannelTile.m_58899_());
                mutableBlockPos.m_122173_(value);
                tile = (HeatExchangerBaseTile)this.blocks.getTile((BlockPos)mutableBlockPos);
                if (tile instanceof HeatExchangerCondenserChannelTile || tile instanceof HeatExchangerEvaporatorChannelTile) continue;
                ++evaporatorAirContactArea;
            }
        }
        airAmbientContactArea = vec.x * vec.y + vec.x * vec.z + vec.y * vec.z;
        this.channelRFKT = (double)channelContactArea * Config.CONFIG.HeatExchanger.ChannelFEPerKelvinMetreSquared;
        this.condenserAirRFKT = (double)condenserAirContactArea * Config.CONFIG.HeatExchanger.AirFEPerKelvinMetreSquared;
        this.evaporatorAirRFKT = (double)evaporatorAirContactArea * Config.CONFIG.HeatExchanger.AirFEPerKelvinMetreSquared;
        this.airAmbientRFKT = (double)(airAmbientContactArea *= 2) * Config.CONFIG.HeatExchanger.AmbientFEPerKelvinMetreSquared;
        block4: for (HeatExchangerCoolantPortTile heatExchangerCoolantPortTile : this.coolantPorts) {
            BlockPos portPos = heatExchangerCoolantPortTile.m_58899_();
            for (Direction value : Direction.values()) {
                mutableBlockPos.m_122190_((Vec3i)portPos);
                mutableBlockPos.m_122173_(value);
                BlockEntity tile2 = this.blocks.getTile((BlockPos)mutableBlockPos);
                if (tile2 instanceof HeatExchangerEvaporatorChannelTile) {
                    heatExchangerCoolantPortTile.setHETank(this.evaporatorTank);
                    heatExchangerCoolantPortTile.setCondenser(false);
                    continue block4;
                }
                if (!(tile2 instanceof HeatExchangerCondenserChannelTile)) continue;
                heatExchangerCoolantPortTile.setHETank(this.condenserTank);
                heatExchangerCoolantPortTile.setCondenser(true);
                continue block4;
            }
        }
        for (HeatExchangerCoolantPortTile heatExchangerCoolantPortTile : this.coolantPorts) {
            for (HeatExchangerCoolantPortTile port : this.coolantPorts) {
                if (port.isCondenser() != heatExchangerCoolantPortTile.isCondenser() || port == heatExchangerCoolantPortTile) continue;
                port.setInlet(!heatExchangerCoolantPortTile.isInlet());
            }
        }
        this.ambientHeatBody.setInfinite(true);
    }

    public void tick() {
        this.condenserTank.transferWith(this.condenserHeatBody, (double)this.condenserChannels.size() * Config.CONFIG.HeatExchanger.ChannelInternalSurfaceArea);
        this.condenserHeatBody.transferWith(this.airHeatBody, this.condenserAirRFKT);
        this.condenserHeatBody.transferWith(this.evaporatorHeatBody, this.channelRFKT);
        this.evaporatorHeatBody.transferWith(this.airHeatBody, this.evaporatorAirRFKT);
        this.evaporatorTank.transferWith(this.evaporatorHeatBody, (double)this.evaporatorChannels.size() * Config.CONFIG.HeatExchanger.ChannelInternalSurfaceArea);
        this.airHeatBody.transferWith(this.ambientHeatBody, this.airAmbientRFKT);
        this.coolantPorts.forEach(HeatExchangerCoolantPortTile::pushFluid);
        if (Phosphophyllite.tickNumber() % 2L == 0L) {
            this.markDirty();
        }
    }

    protected void read(CompoundTag nbt) {
        super.read(nbt);
        this.condenserTank.deserializeNBT(nbt.m_128469_("condenserTank"));
        this.evaporatorTank.deserializeNBT(nbt.m_128469_("evaporatorTank"));
        this.ambientHeatBody.setTemperature(nbt.m_128459_("ambientHeatBody"));
        this.airHeatBody.setTemperature(nbt.m_128459_("airHeatBody"));
        this.condenserHeatBody.setTemperature(nbt.m_128459_("condenserHeatBody"));
        this.evaporatorHeatBody.setTemperature(nbt.m_128459_("evaporatorHeatBody"));
        this.channelRFKT = nbt.m_128459_("channelRFKT");
        this.evaporatorAirRFKT = nbt.m_128459_("evaporatorAirRFKT");
        this.condenserAirRFKT = nbt.m_128459_("condenserAirRFKT");
        this.airAmbientRFKT = nbt.m_128459_("airAmbientRFKT");
    }

    @Nonnull
    protected CompoundTag write() {
        CompoundTag nbt = super.write();
        nbt.m_128365_("condenserTank", (Tag)this.condenserTank.serializeNBT());
        nbt.m_128365_("evaporatorTank", (Tag)this.evaporatorTank.serializeNBT());
        nbt.m_128347_("ambientHeatBody", this.ambientHeatBody.temperature());
        nbt.m_128347_("airHeatBody", this.airHeatBody.temperature());
        nbt.m_128347_("condenserHeatBody", this.condenserHeatBody.temperature());
        nbt.m_128347_("evaporatorHeatBody", this.evaporatorHeatBody.temperature());
        nbt.m_128347_("channelRFKT", this.channelRFKT);
        nbt.m_128347_("evaporatorAirRFKT", this.evaporatorAirRFKT);
        nbt.m_128347_("condenserAirRFKT", this.condenserAirRFKT);
        nbt.m_128347_("airAmbientRFKT", this.airAmbientRFKT);
        return nbt;
    }

    public void setInletPort(HeatExchangerCoolantPortTile port, boolean inlet) {
        port.setInlet(inlet);
        for (HeatExchangerCoolantPortTile coolantPort : this.coolantPorts) {
            if (coolantPort == port || coolantPort.isCondenser() != port.isCondenser()) continue;
            coolantPort.setInlet(!inlet);
        }
    }
}

