/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.heatexchanger.tiles;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.HeatExchangerMultiblockController;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.blocks.HeatExchangerCoolantPortBlock;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.gui.container.HeatExchangerCoolantPortContainer;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.state.HeatExchangerCoolantPortState;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.tiles.HeatExchangerBaseTile;
import net.roguelogix.phosphophyllite.client.gui.api.IHasUpdatableState;
import net.roguelogix.phosphophyllite.fluids.FluidHandlerWrapper;
import net.roguelogix.phosphophyllite.fluids.IPhosphophylliteFluidHandler;
import net.roguelogix.phosphophyllite.multiblock.IOnAssemblyTile;
import net.roguelogix.phosphophyllite.multiblock.IOnDisassemblyTile;
import net.roguelogix.phosphophyllite.registry.RegisterTileEntity;
import net.roguelogix.phosphophyllite.util.BlockStates;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@RegisterTileEntity(name="heat_exchanger_coolant_port")
public class HeatExchangerCoolantPortTile
extends HeatExchangerBaseTile
implements IPhosphophylliteFluidHandler,
IOnAssemblyTile,
IOnDisassemblyTile,
MenuProvider,
IHasUpdatableState<HeatExchangerCoolantPortState> {
    public long lastCheckedTick;
    @RegisterTileEntity.Type
    public static BlockEntityType<?> TYPE;
    @RegisterTileEntity.Supplier
    public static final BlockEntityType.BlockEntitySupplier<HeatExchangerCoolantPortTile> SUPPLIER;
    private IPhosphophylliteFluidHandler HETank;
    private boolean inlet = true;
    private boolean condenser = true;
    private boolean connected = false;
    Direction outputDirection = null;
    LazyOptional<?> handlerOptional = LazyOptional.empty();
    IPhosphophylliteFluidHandler handler = null;
    FluidTank EMPTY_TANK = new FluidTank(0);
    private final HeatExchangerCoolantPortState state = new HeatExchangerCoolantPortState(this);

    public HeatExchangerCoolantPortTile(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    public <T> LazyOptional<T> capability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidHandlerCapability().cast();
        }
        return super.capability(cap, side);
    }

    public void setHETank(IPhosphophylliteFluidHandler HETank) {
        this.HETank = HETank;
    }

    public void setInlet(boolean inlet) {
        assert (this.f_58857_ != null);
        this.inlet = inlet;
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStates.PORT_DIRECTION, (Comparable)Boolean.valueOf(inlet)), 3);
        this.m_6596_();
    }

    public void setInletOtherOutlet(boolean inlet) {
        ((HeatExchangerMultiblockController)this.controller()).setInletPort(this, inlet);
    }

    public boolean isInlet() {
        return this.inlet;
    }

    public void setCondenser(boolean condenser) {
        this.condenser = condenser;
        assert (this.f_58857_ != null);
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)HeatExchangerCoolantPortBlock.CONDENSER, (Comparable)Boolean.valueOf(condenser)), 3);
    }

    public boolean isCondenser() {
        return this.condenser;
    }

    public int tankCount() {
        if (this.HETank == null) {
            return 0;
        }
        return this.HETank.tankCount();
    }

    public long tankCapacity(int tank) {
        if (this.HETank == null) {
            return 0L;
        }
        return this.HETank.tankCapacity(tank);
    }

    public Fluid fluidTypeInTank(int tank) {
        if (this.HETank == null) {
            return Fluids.f_76191_;
        }
        return this.HETank.fluidTypeInTank(tank);
    }

    @Nullable
    public CompoundTag fluidTagInTank(int tank) {
        if (this.HETank == null) {
            return null;
        }
        return this.HETank.fluidTagInTank(tank);
    }

    public long fluidAmountInTank(int tank) {
        if (this.HETank == null) {
            return 0L;
        }
        return this.HETank.fluidAmountInTank(tank);
    }

    public boolean fluidValidForTank(int tank, Fluid fluid) {
        if (this.HETank == null) {
            return false;
        }
        return this.HETank.fluidValidForTank(tank, fluid);
    }

    public long fill(Fluid fluid, @Nullable CompoundTag tag, long amount, boolean simulate) {
        if (this.HETank == null || !this.inlet) {
            return 0L;
        }
        return this.HETank.fill(fluid, null, amount, simulate);
    }

    public long drain(Fluid fluid, @Nullable CompoundTag tag, long amount, boolean simulate) {
        if (this.HETank == null || this.inlet) {
            return 0L;
        }
        return this.HETank.drain(fluid, null, amount, simulate);
    }

    public long pushFluid() {
        if (!this.connected || this.inlet) {
            return 0L;
        }
        if (this.handlerOptional.isPresent()) {
            Fluid fluid = this.HETank.fluidTypeInTank(1);
            long amount = this.HETank.fluidAmountInTank(1);
            amount = this.HETank.drain(fluid, null, amount, true);
            amount = this.handler.fill(fluid, null, amount, false);
            amount = this.HETank.drain(fluid, null, amount, false);
            return amount;
        }
        this.handlerOptional = LazyOptional.empty();
        this.handler = null;
        this.connected = false;
        return 0L;
    }

    public void neighborChanged() {
        this.handlerOptional = LazyOptional.empty();
        this.handler = null;
        if (this.outputDirection == null) {
            this.connected = false;
            return;
        }
        assert (this.f_58857_ != null);
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(this.outputDirection));
        if (te == null) {
            this.connected = false;
            return;
        }
        this.connected = false;
        LazyOptional waterOutput = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.outputDirection.m_122424_());
        if (waterOutput.isPresent()) {
            this.connected = true;
            this.handlerOptional = waterOutput;
            this.handler = FluidHandlerWrapper.wrap((IFluidHandler)((IFluidHandler)waterOutput.orElse((Object)this.EMPTY_TANK)));
        }
    }

    protected void readNBT(CompoundTag compound) {
        super.readNBT(compound);
        this.inlet = compound.m_128471_("inlet");
    }

    protected CompoundTag writeNBT() {
        CompoundTag nbt = super.writeNBT();
        nbt.m_128379_("inlet", this.inlet);
        return nbt;
    }

    public void onAssembly() {
        this.outputDirection = (Direction)this.m_58900_().m_61143_((Property)BlockStates.FACING);
        this.neighborChanged();
    }

    public void onDisassembly() {
        this.outputDirection = null;
        this.HETank = null;
        this.neighborChanged();
    }

    public HeatExchangerCoolantPortState getState() {
        return this.state;
    }

    public void updateState() {
        this.state.direction = this.isInlet();
        this.state.condenser = this.isCondenser();
    }

    public Component m_5446_() {
        return new TranslatableComponent(HeatExchangerCoolantPortBlock.INSTANCE.m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new HeatExchangerCoolantPortContainer(windowId, this.f_58858_, player);
    }

    public void runRequest(String requestName, Object requestData) {
        if (requestName.equals("setDirection")) {
            int direction = (Integer)requestData;
            this.setInletOtherOutlet(direction == 0);
        }
    }

    static {
        SUPPLIER = HeatExchangerCoolantPortTile::new;
    }
}

