/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.roguelogix.biggerreactors.client.CommonButton;
import net.roguelogix.biggerreactors.client.TextBox;
import net.roguelogix.biggerreactors.fluids.LiquidUranium;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorControlRodContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorControlRodState;
import net.roguelogix.phosphophyllite.client.gui.RenderHelper;
import net.roguelogix.phosphophyllite.client.gui.elements.AbstractElement;
import net.roguelogix.phosphophyllite.client.gui.elements.InteractiveElement;
import net.roguelogix.phosphophyllite.client.gui.elements.RenderedElement;
import net.roguelogix.phosphophyllite.client.gui.screens.PhosphophylliteScreen;

@OnlyIn(value=Dist.CLIENT)
public class ReactorControlRodScreen
extends PhosphophylliteScreen<ReactorControlRodContainer> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("biggerreactors", "textures/screen/reactor_control_rod.png");
    private ReactorControlRodState reactorControlRodState = (ReactorControlRodState)((ReactorControlRodContainer)this.m_6262_()).getGuiPacket();

    public ReactorControlRodScreen(ReactorControlRodContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title, DEFAULT_TEXTURE, 136, 126);
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_97728_ = this.getWidth() / 2 - this.f_96547_.m_92852_((FormattedText)this.m_96636_()) / 2;
        this.initControls();
        this.initGauges();
    }

    public void initControls() {
        TextBox<ReactorControlRodContainer> textBox = new TextBox<ReactorControlRodContainer>(this, this.f_96547_, 6, 26, 96, 16, this.reactorControlRodState.name);
        this.addScreenElement((AbstractElement)textBox);
        InteractiveElement textBoxEnterButton = new InteractiveElement((PhosphophylliteScreen)this, 114, 27, 17, 14, 194, 0, (Component)new TranslatableComponent("screen.biggerreactors.reactor_control_rod.apply.tooltip"));
        textBoxEnterButton.onMouseReleased = (mX, mY, btn) -> {
            if (textBoxEnterButton.m_5953_(mX, mY)) {
                ((ReactorControlRodContainer)this.m_6262_()).executeRequest("setName", textBox.getContents());
                textBoxEnterButton.playSound(SoundEvents.f_12490_);
                return true;
            }
            return false;
        };
        textBoxEnterButton.onRender = (mS, mX, mY) -> {
            if (textBoxEnterButton.m_5953_((double)mX, (double)mY)) {
                textBoxEnterButton.blit(mS, 211, 0);
            } else {
                textBoxEnterButton.blit(mS, 194, 0);
            }
        };
        CommonButton<ReactorControlRodContainer> textEnterButton = new CommonButton<ReactorControlRodContainer>(this, 114, 27, 17, 14, 61, 130, (Component)new TranslatableComponent("screen.biggerreactors.reactor_redstone_port.apply.tooltip"));
        textEnterButton.onMouseReleased = (mX, mY, btn) -> {
            ((ReactorControlRodContainer)this.m_6262_()).executeRequest("setName", textBox.getContents());
            return true;
        };
        this.addScreenElement((AbstractElement)textEnterButton);
        InteractiveElement rodRetractButton = new InteractiveElement((PhosphophylliteScreen)this, 58, 82, 14, 15, 226, 0, (Component)new TranslatableComponent("screen.biggerreactors.reactor_control_rod.retract_rod.tooltip"));
        rodRetractButton.onMouseReleased = (mX, mY, btn) -> {
            if (rodRetractButton.m_5953_(mX, mY)) {
                double delta = Screen.m_96638_() && Screen.m_96637_() ? -100.0 : (Screen.m_96637_() ? -50.0 : (Screen.m_96638_() ? -10.0 : -1.0));
                ((ReactorControlRodContainer)this.m_6262_()).executeRequest("changeInsertionLevel", new Pair((Object)delta, (Object)Screen.m_96639_()));
                rodRetractButton.playSound(SoundEvents.f_12490_);
                return true;
            }
            return false;
        };
        rodRetractButton.onRender = (mS, mX, mY) -> {
            if (rodRetractButton.m_5953_((double)mX, (double)mY)) {
                rodRetractButton.blit(mS, 242, 0);
            } else {
                rodRetractButton.blit(mS, 228, 0);
            }
        };
        this.addScreenElement((AbstractElement)rodRetractButton);
        InteractiveElement rodInsertButton = new InteractiveElement((PhosphophylliteScreen)this, 58, 64, 14, 15, 226, 0, (Component)new TranslatableComponent("screen.biggerreactors.reactor_control_rod.insert_rod.tooltip"));
        rodInsertButton.onMouseReleased = (mX, mY, btn) -> {
            if (rodInsertButton.m_5953_(mX, mY)) {
                double delta = Screen.m_96638_() && Screen.m_96637_() ? 100.0 : (Screen.m_96637_() ? 50.0 : (Screen.m_96638_() ? 10.0 : 1.0));
                ((ReactorControlRodContainer)this.m_6262_()).executeRequest("changeInsertionLevel", new Pair((Object)delta, (Object)Screen.m_96639_()));
                rodInsertButton.playSound(SoundEvents.f_12490_);
                return true;
            }
            return false;
        };
        rodInsertButton.onRender = (mS, mX, mY) -> {
            if (rodInsertButton.m_5953_((double)mX, (double)mY)) {
                rodInsertButton.blit(mS, 242, 15);
            } else {
                rodInsertButton.blit(mS, 228, 15);
            }
        };
        this.addScreenElement((AbstractElement)rodInsertButton);
    }

    public void initGauges() {
        RenderedElement rodInsertionGauge = new RenderedElement((PhosphophylliteScreen)this, 36, 50, 18, 64, 0, 126, TextComponent.f_131282_);
        rodInsertionGauge.onRender = (mS, mX, mY) -> ReactorControlRodScreen.renderInsertionLevel(mS, (RenderedElement<ReactorControlRodContainer>)rodInsertionGauge, this.reactorControlRodState.insertionLevel);
        this.addScreenElement((AbstractElement)rodInsertionGauge);
    }

    public void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.f_96547_.m_92883_(poseStack, new TranslatableComponent("screen.biggerreactors.reactor_control_rod.name").getString(), (float)(this.getGuiLeft() + 8), (float)(this.getGuiTop() + 17), 0x404040);
        this.f_96547_.m_92883_(poseStack, String.format("%.1f%%", this.reactorControlRodState.insertionLevel), (float)(this.getGuiLeft() + 76), (float)(this.getGuiTop() + 77), 0x404040);
    }

    public static void renderInsertionLevel(@Nonnull PoseStack poseStack, @Nonnull RenderedElement<ReactorControlRodContainer> symbol, double insertionLevel) {
        RenderHelper.drawFluidGrid((PoseStack)poseStack, (int)(symbol.x + 1), (int)symbol.y, (int)symbol.getBlitOffset(), (int)16, (int)16, (Fluid)LiquidUranium.INSTANCE.m_5613_(), (int)1, (int)4);
        if (insertionLevel > 0.0) {
            int renderSize = (int)((double)symbol.height * insertionLevel / 100.0);
            symbol.blit(poseStack, symbol.width, renderSize, symbol.u + 18, symbol.v);
        }
        symbol.blit(poseStack);
        symbol.tooltip = new TextComponent(String.format("%.1f%%", insertionLevel));
    }
}

