/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.simulation;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorSimulation;
import net.roguelogix.phosphophyllite.serialization.IPhosphophylliteSerializable;
import net.roguelogix.phosphophyllite.serialization.PhosphophylliteCompound;
import net.roguelogix.phosphophyllite.util.HeatBody;
import net.roguelogix.phosphophyllite.util.MethodsReturnNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
class Battery
extends HeatBody
implements IReactorSimulation.IBattery,
IPhosphophylliteSerializable {
    private final long capacity;
    private long stored;
    private long generatedLastTick;

    Battery(long capacity) {
        this.setInfinite(true);
        this.capacity = capacity;
    }

    public double transferWith(HeatBody other, double rfkt) {
        double newTemp = other.temperature() - this.temperature();
        newTemp *= Math.exp(-rfkt / other.rfPerKelvin());
        double rfTransferred = ((newTemp += this.temperature()) - other.temperature()) * other.rfPerKelvin();
        this.generatedLastTick = (long)(-rfTransferred * Config.CONFIG.Reactor.OutputMultiplier * Config.CONFIG.Reactor.PassiveOutputMultiplier);
        this.stored += this.generatedLastTick;
        if (this.stored > this.capacity) {
            this.stored = this.capacity;
        }
        other.setTemperature(newTemp);
        return rfTransferred;
    }

    @Override
    public long extract(long toExtract) {
        this.stored -= toExtract;
        return toExtract;
    }

    @Override
    public long stored() {
        return this.stored;
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public long generatedLastTick() {
        return this.generatedLastTick;
    }

    @Nullable
    public PhosphophylliteCompound save() {
        PhosphophylliteCompound compound = new PhosphophylliteCompound();
        compound.put("storedPower", this.stored);
        return compound;
    }

    public void load(@Nonnull PhosphophylliteCompound compound) {
        this.stored = compound.getLong("storedPower");
    }
}

