/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.simulation;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorSimulation;
import net.roguelogix.biggerreactors.registries.FluidTransitionRegistry;
import net.roguelogix.biggerreactors.registries.ReactorModeratorRegistry;
import net.roguelogix.phosphophyllite.serialization.IPhosphophylliteSerializable;
import net.roguelogix.phosphophyllite.serialization.PhosphophylliteCompound;
import net.roguelogix.phosphophyllite.util.HeatBody;
import net.roguelogix.phosphophyllite.util.MethodsReturnNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
class CoolantTank
extends HeatBody
implements IReactorSimulation.ICoolantTank,
ReactorModeratorRegistry.IModeratorProperties,
IPhosphophylliteSerializable {
    private final long perSideCapacity;
    private long liquidAmount = 0L;
    private long vaporAmount = 0L;
    private final ReactorModeratorRegistry.IModeratorProperties defaultModeratorProperties;
    @Nullable
    private ReactorModeratorRegistry.IModeratorProperties moderatorProperties = null;
    @Nullable
    private FluidTransitionRegistry.ITransitionProperties transitionProperties = null;
    private long maxTransitionedLastTick;
    private long transitionedLastTick;
    private long rfTransferredLastTick;

    CoolantTank(long perSideCapacity, ReactorModeratorRegistry.IModeratorProperties defaultModeratorProperties) {
        this.perSideCapacity = perSideCapacity;
        this.defaultModeratorProperties = defaultModeratorProperties;
        this.setInfinite(true);
    }

    public double transferWith(HeatBody body, double rfkt) {
        if (this.transitionProperties == null) {
            this.maxTransitionedLastTick = 0L;
            this.transitionedLastTick = 0L;
            this.rfTransferredLastTick = 0L;
            return 0.0;
        }
        rfkt *= this.transitionProperties.liquidRFMKT();
        double multiplier = (double)this.liquidAmount / (double)this.perSideCapacity;
        double newTemp = body.temperature() - this.transitionProperties.boilingPoint();
        newTemp *= Math.exp(-(rfkt *= Math.max(multiplier, 0.01)) / body.rfPerKelvin());
        double toTransfer = (newTemp += this.transitionProperties.boilingPoint()) - body.temperature();
        toTransfer *= body.rfPerKelvin();
        toTransfer = this.absorbRF(toTransfer);
        body.absorbRF(toTransfer);
        return -toTransfer;
    }

    public double absorbRF(double rf) {
        if (rf > 0.0 || this.transitionProperties == null) {
            this.maxTransitionedLastTick = 0L;
            this.transitionedLastTick = 0L;
            this.rfTransferredLastTick = 0L;
            return 0.0;
        }
        rf = Math.abs(rf);
        long toTransition = (long)(rf / this.transitionProperties.latentHeat());
        long maxTransitionable = Math.min(this.liquidAmount, this.perSideCapacity - this.vaporAmount);
        this.maxTransitionedLastTick = toTransition;
        this.transitionedLastTick = toTransition = Math.min(maxTransitionable, toTransition);
        this.liquidAmount -= toTransition;
        this.vaporAmount += toTransition;
        rf = (double)toTransition * this.transitionProperties.latentHeat();
        this.rfTransferredLastTick = (long)rf;
        return rf *= -1.0;
    }

    @Override
    public void dumpLiquid() {
        this.liquidAmount = 0L;
    }

    @Override
    public void dumpVapor() {
        this.vaporAmount = 0L;
    }

    @Override
    public long insertLiquid(long amount) {
        this.liquidAmount += amount;
        return amount;
    }

    @Override
    public long extractLiquid(long amount) {
        this.liquidAmount -= amount;
        return amount;
    }

    @Override
    public long insertVapor(long amount) {
        this.vaporAmount += amount;
        return amount;
    }

    @Override
    public long extractVapor(long amount) {
        this.vaporAmount -= amount;
        return amount;
    }

    @Override
    public long liquidAmount() {
        return this.liquidAmount;
    }

    @Override
    public long vaporAmount() {
        return this.vaporAmount;
    }

    @Override
    public long perSideCapacity() {
        return this.perSideCapacity;
    }

    @Override
    public void setModeratorProperties(ReactorModeratorRegistry.IModeratorProperties moderatorProperties) {
        this.moderatorProperties = moderatorProperties;
    }

    @Override
    public void setTransitionProperties(FluidTransitionRegistry.ITransitionProperties transitionProperties) {
        this.transitionProperties = transitionProperties;
    }

    @Override
    public long transitionedLastTick() {
        return this.transitionedLastTick;
    }

    @Override
    public long maxTransitionedLastTick() {
        return this.maxTransitionedLastTick;
    }

    @Override
    public long rfTransferredLastTick() {
        return this.rfTransferredLastTick;
    }

    @Override
    public double absorption() {
        if (this.perSideCapacity == 0L || this.moderatorProperties == null) {
            return this.defaultModeratorProperties.absorption();
        }
        double absorption = 0.0;
        absorption += this.defaultModeratorProperties.absorption() * (double)(this.perSideCapacity - this.liquidAmount);
        absorption += this.moderatorProperties.absorption() * (double)this.liquidAmount;
        return absorption /= (double)this.perSideCapacity;
    }

    @Override
    public double heatEfficiency() {
        if (this.perSideCapacity == 0L || this.moderatorProperties == null) {
            return this.defaultModeratorProperties.heatEfficiency();
        }
        double heatEfficiency = 0.0;
        heatEfficiency += this.defaultModeratorProperties.heatEfficiency() * (double)(this.perSideCapacity - this.liquidAmount);
        heatEfficiency += this.moderatorProperties.heatEfficiency() * (double)this.liquidAmount;
        return heatEfficiency /= (double)this.perSideCapacity;
    }

    @Override
    public double moderation() {
        if (this.perSideCapacity == 0L || this.moderatorProperties == null) {
            return this.defaultModeratorProperties.moderation();
        }
        double moderation = 0.0;
        moderation += this.defaultModeratorProperties.moderation() * (double)(this.perSideCapacity - this.liquidAmount);
        moderation += this.moderatorProperties.moderation() * (double)this.liquidAmount;
        return moderation /= (double)this.perSideCapacity;
    }

    @Override
    public double heatConductivity() {
        if (this.perSideCapacity == 0L || this.moderatorProperties == null) {
            return this.defaultModeratorProperties.heatConductivity();
        }
        double heatConductivity = 0.0;
        heatConductivity += this.defaultModeratorProperties.heatConductivity() * (double)(this.perSideCapacity - this.liquidAmount);
        heatConductivity += this.moderatorProperties.heatConductivity() * (double)this.liquidAmount;
        return heatConductivity /= (double)this.perSideCapacity;
    }

    @Nullable
    public PhosphophylliteCompound save() {
        PhosphophylliteCompound compound = new PhosphophylliteCompound();
        compound.put("liquidAmount", this.liquidAmount);
        compound.put("gasAmount", this.vaporAmount);
        return compound;
    }

    public void load(@Nonnull PhosphophylliteCompound compound) {
        this.liquidAmount = compound.getLong("liquidAmount");
        this.vaporAmount = compound.getLong("gasAmount");
    }
}

