/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.simulation;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.Battery;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.CoolantTank;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.FuelTank;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorSimulation;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.SimUtil;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.SimulationDescription;
import net.roguelogix.biggerreactors.registries.ReactorModeratorRegistry;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector2ic;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3ic;
import net.roguelogix.phosphophyllite.serialization.PhosphophylliteCompound;
import net.roguelogix.phosphophyllite.util.HeatBody;
import net.roguelogix.phosphophyllite.util.MethodsReturnNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ExperimentalReactorSimulation
implements IReactorSimulation {
    private final int x;
    private final int y;
    private final int z;
    private final ReactorModeratorRegistry.IModeratorProperties defaultModeratorProperties;
    private final ReactorModeratorRegistry.IModeratorProperties[][][] moderatorProperties;
    private final SimUtil.ControlRod[][] controlRodsXZ;
    private final SimUtil.ControlRod[] controlRods;
    private final double fuelToCasingRFKT;
    private final double fuelToManifoldSurfaceArea;
    private final double stackToCoolantSystemRFKT;
    private final double casingToAmbientRFKT;
    private final HeatBody fuelHeat = new HeatBody();
    private final HeatBody stackHeat = new HeatBody();
    private final HeatBody ambientHeat = new HeatBody();
    @Nullable
    private final Battery battery;
    @Nullable
    private final CoolantTank coolantTank;
    private final HeatBody output;
    private final FuelTank fuelTank = new FuelTank();
    private double fuelFertility = 1.0;

    /*
     * WARNING - void declaration
     */
    public ExperimentalReactorSimulation(SimulationDescription simulationDescription) {
        if (simulationDescription.controlRodLocations == null) {
            throw new IllegalArgumentException();
        }
        if (simulationDescription.moderatorProperties == null) {
            throw new IllegalArgumentException();
        }
        if (simulationDescription.manifoldLocations == null) {
            throw new IllegalArgumentException();
        }
        this.x = simulationDescription.x;
        this.y = simulationDescription.y;
        this.z = simulationDescription.z;
        this.defaultModeratorProperties = simulationDescription.defaultModeratorProperties;
        this.moderatorProperties = new ReactorModeratorRegistry.IModeratorProperties[this.x][this.y][this.z];
        this.controlRodsXZ = new SimUtil.ControlRod[this.x][this.z];
        this.controlRods = new SimUtil.ControlRod[simulationDescription.controlRodCount];
        int currentControlRodIndex = 0;
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.z; ++j) {
                SimUtil.ControlRod controlRod;
                if (!simulationDescription.controlRodLocations[i][j]) continue;
                this.controlRodsXZ[i][j] = controlRod = new SimUtil.ControlRod(i, j);
                this.controlRods[currentControlRodIndex++] = controlRod;
            }
        }
        if (simulationDescription.passivelyCooled) {
            this.battery = new Battery(((long)(this.x + 2) * (long)(this.y + 2) * (long)(this.z + 2) - (long)this.x * (long)this.y * (long)this.z) * Config.CONFIG.Reactor.PassiveBatteryPerExternalBlock);
            this.output = this.battery;
            this.coolantTank = null;
        } else {
            long perSideCapacity = (long)(this.controlRods.length * this.y) * Config.CONFIG.Reactor.CoolantTankAmountPerFuelRod;
            this.coolantTank = new CoolantTank(perSideCapacity += (long)simulationDescription.manifoldCount * Config.CONFIG.Reactor.CoolantTankAmountPerFuelRod, simulationDescription.defaultModeratorProperties);
            this.output = this.coolantTank;
            this.battery = null;
        }
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.y; ++j) {
                for (int k = 0; k < this.z; ++k) {
                    void var5_15;
                    void var5_11;
                    ReactorModeratorRegistry.IModeratorProperties iModeratorProperties = simulationDescription.moderatorProperties[i][j][k];
                    if (simulationDescription.manifoldLocations[i][j][k]) {
                        CoolantTank coolantTank = this.coolantTank;
                    }
                    if (var5_11 == null) {
                        ReactorModeratorRegistry.IModeratorProperties iModeratorProperties2 = simulationDescription.defaultModeratorProperties;
                    }
                    if (this.controlRodsXZ[i][k] != null) {
                        Object var5_14 = null;
                    }
                    this.moderatorProperties[i][j][k] = var5_15;
                }
            }
        }
        this.fuelTank.setCapacity(Config.CONFIG.Reactor.PerFuelRodCapacity * (long)this.controlRods.length * (long)this.y);
        double fuelToCasingRFKT = 0.0;
        int fuelToManifoldSurfaceArea = 0;
        for (SimUtil.ControlRod controlRod : this.controlRods) {
            for (int i = 0; i < this.y; ++i) {
                for (Vector2ic direction : SimUtil.cardinalDirections) {
                    if (controlRod.x + direction.x() < 0 || controlRod.x + direction.x() >= this.x || controlRod.z + direction.y() < 0 || controlRod.z + direction.y() >= this.z) {
                        fuelToCasingRFKT += Config.CONFIG.Reactor.CasingHeatTransferRFMKT;
                        continue;
                    }
                    ReactorModeratorRegistry.IModeratorProperties properties = this.moderatorProperties[controlRod.x + direction.x()][i][controlRod.z + direction.y()];
                    if (properties == null) continue;
                    if (properties instanceof CoolantTank) {
                        ++fuelToManifoldSurfaceArea;
                        continue;
                    }
                    fuelToCasingRFKT += properties.heatConductivity();
                }
            }
        }
        fuelToCasingRFKT *= Config.CONFIG.Reactor.FuelToStackRFKTMultiplier;
        double d = 2 * (this.x * this.y + this.x * this.z + this.z * this.y);
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.y; ++j) {
                for (int k = 0; k < this.z; ++k) {
                    ReactorModeratorRegistry.IModeratorProperties properties = this.moderatorProperties[i][j][k];
                    if (!(properties instanceof CoolantTank)) continue;
                    for (Vector3ic axisDirection : SimUtil.axisDirections) {
                        int neighborX = i + axisDirection.x();
                        int neighborY = j + axisDirection.y();
                        int neighborZ = k + axisDirection.z();
                        if (neighborX < 0 || neighborX >= this.x || neighborY < 0 || neighborY >= this.y || neighborZ < 0 || neighborZ >= this.z) {
                            d -= 1.0;
                            continue;
                        }
                        ReactorModeratorRegistry.IModeratorProperties neighborProperties = this.moderatorProperties[neighborX][neighborY][neighborZ];
                        if (neighborProperties instanceof IReactorSimulation.ICoolantTank) continue;
                        d += 1.0;
                    }
                }
            }
        }
        d *= Config.CONFIG.Reactor.StackToCoolantRFMKT;
        if (simulationDescription.passivelyCooled) {
            d *= Config.CONFIG.Reactor.PassiveCoolingTransferEfficiency;
        }
        this.casingToAmbientRFKT = (double)(2 * ((this.x + 2) * (this.y + 2) + (this.x + 2) * (this.z + 2) + (this.z + 2) * (this.y + 2))) * Config.CONFIG.Reactor.StackToAmbientRFMKT;
        this.fuelToCasingRFKT = fuelToCasingRFKT;
        this.fuelToManifoldSurfaceArea = fuelToManifoldSurfaceArea;
        this.stackToCoolantSystemRFKT = d;
        this.fuelHeat.setRfPerKelvin((double)(this.controlRods.length * this.y) * Config.CONFIG.Reactor.RodFEPerUnitVolumeKelvin);
        this.stackHeat.setRfPerKelvin((double)(this.x * this.y * this.z) * Config.CONFIG.Reactor.RodFEPerUnitVolumeKelvin);
        this.ambientHeat.setInfinite(true);
        this.ambientHeat.setTemperature(simulationDescription.ambientTemperature);
        this.stackHeat.setTemperature(simulationDescription.ambientTemperature);
        this.fuelHeat.setTemperature(simulationDescription.ambientTemperature);
        if (this.battery != null) {
            this.battery.setTemperature(simulationDescription.ambientTemperature);
        }
    }

    @Override
    public void tick(boolean active) {
        if (active) {
            this.radiate();
        } else {
            this.fuelTank.burn(0.0);
        }
        double denominator = Config.CONFIG.Reactor.FuelFertilityDecayDenominator;
        if (!active) {
            denominator *= Config.CONFIG.Reactor.FuelFertilityDecayDenominatorInactiveMultiplier;
        }
        this.fuelFertility = Math.max(0.0, this.fuelFertility - Math.max(Config.CONFIG.Reactor.FuelFertilityMinimumDecay, this.fuelFertility / denominator));
        this.fuelHeat.transferWith(this.stackHeat, this.fuelToCasingRFKT + this.fuelToManifoldSurfaceArea * (this.coolantTank == null ? this.defaultModeratorProperties : this.coolantTank).heatConductivity());
        this.output.transferWith(this.stackHeat, this.stackToCoolantSystemRFKT);
        this.stackHeat.transferWith(this.ambientHeat, this.casingToAmbientRFKT);
    }

    private void radiate() {
        if (this.fuelTank.fuel() <= 0L) {
            return;
        }
        double radiationPenaltyBase = Math.exp(-Config.CONFIG.Reactor.RadPenaltyShiftMultiplier * Math.exp(-0.001 * Config.CONFIG.Reactor.RadPenaltyRateMultiplier * (this.fuelHeat.temperature() - 273.15)));
        long baseFuelAmount = this.fuelTank.fuel() + this.fuelTank.waste() / 100L;
        double rawRadIntensity = (double)baseFuelAmount * Config.CONFIG.Reactor.FissionEventsPerFuelUnit;
        double scaledRadIntensity = Math.pow(Math.pow(rawRadIntensity, Config.CONFIG.Reactor.FuelReactivity) / (double)this.controlRods.length, Config.CONFIG.Reactor.FuelReactivity) * (double)this.controlRods.length;
        double initialHardness = Math.min(1.0, (double)0.2f + 0.8 * radiationPenaltyBase);
        double rawIntensity = 1.0 + -Config.CONFIG.Reactor.RadIntensityScalingMultiplier * Math.exp(-10.0 * Config.CONFIG.Reactor.RadIntensityScalingShiftMultiplier * Math.exp((double)-0.001f * Config.CONFIG.Reactor.RadIntensityScalingRateExponentMultiplier * (this.fuelHeat.temperature() - 273.15)));
        double fuelAbsorptionTemperatureCoefficient = 1.0 - Config.CONFIG.Reactor.FuelAbsorptionScalingMultiplier * Math.exp(-10.0 * Config.CONFIG.Reactor.FuelAbsorptionScalingShiftMultiplier * Math.exp(-0.001 * Config.CONFIG.Reactor.FuelAbsorptionScalingRateExponentMultiplier * (this.fuelHeat.temperature() - 273.15)));
        double fuelHardnessMultiplier = 1.0 / Config.CONFIG.Reactor.FuelHardnessDivisor;
        double rawFuelUsage = 0.0;
        double fuelRFAdded = 0.0;
        double fuelRadAdded = 0.0;
        double caseRFAdded = 0.0;
        double FuelPerRadiationUnit = Config.CONFIG.Reactor.FuelPerRadiationUnit;
        double FEPerRadiationUnit = Config.CONFIG.Reactor.FEPerRadiationUnit;
        double FuelUsageMultiplier = Config.CONFIG.Reactor.FuelUsageMultiplier;
        double FuelAbsorptionCoefficient = Config.CONFIG.Reactor.FuelAbsorptionCoefficient;
        double FuelModerationFactor = Config.CONFIG.Reactor.FuelModerationFactor;
        for (int r = 0; r < this.controlRods.length; ++r) {
            SimUtil.ControlRod rod = this.controlRods[r];
            double controlRodModifier = (100.0 - rod.insertion) / 100.0;
            double effectiveRadIntensity = scaledRadIntensity * controlRodModifier;
            double effectiveRawRadIntensity = rawRadIntensity * controlRodModifier;
            double initialIntensity = effectiveRadIntensity * rawIntensity;
            rawFuelUsage += FuelPerRadiationUnit * effectiveRawRadIntensity / this.fertility() * FuelUsageMultiplier;
            fuelRFAdded += FEPerRadiationUnit * initialIntensity;
            double rayMultiplier = 1.0 / (double)(SimUtil.rays.size() * this.y);
            for (int i = 0; i < this.y; ++i) {
                block2: for (int j = 0; j < SimUtil.rays.size(); ++j) {
                    ArrayList<SimUtil.RayStep> raySteps = SimUtil.rays.get(j);
                    double neutronHardness = initialHardness;
                    double neutronIntensity = initialIntensity * rayMultiplier;
                    for (int k = 0; k < raySteps.size(); ++k) {
                        SimUtil.RayStep rayStep = raySteps.get(k);
                        int currentX = rod.x + rayStep.offset.x;
                        int currentY = i + rayStep.offset.y;
                        int currentZ = rod.z + rayStep.offset.z;
                        if (currentX < 0 || currentX >= this.x || currentY < 0 || currentY >= this.y || currentZ < 0 || currentZ >= this.z) continue block2;
                        ReactorModeratorRegistry.IModeratorProperties properties = this.moderatorProperties[currentX][currentY][currentZ];
                        if (properties != null) {
                            double radiationAbsorbed = neutronIntensity * properties.absorption() * (1.0 - neutronHardness) * rayStep.length;
                            neutronIntensity = Math.max(0.0, neutronIntensity - radiationAbsorbed);
                            neutronHardness /= (properties.moderation() - 1.0) * rayStep.length + 1.0;
                            caseRFAdded += properties.heatEfficiency() * radiationAbsorbed * FEPerRadiationUnit;
                            continue;
                        }
                        double controlRodInsertion = this.controlRodsXZ[currentX][currentZ].insertion * 0.001;
                        double baseAbsorption = fuelAbsorptionTemperatureCoefficient * (1.0 - neutronHardness * fuelHardnessMultiplier);
                        double scaledAbsorption = baseAbsorption * FuelAbsorptionCoefficient * rayStep.length;
                        double controlRodBonus = (1.0 - scaledAbsorption) * controlRodInsertion * 0.5;
                        double controlRodPenalty = scaledAbsorption * controlRodInsertion * 0.5;
                        double radiationAbsorbed = (scaledAbsorption + controlRodBonus) * neutronIntensity;
                        double fertilityAbsorbed = (scaledAbsorption - controlRodPenalty) * neutronIntensity;
                        double fuelModerationFactor = FuelModerationFactor + (FuelModerationFactor * controlRodInsertion + controlRodInsertion);
                        neutronIntensity = Math.max(0.0, neutronIntensity - radiationAbsorbed);
                        neutronHardness /= (fuelModerationFactor - 1.0) * rayStep.length + 1.0;
                        fuelRFAdded += radiationAbsorbed * FEPerRadiationUnit;
                        fuelRadAdded += fertilityAbsorbed;
                    }
                }
            }
        }
        rawFuelUsage /= (double)this.controlRods.length;
        fuelRFAdded /= (double)this.controlRods.length;
        caseRFAdded /= (double)this.controlRods.length;
        if (!Double.isNaN(fuelRadAdded /= (double)this.controlRods.length)) {
            this.fuelFertility += fuelRadAdded;
        }
        if (!Double.isNaN(fuelRFAdded)) {
            this.fuelHeat.absorbRF(fuelRFAdded);
        }
        if (!Double.isNaN(caseRFAdded)) {
            this.stackHeat.absorbRF(caseRFAdded);
        }
        this.fuelTank.burn(rawFuelUsage);
    }

    @Override
    @Nullable
    public IReactorSimulation.IBattery battery() {
        return this.battery;
    }

    @Override
    @Nullable
    public IReactorSimulation.ICoolantTank coolantTank() {
        return this.coolantTank;
    }

    @Override
    public IReactorSimulation.IFuelTank fuelTank() {
        return this.fuelTank;
    }

    @Override
    @Nullable
    public IReactorSimulation.ControlRod controlRodAt(int x, int z) {
        if (x < 0 || x >= this.x || z < 0 || z >= this.z) {
            return null;
        }
        return this.controlRodsXZ[x][z];
    }

    @Override
    public double fertility() {
        if (this.fuelFertility <= 1.0) {
            return 1.0;
        }
        return Math.log10(this.fuelFertility) + 1.0;
    }

    @Override
    public double fuelHeat() {
        return this.fuelHeat.temperature();
    }

    @Override
    public double stackHeat() {
        return this.stackHeat.temperature();
    }

    @Override
    public double ambientTemperature() {
        return this.ambientHeat.temperature();
    }

    @Nullable
    public PhosphophylliteCompound save() {
        PhosphophylliteCompound compound = new PhosphophylliteCompound();
        compound.put("fuelTank", this.fuelTank.save());
        if (this.coolantTank != null) {
            compound.put("coolantTank", this.coolantTank.save());
        }
        if (this.battery != null) {
            compound.put("battery", this.battery.save());
        }
        compound.put("fuelFertility", this.fuelFertility);
        compound.put("fuelHeat", this.fuelHeat.temperature());
        compound.put("reactorHeat", this.stackHeat.temperature());
        return compound;
    }

    public void load(@Nonnull PhosphophylliteCompound compound) {
        this.fuelTank.load(compound.getCompound("fuelTank"));
        if (this.coolantTank != null) {
            this.coolantTank.load(compound.getCompound("coolantTank"));
        }
        if (this.battery != null) {
            this.battery.load(compound.getCompound("battery"));
        }
        this.fuelFertility = compound.getDouble("fuelFertility");
        this.fuelHeat.setTemperature(compound.getDouble("fuelHeat"));
        this.stackHeat.setTemperature(compound.getDouble("reactorHeat"));
    }
}

