/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.tiles;

import dan200.computercraft.api.peripheral.IPeripheral;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.roguelogix.biggerreactors.multiblocks.reactor.deps.ReactorPeripheral;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorBaseTile;
import net.roguelogix.phosphophyllite.multiblock.IOnAssemblyTile;
import net.roguelogix.phosphophyllite.registry.RegisterTileEntity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@RegisterTileEntity(name="reactor_computer_port")
public class ReactorComputerPortTile
extends ReactorBaseTile
implements IOnAssemblyTile {
    @RegisterTileEntity.Type
    public static BlockEntityType<?> TYPE;
    @RegisterTileEntity.Supplier
    public static final BlockEntityType.BlockEntitySupplier<ReactorComputerPortTile> SUPPLIER;
    private static final Capability<IPeripheral> CAPABILITY_PERIPHERAL;
    private LazyOptional<ReactorPeripheral> peripheralCapability;

    public ReactorComputerPortTile(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
        if (CAPABILITY_PERIPHERAL.isRegistered()) {
            this.peripheralCapability = ReactorPeripheral.create(() -> ((ReactorComputerPortTile)this).controller());
        }
    }

    public <T> LazyOptional<T> capability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CAPABILITY_PERIPHERAL) {
            return this.peripheralCapability.cast();
        }
        return super.capability(cap, side);
    }

    public void onAssembly() {
        if (CAPABILITY_PERIPHERAL.isRegistered()) {
            this.peripheralCapability.ifPresent(ReactorPeripheral::rebuildControlRodList);
        }
    }

    static {
        SUPPLIER = ReactorComputerPortTile::new;
        CAPABILITY_PERIPHERAL = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPeripheral>(){});
    }
}

