/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.tiles;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.roguelogix.biggerreactors.multiblocks.reactor.ReactorMultiblockController;
import net.roguelogix.biggerreactors.multiblocks.reactor.blocks.ReactorPowerTap;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorSimulation;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorBaseTile;
import net.roguelogix.phosphophyllite.energy.EnergyStorageWrapper;
import net.roguelogix.phosphophyllite.energy.IPhosphophylliteEnergyStorage;
import net.roguelogix.phosphophyllite.multiblock.IOnAssemblyTile;
import net.roguelogix.phosphophyllite.multiblock.IOnDisassemblyTile;
import net.roguelogix.phosphophyllite.multiblock.MultiblockController;
import net.roguelogix.phosphophyllite.registry.RegisterTileEntity;
import net.roguelogix.phosphophyllite.util.BlockStates;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@RegisterTileEntity(name="reactor_power_tap")
public class ReactorPowerTapTile
extends ReactorBaseTile
implements IPhosphophylliteEnergyStorage,
IOnAssemblyTile,
IOnDisassemblyTile {
    @RegisterTileEntity.Type
    public static BlockEntityType<?> TYPE;
    @RegisterTileEntity.Supplier
    public static final BlockEntityType.BlockEntitySupplier<ReactorPowerTapTile> SUPPLIER;
    private boolean connected = false;
    Direction powerOutputDirection = null;
    private static final EnergyStorage ENERGY_ZERO;
    LazyOptional<?> outputOptional = LazyOptional.empty();
    IPhosphophylliteEnergyStorage output;

    public ReactorPowerTapTile(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    public <T> LazyOptional<T> capability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.capability(cap, side);
    }

    private void setConnected(boolean newState) {
        if (newState != this.connected) {
            this.connected = newState;
            assert (this.f_58857_ != null);
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(ReactorPowerTap.ConnectionState.CONNECTION_STATE_ENUM_PROPERTY, (Comparable)((Object)(this.connected ? ReactorPowerTap.ConnectionState.CONNECTED : ReactorPowerTap.ConnectionState.DISCONNECTED))), 3);
        }
    }

    public long distributePower(long toDistribute, boolean simulate) {
        if (this.outputOptional.isPresent()) {
            return Math.max(0L, this.output.insertEnergy(toDistribute, simulate));
        }
        return 0L;
    }

    public long insertEnergy(long maxInsert, boolean simulate) {
        return 0L;
    }

    public long extractEnergy(long maxExtract, boolean simulate) {
        if (maxExtract <= 0L || this.nullableController() == null || ((ReactorMultiblockController)this.controller()).assemblyState() != MultiblockController.AssemblyState.ASSEMBLED) {
            return 0L;
        }
        IReactorSimulation reactorSim = ((ReactorMultiblockController)this.controller()).simulation();
        if (reactorSim == null) {
            return 0L;
        }
        IReactorSimulation.IBattery battery = reactorSim.battery();
        if (battery == null) {
            return 0L;
        }
        long toExtract = battery.stored();
        toExtract = Math.min(maxExtract, toExtract);
        if (!simulate) {
            toExtract = battery.extract(toExtract);
        }
        return toExtract;
    }

    public long energyStored() {
        if (this.nullableController() != null) {
            IReactorSimulation reactorSim = ((ReactorMultiblockController)this.controller()).simulation();
            if (reactorSim == null) {
                return 0L;
            }
            IReactorSimulation.IBattery battery = reactorSim.battery();
            if (battery == null) {
                return 0L;
            }
            return Math.max(0L, battery.stored());
        }
        return 0L;
    }

    public long maxEnergyStored() {
        if (this.nullableController() != null) {
            IReactorSimulation reactorSim = ((ReactorMultiblockController)this.controller()).simulation();
            if (reactorSim == null) {
                return 0L;
            }
            IReactorSimulation.IBattery battery = reactorSim.battery();
            if (battery == null) {
                return 0L;
            }
            return Math.max(0L, battery.capacity());
        }
        return 0L;
    }

    public boolean canInsert() {
        return false;
    }

    public boolean canExtract() {
        return true;
    }

    public void neighborChanged() {
        this.outputOptional = LazyOptional.empty();
        this.output = null;
        if (this.powerOutputDirection == null) {
            this.setConnected(false);
            return;
        }
        assert (this.f_58857_ != null);
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(this.powerOutputDirection));
        if (te == null) {
            this.setConnected(false);
            return;
        }
        LazyOptional energyOptional = te.getCapability(CapabilityEnergy.ENERGY, this.powerOutputDirection.m_122424_());
        this.setConnected(energyOptional.isPresent());
        if (this.connected) {
            this.outputOptional = energyOptional;
            this.output = EnergyStorageWrapper.wrap((IEnergyStorage)((IEnergyStorage)energyOptional.orElse((Object)ENERGY_ZERO)));
        }
    }

    public void onAssembly() {
        this.powerOutputDirection = (Direction)this.m_58900_().m_61143_((Property)BlockStates.FACING);
        this.neighborChanged();
    }

    public void onDisassembly() {
        this.powerOutputDirection = null;
        this.neighborChanged();
    }

    static {
        SUPPLIER = ReactorPowerTapTile::new;
        ENERGY_ZERO = new EnergyStorage(0);
    }
}

