/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.turbine.blocks;

import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.roguelogix.biggerreactors.multiblocks.turbine.blocks.TurbineBaseBlock;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbineCoolantPortTile;
import net.roguelogix.phosphophyllite.multiblock.IAssemblyStateBlock;
import net.roguelogix.phosphophyllite.multiblock.rectangular.IFaceDirectionBlock;
import net.roguelogix.phosphophyllite.registry.RegisterBlock;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TurbineCoolantPort
extends TurbineBaseBlock
implements IAssemblyStateBlock,
IFaceDirectionBlock {
    @RegisterBlock(name="turbine_coolant_port", tileEntityClass=TurbineCoolantPortTile.class)
    public static final TurbineCoolantPort INSTANCE = new TurbineCoolantPort();

    public TurbineCoolantPort() {
        this.m_49959_((BlockState)this.m_49966_().m_61124_(PortDirection.PORT_DIRECTION_ENUM_PROPERTY, (Comparable)((Object)PortDirection.INLET)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TurbineCoolantPortTile(pos, state);
    }

    @Override
    protected void buildStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PortDirection.PORT_DIRECTION_ENUM_PROPERTY});
    }

    @Override
    public InteractionResult onUse(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Set tags;
        if (handIn == InteractionHand.MAIN_HAND && ((tags = player.m_21205_().m_41720_().getTags()).contains(new ResourceLocation("forge:tools/wrench")) || tags.contains(new ResourceLocation("forge:wrenches")))) {
            BlockEntity te;
            PortDirection direction = (PortDirection)((Object)state.m_61143_(PortDirection.PORT_DIRECTION_ENUM_PROPERTY));
            direction = direction == PortDirection.INLET ? PortDirection.OUTLET : PortDirection.INLET;
            state = (BlockState)state.m_61124_(PortDirection.PORT_DIRECTION_ENUM_PROPERTY, (Comparable)((Object)direction));
            worldIn.m_46597_(pos, state);
            if (!worldIn.m_5776_() && (te = worldIn.m_7702_(pos)) instanceof TurbineCoolantPortTile) {
                ((TurbineCoolantPortTile)te).setDirection(direction);
            }
            return InteractionResult.SUCCESS;
        }
        return super.onUse(state, worldIn, pos, player, handIn, hit);
    }

    public void onNeighborChange(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChange(state, worldIn, pos, blockIn, fromPos, isMoving);
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof TurbineCoolantPortTile) {
            ((TurbineCoolantPortTile)te).neighborChanged();
        }
    }

    public static enum PortDirection implements StringRepresentable
    {
        INLET,
        OUTLET;

        public static final EnumProperty<PortDirection> PORT_DIRECTION_ENUM_PROPERTY;

        public String m_7912_() {
            return this.toString().toLowerCase(Locale.US);
        }

        static {
            PORT_DIRECTION_ENUM_PROPERTY = EnumProperty.m_61587_((String)"portdirection", PortDirection.class);
        }
    }
}

