/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.turbine.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Iterator;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.roguelogix.biggerreactors.BiggerReactors;
import net.roguelogix.biggerreactors.multiblocks.turbine.blocks.TurbineRotorBlade;
import net.roguelogix.biggerreactors.multiblocks.turbine.blocks.TurbineRotorShaft;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbineRotorBearingTile;
import net.roguelogix.phosphophyllite.multiblock.IAssemblyStateBlock;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector4i;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BladeRenderer
implements BlockEntityRenderer<TurbineRotorBearingTile> {
    public BladeRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public void render(TurbineRotorBearingTile bearing, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        int blade180RotationMultiplier;
        if (TurbineRotorBearingTile.USE_QUARTZ) {
            return;
        }
        BlockState state = bearing.m_58900_();
        if ((Boolean)state.m_61143_((Property)IAssemblyStateBlock.ASSEMBLED) == false) return;
        if (!bearing.isRenderBearing) {
            return;
        }
        if (bearing.rotationAxis == null) return;
        if (bearing.rotorConfiguration == null) return;
        if (bearing.rotationAxis.x() == 0 && bearing.rotationAxis.y() == 0 && bearing.rotationAxis.z() == 0) {
            return;
        }
        double angle = bearing.angle;
        long elapsedTimeNano = System.nanoTime() - BiggerReactors.lastRenderTime;
        double speed = bearing.speed / 10.0;
        if (speed > (double)0.001f) {
            double elapsedTimeMilis = (double)elapsedTimeNano / 1000000.0;
            angle += speed * (double)((float)elapsedTimeMilis / 60000.0f) * 360.0;
            bearing.angle = angle %= 360.0;
        }
        if ((blade180RotationMultiplier = -bearing.rotationAxis.x() | -bearing.rotationAxis.y() | bearing.rotationAxis.z()) > 0) {
            angle += 180.0;
        }
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.5, 0.5, 0.5);
        Quaternion axisRotation = null;
        if (bearing.rotationAxis.x() != 0) {
            axisRotation = new Quaternion(Vector3f.f_122227_, (float)(-90 * bearing.rotationAxis.x()), true);
            angle -= 90.0;
        } else if (bearing.rotationAxis.z() != 0) {
            axisRotation = new Quaternion(Vector3f.f_122223_, (float)(90 * bearing.rotationAxis.z()), true);
        } else if (bearing.rotationAxis.y() != 1) {
            axisRotation = new Quaternion(Vector3f.f_122223_, 180.0f, true);
        }
        if (axisRotation != null) {
            matrixStackIn.m_85845_(axisRotation);
        }
        matrixStackIn.m_85845_(new Quaternion(Vector3f.f_122225_, (float)angle, true));
        matrixStackIn.m_85837_(-0.5, -0.5, -0.5);
        int bearingNum = 0;
        Iterator<Vector4i> iterator = bearing.rotorConfiguration.iterator();
        block5: while (true) {
            if (!iterator.hasNext()) {
                matrixStackIn.m_85849_();
                return;
            }
            Vector4i vector4i = iterator.next();
            matrixStackIn.m_85837_(0.0, 1.0, 0.0);
            BlockPos shaftPos = bearing.m_58899_().m_142082_(bearing.rotationAxis.x(), bearing.rotationAxis.y(), bearing.rotationAxis.z());
            int skyLight = bearing.m_58904_().m_45517_(LightLayer.SKY, shaftPos);
            int blockLight = bearing.m_58904_().m_45517_(LightLayer.BLOCK, shaftPos);
            int combinedLight = skyLight << 16 | blockLight;
            ++bearingNum;
            Minecraft.m_91087_().m_91289_().renderSingleBlock(TurbineRotorShaft.INSTANCE.m_49966_(), matrixStackIn, bufferIn, combinedLight *= 16, 655360, (IModelData)EmptyModelData.INSTANCE);
            int i = 0;
            Direction[] directionArray = Direction.values();
            int n = directionArray.length;
            int n2 = 0;
            while (true) {
                block20: {
                    if (n2 >= n) continue block5;
                    Direction direction = directionArray[n2];
                    switch (direction) {
                        case UP: 
                        case DOWN: {
                            if (bearing.rotationAxis.y() == 0) break;
                            break block20;
                        }
                        case NORTH: 
                        case SOUTH: {
                            if (bearing.rotationAxis.z() == 0) break;
                            break block20;
                        }
                        case WEST: 
                        case EAST: {
                            if (bearing.rotationAxis.x() != 0) break block20;
                        }
                    }
                    for (int j = 0; j < vector4i.get(i); ++j) {
                        matrixStackIn.m_85836_();
                        matrixStackIn.m_85837_(0.5, 0.5, 0.5);
                        matrixStackIn.m_85845_(new Quaternion(Vector3f.f_122225_, (float)(180 * (i & 1) + blade180RotationMultiplier * 135 * (i & 2)), true));
                        matrixStackIn.m_85837_(-0.5, -0.5, -0.5);
                        matrixStackIn.m_85837_(0.0, 0.0, (double)(-(j + 1)));
                        matrixStackIn.m_85837_(0.5, 0.5, 0.5);
                        matrixStackIn.m_85845_(new Quaternion(Vector3f.f_122227_, 180.0f, true));
                        matrixStackIn.m_85837_(-0.5, -0.5, -0.5);
                        Minecraft.m_91087_().m_91289_().renderSingleBlock(TurbineRotorBlade.INSTANCE.m_49966_(), matrixStackIn, bufferIn, combinedLight, 655360, (IModelData)EmptyModelData.INSTANCE);
                        matrixStackIn.m_85849_();
                    }
                    ++i;
                }
                ++n2;
            }
            break;
        }
    }
}

