/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.turbine.tiles;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.roguelogix.biggerreactors.multiblocks.turbine.TurbineMultiblockController;
import net.roguelogix.biggerreactors.multiblocks.turbine.blocks.TurbineCoolantPort;
import net.roguelogix.biggerreactors.multiblocks.turbine.containers.TurbineCoolantPortContainer;
import net.roguelogix.biggerreactors.multiblocks.turbine.simulation.ITurbineFluidTank;
import net.roguelogix.biggerreactors.multiblocks.turbine.state.TurbineCoolantPortState;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbineBaseTile;
import net.roguelogix.phosphophyllite.client.gui.api.IHasUpdatableState;
import net.roguelogix.phosphophyllite.fluids.FluidHandlerWrapper;
import net.roguelogix.phosphophyllite.fluids.IPhosphophylliteFluidHandler;
import net.roguelogix.phosphophyllite.multiblock.IOnAssemblyTile;
import net.roguelogix.phosphophyllite.multiblock.IOnDisassemblyTile;
import net.roguelogix.phosphophyllite.registry.RegisterTileEntity;
import net.roguelogix.phosphophyllite.util.BlockStates;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@RegisterTileEntity(name="turbine_coolant_port")
public class TurbineCoolantPortTile
extends TurbineBaseTile
implements IPhosphophylliteFluidHandler,
MenuProvider,
IHasUpdatableState<TurbineCoolantPortState>,
IOnAssemblyTile,
IOnDisassemblyTile {
    @RegisterTileEntity.Type
    public static BlockEntityType<?> TYPE;
    @RegisterTileEntity.Supplier
    public static final BlockEntityType.BlockEntitySupplier<TurbineCoolantPortTile> SUPPLIER;
    private ITurbineFluidTank transitionTank;
    private boolean connected = false;
    Direction waterOutputDirection = null;
    LazyOptional<?> handlerOptional = LazyOptional.empty();
    IPhosphophylliteFluidHandler handler = null;
    FluidTank EMPTY_TANK = new FluidTank(0);
    private TurbineCoolantPort.PortDirection direction = TurbineCoolantPort.PortDirection.INLET;
    public final TurbineCoolantPortState coolantPortState = new TurbineCoolantPortState(this);

    public TurbineCoolantPortTile(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    public <T> LazyOptional<T> capability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.capability(cap, side);
    }

    public int tankCount() {
        if (this.transitionTank == null) {
            return 0;
        }
        return this.transitionTank.tankCount();
    }

    public long tankCapacity(int tank) {
        if (this.transitionTank == null) {
            return 0L;
        }
        return this.transitionTank.tankCapacity(tank);
    }

    public Fluid fluidTypeInTank(int tank) {
        if (this.transitionTank == null) {
            return Fluids.f_76191_;
        }
        return this.transitionTank.fluidTypeInTank(tank);
    }

    @Nullable
    public CompoundTag fluidTagInTank(int tank) {
        if (this.transitionTank == null) {
            return null;
        }
        return this.transitionTank.fluidTagInTank(tank);
    }

    public long fluidAmountInTank(int tank) {
        if (this.transitionTank == null) {
            return 0L;
        }
        return this.transitionTank.fluidAmountInTank(tank);
    }

    public boolean fluidValidForTank(int tank, Fluid fluid) {
        if (this.transitionTank == null) {
            return false;
        }
        return this.transitionTank.fluidValidForTank(tank, fluid);
    }

    public long fill(Fluid fluid, @Nullable CompoundTag tag, long amount, boolean simulate) {
        if (this.transitionTank == null || this.direction != TurbineCoolantPort.PortDirection.INLET) {
            return 0L;
        }
        return this.transitionTank.fill(fluid, null, amount, simulate);
    }

    public long drain(Fluid fluid, @Nullable CompoundTag tag, long amount, boolean simulate) {
        if (this.transitionTank == null || this.direction == TurbineCoolantPort.PortDirection.INLET) {
            return 0L;
        }
        return this.transitionTank.drain(fluid, null, amount, simulate);
    }

    public long pushFluid() {
        if (!this.connected || this.direction == TurbineCoolantPort.PortDirection.INLET) {
            return 0L;
        }
        if (this.handlerOptional.isPresent()) {
            Fluid fluid = this.transitionTank.liquidType();
            long amount = this.transitionTank.liquidAmount();
            amount = this.transitionTank.drain(fluid, null, amount, true);
            amount = this.handler.fill(fluid, null, amount, false);
            amount = this.transitionTank.drain(fluid, null, amount, false);
            return amount;
        }
        this.handlerOptional = LazyOptional.empty();
        this.handler = null;
        this.connected = false;
        return 0L;
    }

    public void neighborChanged() {
        this.handlerOptional = LazyOptional.empty();
        this.handler = null;
        if (this.waterOutputDirection == null) {
            this.connected = false;
            return;
        }
        assert (this.f_58857_ != null);
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(this.waterOutputDirection));
        if (te == null) {
            this.connected = false;
            return;
        }
        this.connected = false;
        LazyOptional waterOutput = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.waterOutputDirection.m_122424_());
        if (waterOutput.isPresent()) {
            this.connected = true;
            this.handlerOptional = waterOutput;
            this.handler = FluidHandlerWrapper.wrap((IFluidHandler)((IFluidHandler)waterOutput.orElse((Object)this.EMPTY_TANK)));
        }
    }

    public void setDirection(TurbineCoolantPort.PortDirection direction) {
        this.direction = direction;
        this.m_6596_();
    }

    protected void readNBT(CompoundTag compound) {
        if (compound.m_128441_("direction")) {
            this.direction = TurbineCoolantPort.PortDirection.valueOf(compound.m_128461_("direction"));
        }
    }

    protected CompoundTag writeNBT() {
        CompoundTag NBT = new CompoundTag();
        NBT.m_128359_("direction", String.valueOf((Object)this.direction));
        return NBT;
    }

    @Override
    public void runRequest(String requestName, Object requestData) {
        if (requestName.equals("setDirection")) {
            this.setDirection((Integer)requestData != 0 ? TurbineCoolantPort.PortDirection.OUTLET : TurbineCoolantPort.PortDirection.INLET);
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(TurbineCoolantPort.PortDirection.PORT_DIRECTION_ENUM_PROPERTY, (Comparable)((Object)this.direction)));
        }
        super.runRequest(requestName, requestData);
    }

    public Component m_5446_() {
        return new TranslatableComponent(TurbineCoolantPort.INSTANCE.m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new TurbineCoolantPortContainer(windowId, this.f_58858_, player);
    }

    @Nullable
    public TurbineCoolantPortState getState() {
        this.updateState();
        return this.coolantPortState;
    }

    public void updateState() {
        this.coolantPortState.direction = this.direction == TurbineCoolantPort.PortDirection.INLET;
    }

    public void onAssembly() {
        this.transitionTank = ((TurbineMultiblockController)this.controller()).simulation().fluidTank();
        this.waterOutputDirection = (Direction)this.m_58900_().m_61143_((Property)BlockStates.FACING);
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_(TurbineCoolantPort.PortDirection.PORT_DIRECTION_ENUM_PROPERTY, (Comparable)((Object)this.direction)));
        this.neighborChanged();
    }

    public void onDisassembly() {
        this.waterOutputDirection = null;
        this.transitionTank = null;
        this.neighborChanged();
    }

    static {
        SUPPLIER = TurbineCoolantPortTile::new;
    }
}

