/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.turbine.tiles;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.roguelogix.biggerreactors.multiblocks.turbine.TurbineMultiblockController;
import net.roguelogix.biggerreactors.multiblocks.turbine.blocks.TurbineRotorBlade;
import net.roguelogix.biggerreactors.multiblocks.turbine.blocks.TurbineRotorShaft;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbineBaseTile;
import net.roguelogix.phosphophyllite.Phosphophyllite;
import net.roguelogix.phosphophyllite.multiblock.IAssemblyAttemptedTile;
import net.roguelogix.phosphophyllite.multiblock.IAssemblyStateBlock;
import net.roguelogix.phosphophyllite.registry.RegisterTileEntity;
import net.roguelogix.phosphophyllite.repack.org.joml.AABBi;
import net.roguelogix.phosphophyllite.repack.org.joml.Matrix4f;
import net.roguelogix.phosphophyllite.repack.org.joml.Matrix4fc;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3i;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3ic;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector4i;
import net.roguelogix.phosphophyllite.threading.Event;
import net.roguelogix.phosphophyllite.threading.Queues;
import net.roguelogix.quartz.DrawBatch;
import net.roguelogix.quartz.DynamicLight;
import net.roguelogix.quartz.DynamicMatrix;
import net.roguelogix.quartz.Mesh;
import net.roguelogix.quartz.Quartz;
import net.roguelogix.quartz.QuartzEvent;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@RegisterTileEntity(name="turbine_rotor_bearing")
public class TurbineRotorBearingTile
extends TurbineBaseTile
implements IAssemblyAttemptedTile {
    public static boolean USE_QUARTZ = true;
    @RegisterTileEntity.Type
    public static BlockEntityType<TurbineRotorBearingTile> TYPE;
    @RegisterTileEntity.Supplier
    public static final BlockEntityType.BlockEntitySupplier<TurbineRotorBearingTile> SUPPLIER;
    public double angle = 0.0;
    public boolean isRenderBearing = false;
    public double speed = 0.0;
    public Vector3i rotationAxis = null;
    public ArrayList<Vector4i> rotorConfiguration = null;
    public AABB AABB = null;
    private long sendFullUpdate = Long.MAX_VALUE;
    private static Mesh shaftMesh;
    private static Mesh bladeMesh;
    private final ObjectArrayList<DrawBatch.Instance> instances = new ObjectArrayList();

    public TurbineRotorBearingTile(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    @Nullable
    public CompoundTag getUpdateNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.nullableController() != null) {
            if (!((Boolean)this.m_58900_().m_61143_((Property)IAssemblyStateBlock.ASSEMBLED)).booleanValue()) {
                nbt.m_128379_("disassembled", true);
                return nbt;
            }
            nbt.m_128347_("speed", ((TurbineMultiblockController)this.controller()).simulation().RPM());
            if (this.sendFullUpdate < Phosphophyllite.tickNumber()) {
                this.sendFullUpdate = Long.MAX_VALUE;
                nbt.m_128365_("config", (Tag)this.m_5995_());
            }
        }
        return nbt;
    }

    public void handleUpdateNBT(CompoundTag nbt) {
        if (((Boolean)this.m_58900_().m_61143_((Property)IAssemblyStateBlock.ASSEMBLED)).booleanValue() && nbt.m_128441_("speed")) {
            this.speed = nbt.m_128459_("speed");
            if (nbt.m_128441_("config")) {
                this.handleUpdateTag(nbt.m_128469_("config"));
            }
        } else {
            Queues.clientThread.enqueue(this::teardownQuartzModel, new Event[0]);
            this.isRenderBearing = false;
        }
    }

    public void handleDataNBT(CompoundTag nbt) {
        if (nbt.m_128441_("rotx")) {
            this.isRenderBearing = true;
            if (this.rotationAxis == null) {
                this.rotationAxis = new Vector3i();
            }
            this.rotationAxis.set(nbt.m_128451_("rotx"), nbt.m_128451_("roty"), nbt.m_128451_("rotz"));
            if (this.rotorConfiguration == null) {
                this.rotorConfiguration = new ArrayList();
            }
            this.rotorConfiguration.clear();
            int rotorShafts = nbt.m_128451_("shafts");
            for (int i = 0; i < rotorShafts; ++i) {
                Vector4i vec = new Vector4i();
                vec.x = nbt.m_128451_("shaft" + i + "0");
                vec.y = nbt.m_128451_("shaft" + i + "1");
                vec.z = nbt.m_128451_("shaft" + i + "2");
                vec.w = nbt.m_128451_("shaft" + i + "3");
                this.rotorConfiguration.add(vec);
            }
            this.AABB = new AABB((double)nbt.m_128451_("minx"), (double)nbt.m_128451_("miny"), (double)nbt.m_128451_("minz"), (double)nbt.m_128451_("maxx"), (double)nbt.m_128451_("maxy"), (double)nbt.m_128451_("maxz"));
            Queues.clientThread.enqueue(this::setupQuartzModel, new Event[0]);
        } else {
            Queues.clientThread.enqueue(this::teardownQuartzModel, new Event[0]);
            this.isRenderBearing = false;
        }
    }

    public CompoundTag getDataNBT() {
        CompoundTag nbt = super.getDataNBT();
        if (this.isRenderBearing && this.nullableController() != null) {
            nbt.m_128405_("rotx", ((TurbineMultiblockController)this.controller()).rotationAxis.m_123341_());
            nbt.m_128405_("roty", ((TurbineMultiblockController)this.controller()).rotationAxis.m_123342_());
            nbt.m_128405_("rotz", ((TurbineMultiblockController)this.controller()).rotationAxis.m_123343_());
            nbt.m_128405_("minx", ((TurbineMultiblockController)this.controller()).minCoord().x());
            nbt.m_128405_("miny", ((TurbineMultiblockController)this.controller()).minCoord().y());
            nbt.m_128405_("minz", ((TurbineMultiblockController)this.controller()).minCoord().z());
            nbt.m_128405_("maxx", ((TurbineMultiblockController)this.controller()).maxCoord().x());
            nbt.m_128405_("maxy", ((TurbineMultiblockController)this.controller()).maxCoord().y());
            nbt.m_128405_("maxz", ((TurbineMultiblockController)this.controller()).maxCoord().z());
            nbt.m_128405_("shafts", ((TurbineMultiblockController)this.controller()).rotorConfiguration.size());
            ArrayList<Vector4i> config = ((TurbineMultiblockController)this.controller()).rotorConfiguration;
            for (int i = 0; i < config.size(); ++i) {
                Vector4i vec = config.get(i);
                nbt.m_128405_("shaft" + i + "0", vec.x);
                nbt.m_128405_("shaft" + i + "1", vec.y);
                nbt.m_128405_("shaft" + i + "2", vec.z);
                nbt.m_128405_("shaft" + i + "3", vec.w);
            }
        }
        return nbt;
    }

    public void onRemoved(boolean chunkUnload) {
        if (Queues.clientThread != null) {
            Queues.clientThread.enqueue(this::teardownQuartzModel, new Event[0]);
        }
    }

    public void onAssemblyAttempted() {
        this.sendFullUpdate = Phosphophyllite.tickNumber() + 10L;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        if (this.AABB == null) {
            return INFINITE_EXTENT_AABB;
        }
        return this.AABB;
    }

    private static void onQuartzStartup(QuartzEvent.Startup quartzStartup) {
        shaftMesh = Quartz.createStaticMesh((BlockState)TurbineRotorShaft.INSTANCE.m_49966_());
        bladeMesh = Quartz.createStaticMesh((BlockState)TurbineRotorBlade.INSTANCE.m_49966_());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setupQuartzModel() {
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            return;
        }
        this.teardownQuartzModel();
        if (!USE_QUARTZ) {
            return;
        }
        if (this.f_58857_.m_7702_(this.m_58899_()) != this) {
            return;
        }
        Matrix4f jomlMatrix = new Matrix4f();
        int blade180RotationMultiplier = -this.rotationAxis.x() | -this.rotationAxis.y() | this.rotationAxis.z();
        DrawBatch drawBatch = Quartz.getDrawBatcherForAABB((AABBi)new AABBi((int)this.AABB.f_82288_, (int)this.AABB.f_82289_, (int)this.AABB.f_82290_, (int)this.AABB.f_82291_, (int)this.AABB.f_82292_, (int)this.AABB.f_82293_));
        DynamicMatrix dynamicMatrix = drawBatch.createDynamicMatrix((matrix, nanoSinceLastFrame, partialTicks, playerBlock, playerPartialBlock) -> {
            double angle = this.angle;
            double speed = this.speed / 10.0;
            if (speed > (double)0.001f) {
                double elapsedTimeMilis = (double)nanoSinceLastFrame / 1000000.0;
                angle += speed * (double)((float)elapsedTimeMilis / 60000.0f) * 360.0;
                this.angle = angle %= 360.0;
            }
            if (blade180RotationMultiplier > 0) {
                angle += 180.0;
            }
            if (this.rotationAxis.x() != 0) {
                angle += 180.0;
            }
            jomlMatrix.identity();
            jomlMatrix.translate(0.5f, 0.5f, 0.5f);
            if (this.rotationAxis.x() != 0) {
                jomlMatrix.rotate((float)Math.toRadians(-90.0f * (float)this.rotationAxis.x()), 0.0f, 0.0f, 1.0f);
                angle -= 90.0;
            } else if (this.rotationAxis.z() != 0) {
                jomlMatrix.rotate((float)Math.toRadians(90.0f * (float)this.rotationAxis.z()), 1.0f, 0.0f, 0.0f);
            } else if (this.rotationAxis.y() != 1) {
                jomlMatrix.rotate((float)Math.toRadians(180.0), 1.0f, 0.0f, 0.0f);
            }
            jomlMatrix.rotate((float)Math.toRadians(angle), 0.0f, 1.0f, 0.0f);
            jomlMatrix.translate(-0.5f, -0.5f, -0.5f);
            matrix.write((Matrix4fc)jomlMatrix);
        });
        Vector3i worldPos = new Vector3i(this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_());
        Iterator<Vector4i> iterator = this.rotorConfiguration.iterator();
        block5: while (iterator.hasNext()) {
            Vector4i vector4i = iterator.next();
            worldPos.add((Vector3ic)this.rotationAxis);
            DynamicLight light = drawBatch.createLight((Vector3ic)worldPos, DynamicLight.Type.INTERNAL);
            jomlMatrix.identity();
            this.instances.add((Object)drawBatch.createInstance((Vector3ic)worldPos, shaftMesh, dynamicMatrix, (Matrix4fc)jomlMatrix, light, null));
            int i = 0;
            Direction[] directionArray = Direction.values();
            int n = directionArray.length;
            int n2 = 0;
            while (true) {
                block12: {
                    if (n2 >= n) continue block5;
                    Direction direction = directionArray[n2];
                    switch (direction) {
                        case UP: 
                        case DOWN: {
                            if (this.rotationAxis.y() == 0) break;
                            break block12;
                        }
                        case NORTH: 
                        case SOUTH: {
                            if (this.rotationAxis.z() == 0) break;
                            break block12;
                        }
                        case WEST: 
                        case EAST: {
                            if (this.rotationAxis.x() != 0) break block12;
                        }
                    }
                    for (int j = 0; j < vector4i.get(i); ++j) {
                        jomlMatrix.identity();
                        jomlMatrix.translate(0.5f, 0.5f, 0.5f);
                        jomlMatrix.rotate((float)Math.toRadians(180 * (i & 1)), 0.0f, 1.0f, 0.0f);
                        jomlMatrix.rotate((float)Math.toRadians(blade180RotationMultiplier * 135 * (i & 2)), 0.0f, 1.0f, 0.0f);
                        jomlMatrix.translate(-0.5f, -0.5f, -0.5f);
                        jomlMatrix.translate(0.0f, 0.0f, (float)(-(j + 1)));
                        jomlMatrix.translate(0.5f, 0.5f, 0.5f);
                        jomlMatrix.rotate((float)Math.toRadians(180.0), 0.0f, 0.0f, 1.0f);
                        jomlMatrix.translate(-0.5f, -0.5f, -0.5f);
                        this.instances.add((Object)drawBatch.createInstance((Vector3ic)worldPos, bladeMesh, dynamicMatrix, (Matrix4fc)jomlMatrix, light, null));
                    }
                    ++i;
                }
                ++n2;
            }
            break;
        }
        return;
    }

    private void teardownQuartzModel() {
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            return;
        }
        for (int i = 0; i < this.instances.size(); ++i) {
            ((DrawBatch.Instance)this.instances.get(i)).delete();
        }
        this.instances.clear();
    }

    static {
        SUPPLIER = TurbineRotorBearingTile::new;
        Quartz.EVENT_BUS.addListener(TurbineRotorBearingTile::onQuartzStartup);
    }
}

