/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.registries;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.tags.TagContainer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.roguelogix.biggerreactors.BiggerReactors;
import net.roguelogix.phosphophyllite.data.DataLoader;
import net.roguelogix.phosphophyllite.robn.ROBNObject;
import org.apache.commons.lang3.NotImplementedException;

public class ReactorModeratorRegistry {
    private static final HashMap<Block, ModeratorProperties> registry = new HashMap();
    private static final DataLoader<ReactorModeratorJsonData> dataLoader = new DataLoader(ReactorModeratorJsonData.class);

    public static Map<Block, ModeratorProperties> getImmutableRegistry() {
        return Collections.unmodifiableMap(registry);
    }

    public static boolean isBlockAllowed(Block block) {
        return registry.containsKey(block);
    }

    public static ModeratorProperties blockModeratorProperties(Block block) {
        return registry.get(block);
    }

    public static void loadRegistry(TagContainer tags) {
        TagCollection blockTags = tags.m_144452_(Registry.f_122901_);
        TagCollection fluidTags = tags.m_144452_(Registry.f_122899_);
        BiggerReactors.LOGGER.info("Loading reactor moderators");
        registry.clear();
        List data = dataLoader.loadAll(new ResourceLocation("biggerreactors:ebcr/moderators"));
        BiggerReactors.LOGGER.info("Loaded " + data.size() + " moderator data entries");
        for (ReactorModeratorJsonData moderatorData : data) {
            ModeratorProperties properties = new ModeratorProperties(moderatorData.absorption, moderatorData.efficiency, moderatorData.moderation, moderatorData.conductivity);
            switch (moderatorData.type) {
                case "tag": {
                    Tag blockTag = blockTags.m_13404_(moderatorData.location);
                    if (blockTag == null) break;
                    for (Block element : blockTag.m_6497_()) {
                        registry.put(element, properties);
                        BiggerReactors.LOGGER.debug("Loaded moderator " + element.getRegistryName().toString());
                    }
                    break;
                }
                case "registry": {
                    if (!ForgeRegistries.BLOCKS.containsKey(moderatorData.location)) break;
                    registry.put((Block)ForgeRegistries.BLOCKS.getValue(moderatorData.location), properties);
                    BiggerReactors.LOGGER.debug("Loaded moderator " + moderatorData.location);
                    break;
                }
                case "fluidtag": {
                    Tag blockTag = fluidTags.m_13404_(moderatorData.location);
                    if (blockTag == null) break;
                    for (Block element : blockTag.m_6497_()) {
                        Block elementBlock = element.m_76145_().m_76188_().m_60734_();
                        registry.put(elementBlock, properties);
                        BiggerReactors.LOGGER.debug("Loaded moderator " + element.getRegistryName().toString());
                    }
                    break;
                }
                case "fluid": {
                    if (!ForgeRegistries.FLUIDS.containsKey(moderatorData.location)) break;
                    Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(moderatorData.location);
                    assert (fluid != null);
                    Block block = fluid.m_76145_().m_76188_().m_60734_();
                    registry.put(block, properties);
                    BiggerReactors.LOGGER.debug("Loaded moderator " + moderatorData.location);
                }
            }
        }
        BiggerReactors.LOGGER.info("Loaded " + registry.size() + " moderator entries");
    }

    public static class ModeratorProperties
    implements IModeratorProperties,
    ROBNObject {
        public static final ModeratorProperties EMPTY_MODERATOR = new ModeratorProperties(0.0, 0.0, 1.0, 0.0);
        public final double absorption;
        public final double heatEfficiency;
        public final double moderation;
        public final double heatConductivity;

        public ModeratorProperties(double absorption, double heatEfficiency, double moderation, double heatConductivity) {
            this.absorption = absorption;
            this.heatEfficiency = heatEfficiency;
            this.moderation = moderation;
            this.heatConductivity = heatConductivity;
        }

        @Override
        public double absorption() {
            return this.absorption;
        }

        @Override
        public double heatEfficiency() {
            return this.heatEfficiency;
        }

        @Override
        public double moderation() {
            return this.moderation;
        }

        @Override
        public double heatConductivity() {
            return this.heatConductivity;
        }
    }

    private static class ReactorModeratorJsonData {
        @DataLoader.Values(value={"tag", "registry", "fluidtag", "fluid"})
        String type;
        ResourceLocation location;
        @DataLoader.Range(value="[0,1]")
        double absorption;
        @DataLoader.Range(value="[0,1]")
        double efficiency;
        @DataLoader.Range(value="[1,)")
        double moderation;
        @DataLoader.Range(value="[0,)")
        double conductivity;

        private ReactorModeratorJsonData() {
        }
    }

    public static interface IModeratorProperties
    extends ROBNObject {
        public double absorption();

        public double heatEfficiency();

        public double moderation();

        public double heatConductivity();

        default public Map<String, Object> toROBNMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("absorption", this.absorption());
            map.put("heatEfficiency", this.heatEfficiency());
            map.put("moderation", this.moderation());
            map.put("heatConductivity", this.heatConductivity());
            return map;
        }

        default public void fromROBNMap(Map<String, Object> map) {
            throw new NotImplementedException("");
        }
    }
}

