/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.page;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import vazkii.patchouli.client.base.ClientAdvancements;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.page.abstr.PageWithText;
import vazkii.patchouli.common.book.Book;

public class PageQuest
extends PageWithText {
    ResourceLocation trigger;
    String title;
    transient boolean isManual;

    @Override
    public int getTextHeight() {
        return 22;
    }

    @Override
    public void build(BookEntry entry, BookContentsBuilder builder, int pageNum) {
        super.build(entry, builder, pageNum);
        this.isManual = this.trigger == null;
    }

    public boolean isCompleted(Book book) {
        return this.isManual ? PersistentData.data.getBookData((Book)book).completedManualQuests.contains(this.entry.getId().toString()) : this.trigger != null && ClientAdvancements.hasDone(this.trigger.toString());
    }

    @Override
    public void onDisplayed(GuiBookEntry parent, int left, int top) {
        super.onDisplayed(parent, left, top);
        if (this.isManual) {
            Button button = new Button(8, 121, 100, 20, TextComponent.f_131282_, this::questButtonClicked);
            this.addButton(button);
            this.updateButtonText(button);
        }
    }

    private void updateButtonText(Button button) {
        boolean completed = this.isCompleted(this.parent.book);
        TranslatableComponent s = new TranslatableComponent(completed ? "patchouli.gui.lexicon.mark_incomplete" : "patchouli.gui.lexicon.mark_complete");
        button.m_93666_((Component)s);
    }

    protected void questButtonClicked(Button button) {
        String res = this.entry.getId().toString();
        PersistentData.DataHolder.BookData data = PersistentData.data.getBookData(this.parent.book);
        if (data.completedManualQuests.contains(res)) {
            data.completedManualQuests.remove(res);
        } else {
            data.completedManualQuests.add(res);
        }
        PersistentData.save();
        this.updateButtonText(button);
        this.entry.markReadStateDirty();
    }

    @Override
    public void render(PoseStack ms, int mouseX, int mouseY, float pticks) {
        super.render(ms, mouseX, mouseY, pticks);
        this.parent.drawCenteredStringNoShadow(ms, this.title == null || this.title.isEmpty() ? I18n.m_118938_((String)"patchouli.gui.lexicon.objective", (Object[])new Object[0]) : this.i18n(this.title), 58, 0, this.book.headerColor);
        GuiBook.drawSeparator(ms, this.book, 0, 12);
        if (!this.isManual) {
            GuiBook.drawSeparator(ms, this.book, 0, 131);
            boolean completed = this.isCompleted(this.parent.book);
            String s = I18n.m_118938_((String)(completed ? "patchouli.gui.lexicon.complete" : "patchouli.gui.lexicon.incomplete"), (Object[])new Object[0]);
            int color = completed ? 35610 : this.book.headerColor;
            this.parent.drawCenteredStringNoShadow(ms, s, 58, 139, color);
        }
    }
}

