/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.client.gui.GuiComputer;
import dan200.computercraft.client.gui.GuiDiskDrive;
import dan200.computercraft.client.gui.GuiPrinter;
import dan200.computercraft.client.gui.GuiPrintout;
import dan200.computercraft.client.gui.GuiTurtle;
import dan200.computercraft.client.gui.NoTermComputerScreen;
import dan200.computercraft.client.render.TileEntityMonitorRenderer;
import dan200.computercraft.client.render.TileEntityTurtleRenderer;
import dan200.computercraft.client.render.TurtleModelLoader;
import dan200.computercraft.client.render.TurtlePlayerRenderer;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.media.items.ItemDisk;
import dan200.computercraft.shared.media.items.ItemTreasureDisk;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.util.Colour;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="computercraft", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ClientRegistry {
    private static final String[] EXTRA_MODELS = new String[]{"turtle_modem_normal_off_left", "turtle_modem_normal_on_left", "turtle_modem_normal_off_right", "turtle_modem_normal_on_right", "turtle_modem_advanced_off_left", "turtle_modem_advanced_on_left", "turtle_modem_advanced_off_right", "turtle_modem_advanced_on_right", "turtle_crafting_table_left", "turtle_crafting_table_right", "turtle_speaker_upgrade_left", "turtle_speaker_upgrade_right", "turtle_colour", "turtle_elf_overlay"};

    private ClientRegistry() {
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("computercraft", "turtle"), (IModelLoader)TurtleModelLoader.INSTANCE);
        for (String model : EXTRA_MODELS) {
            ForgeModelBakery.addSpecialModel((ResourceLocation)new ModelResourceLocation(new ResourceLocation("computercraft", model), "inventory"));
        }
    }

    @SubscribeEvent
    public static void onItemColours(ColorHandlerEvent.Item event) {
        if (Registry.ModItems.DISK == null || Registry.ModBlocks.TURTLE_NORMAL == null) {
            ComputerCraft.log.warn("Block/item registration has failed. Skipping registration of item colours.");
            return;
        }
        event.getItemColors().m_92689_((stack, layer) -> layer == 1 ? ((ItemDisk)stack.m_41720_()).getColour(stack) : 0xFFFFFF, new ItemLike[]{(ItemLike)Registry.ModItems.DISK.get()});
        event.getItemColors().m_92689_((stack, layer) -> layer == 1 ? ItemTreasureDisk.getColour(stack) : 0xFFFFFF, new ItemLike[]{(ItemLike)Registry.ModItems.TREASURE_DISK.get()});
        event.getItemColors().m_92689_((stack, layer) -> {
            switch (layer) {
                default: {
                    return 0xFFFFFF;
                }
                case 1: {
                    return IColouredItem.getColourBasic(stack);
                }
                case 2: 
            }
            int light = ItemPocketComputer.getLightState(stack);
            return light == -1 ? Colour.BLACK.getHex() : light;
        }, new ItemLike[]{(ItemLike)Registry.ModItems.POCKET_COMPUTER_NORMAL.get(), (ItemLike)Registry.ModItems.POCKET_COMPUTER_ADVANCED.get()});
        event.getItemColors().m_92689_((stack, tintIndex) -> tintIndex == 0 ? ((IColouredItem)stack.m_41720_()).getColour(stack) : 0xFFFFFF, new ItemLike[]{(ItemLike)Registry.ModBlocks.TURTLE_NORMAL.get(), (ItemLike)Registry.ModBlocks.TURTLE_ADVANCED.get()});
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)Registry.ModEntities.TURTLE_PLAYER.get(), TurtlePlayerRenderer::new);
    }

    @SubscribeEvent
    public static void setupClient(FMLClientSetupEvent event) {
        ClientRegistry.registerContainers();
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)Registry.ModBlocks.TURTLE_NORMAL.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)Registry.ModBlocks.TURTLE_ADVANCED.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)Registry.ModBlocks.MONITOR_NORMAL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)Registry.ModBlocks.MONITOR_ADVANCED.get()), (RenderType)RenderType.m_110463_());
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)Registry.ModBlockEntities.MONITOR_NORMAL.get()), TileEntityMonitorRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)Registry.ModBlockEntities.MONITOR_ADVANCED.get()), TileEntityMonitorRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)Registry.ModBlockEntities.TURTLE_NORMAL.get()), TileEntityTurtleRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)Registry.ModBlockEntities.TURTLE_ADVANCED.get()), TileEntityTurtleRenderer::new);
        ClientRegistry.registerItemProperty("state", (stack, world, player, random) -> ItemPocketComputer.getState(stack).ordinal(), new Supplier[]{Registry.ModItems.POCKET_COMPUTER_NORMAL, Registry.ModItems.POCKET_COMPUTER_ADVANCED});
        ClientRegistry.registerItemProperty("coloured", (stack, world, player, random) -> IColouredItem.getColourBasic(stack) != -1 ? 1.0f : 0.0f, new Supplier[]{Registry.ModItems.POCKET_COMPUTER_NORMAL, Registry.ModItems.POCKET_COMPUTER_ADVANCED});
    }

    @SafeVarargs
    private static void registerItemProperty(String name, ItemPropertyFunction getter, Supplier<? extends Item> ... items) {
        ResourceLocation id = new ResourceLocation("computercraft", name);
        for (Supplier<? extends Item> item : items) {
            ItemProperties.register((Item)item.get(), (ResourceLocation)id, (ItemPropertyFunction)getter);
        }
    }

    private static void registerContainers() {
        MenuScreens.m_96206_((MenuType)((MenuType)Registry.ModContainers.COMPUTER.get()), GuiComputer::create);
        MenuScreens.m_96206_((MenuType)((MenuType)Registry.ModContainers.POCKET_COMPUTER.get()), GuiComputer::createPocket);
        MenuScreens.m_96206_((MenuType)((MenuType)Registry.ModContainers.POCKET_COMPUTER_NO_TERM.get()), NoTermComputerScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)Registry.ModContainers.TURTLE.get()), GuiTurtle::new);
        MenuScreens.m_96206_((MenuType)((MenuType)Registry.ModContainers.PRINTER.get()), GuiPrinter::new);
        MenuScreens.m_96206_((MenuType)((MenuType)Registry.ModContainers.DISK_DRIVE.get()), GuiDiskDrive::new);
        MenuScreens.m_96206_((MenuType)((MenuType)Registry.ModContainers.PRINTOUT.get()), GuiPrintout::new);
        MenuScreens.m_96206_((MenuType)((MenuType)Registry.ModContainers.VIEW_COMPUTER.get()), GuiComputer::createView);
    }
}

