/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.VertexFormat;
import dan200.computercraft.client.gui.FixedWidthFontRenderer;
import dan200.computercraft.shared.util.Palette;
import java.io.IOException;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MonitorTextureBufferShader
extends ShaderInstance {
    static final int TEXTURE_INDEX = 33987;
    private static final Logger LOGGER = LogManager.getLogger();
    private final Uniform palette;
    private final Uniform width = this.getUniformChecked("Width");
    private final Uniform height = this.getUniformChecked("Height");

    public MonitorTextureBufferShader(ResourceProvider provider, ResourceLocation location, VertexFormat format) throws IOException {
        super(provider, location, format);
        this.palette = new Uniform("Palette", 6, 48, (Shader)this);
        this.updateUniformLocation(this.palette);
        Uniform tbo = this.getUniformChecked("Tbo");
        if (tbo != null) {
            tbo.m_142617_(3);
        }
    }

    void setupUniform(int width, int height, Palette palette, boolean greyscale) {
        if (this.width != null) {
            this.width.m_142617_(width);
        }
        if (this.height != null) {
            this.height.m_142617_(height);
        }
        this.setupPalette(palette, greyscale);
    }

    private void setupPalette(Palette palette, boolean greyscale) {
        if (this.palette == null) {
            return;
        }
        FloatBuffer paletteBuffer = this.palette.m_166761_();
        paletteBuffer.rewind();
        for (int i = 0; i < 16; ++i) {
            double[] colour = palette.getColour(i);
            if (greyscale) {
                float f = FixedWidthFontRenderer.toGreyscale(colour);
                paletteBuffer.put(f).put(f).put(f);
                continue;
            }
            paletteBuffer.put((float)colour[0]).put((float)colour[1]).put((float)colour[2]);
        }
    }

    public void m_173363_() {
        super.m_173363_();
        this.palette.m_85633_();
    }

    public void close() {
        this.palette.close();
        super.close();
    }

    private void updateUniformLocation(Uniform uniform) {
        int id = Uniform.m_85624_((int)this.m_142658_(), (CharSequence)uniform.m_85599_());
        if (id == -1) {
            LOGGER.warn("Shader {} could not find uniform named {} in the specified shader program.", (Object)this.m_173365_(), (Object)uniform.m_85599_());
        } else {
            uniform.m_85614_(id);
        }
    }

    @Nullable
    private Uniform getUniformChecked(String name) {
        Uniform uniform = this.m_173348_(name);
        if (uniform == null) {
            LOGGER.warn("Monitor shader {} should have uniform {}, but it was not present.", (Object)this.m_173365_(), (Object)name);
        }
        return uniform;
    }
}

