/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.sound;

import dan200.computercraft.client.sound.SpeakerInstance;
import dan200.computercraft.client.sound.SpeakerSound;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.sound.PlayStreamingSourceEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class SpeakerManager {
    private static final Map<UUID, SpeakerInstance> sounds = new ConcurrentHashMap<UUID, SpeakerInstance>();

    @SubscribeEvent
    public static void playStreaming(PlayStreamingSourceEvent event) {
        SoundInstance soundInstance = event.getSound();
        if (!(soundInstance instanceof SpeakerSound)) {
            return;
        }
        SpeakerSound sound = (SpeakerSound)soundInstance;
        if (sound.stream == null) {
            return;
        }
        event.getChannel().m_83658_((AudioStream)sound.stream);
        event.getChannel().m_83672_();
        sound.channel = event.getChannel();
        sound.executor = event.getEngine().f_120223_;
    }

    public static SpeakerInstance getSound(UUID source) {
        return sounds.computeIfAbsent(source, x -> new SpeakerInstance());
    }

    public static void stopSound(UUID source) {
        SpeakerInstance sound = sounds.remove(source);
        if (sound != null) {
            sound.stop();
        }
    }

    public static void moveSound(UUID source, Vec3 position) {
        SpeakerInstance sound = sounds.get(source);
        if (sound != null) {
            sound.setPosition(position);
        }
    }

    public static void reset() {
        sounds.clear();
    }
}

