/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.upload;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.computer.upload.FileUpload;
import java.nio.ByteBuffer;
import java.util.List;

public class FileSlice {
    private final int fileId;
    private final int offset;
    private final ByteBuffer bytes;

    public FileSlice(int fileId, int offset, ByteBuffer bytes) {
        this.fileId = fileId;
        this.offset = offset;
        this.bytes = bytes;
    }

    public int getFileId() {
        return this.fileId;
    }

    public int getOffset() {
        return this.offset;
    }

    public ByteBuffer getBytes() {
        return this.bytes;
    }

    public void apply(List<FileUpload> files) {
        if (this.fileId < 0 || this.fileId >= files.size()) {
            ComputerCraft.log.warn("File ID is out-of-bounds (0 <= {} < {})", (Object)this.fileId, (Object)files.size());
            return;
        }
        ByteBuffer file = files.get(this.fileId).getBytes();
        if (this.offset < 0 || this.offset + this.bytes.remaining() > file.capacity()) {
            ComputerCraft.log.warn("File offset is out-of-bounds (0 <= {} <= {})", (Object)this.offset, (Object)(file.capacity() - this.offset));
            return;
        }
        file.put(this.offset, this.bytes, this.bytes.position(), this.bytes.remaining());
    }
}

