/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.client.ClientTableFormatter;
import dan200.computercraft.shared.command.text.TableBuilder;
import dan200.computercraft.shared.network.NetworkMessage;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.network.NetworkEvent;

public class ChatTableClientMessage
implements NetworkMessage {
    private final TableBuilder table;

    public ChatTableClientMessage(TableBuilder table) {
        if (table.getColumns() < 0) {
            throw new IllegalStateException("Cannot send an empty table");
        }
        this.table = table;
    }

    public ChatTableClientMessage(@Nonnull FriendlyByteBuf buf) {
        TableBuilder table;
        int i;
        int id = buf.m_130242_();
        int columns = buf.m_130242_();
        if (buf.readBoolean()) {
            Component[] headers = new Component[columns];
            for (i = 0; i < columns; ++i) {
                headers[i] = buf.m_130238_();
            }
            table = new TableBuilder(id, headers);
        } else {
            table = new TableBuilder(id);
        }
        int rows = buf.m_130242_();
        for (i = 0; i < rows; ++i) {
            Component[] row = new Component[columns];
            for (int j = 0; j < columns; ++j) {
                row[j] = buf.m_130238_();
            }
            table.row(row);
        }
        table.setAdditional(buf.m_130242_());
        this.table = table;
    }

    @Override
    public void toBytes(@Nonnull FriendlyByteBuf buf) {
        buf.m_130130_(this.table.getId());
        buf.m_130130_(this.table.getColumns());
        buf.writeBoolean(this.table.getHeaders() != null);
        if (this.table.getHeaders() != null) {
            for (Component header : this.table.getHeaders()) {
                buf.m_130083_(header);
            }
        }
        buf.m_130130_(this.table.getRows().size());
        Iterator<Component[]> iterator = this.table.getRows().iterator();
        while (iterator.hasNext()) {
            Component[] row;
            for (Component column : row = (Component[])iterator.next()) {
                buf.m_130083_(column);
            }
        }
        buf.m_130130_(this.table.getAdditional());
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ClientTableFormatter.INSTANCE.display(this.table);
    }
}

