/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.items;

import com.google.common.base.Objects;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.items.IComputerItem;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.pocket.apis.PocketAPI;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.pocket.inventory.PocketComputerMenuProvider;
import dan200.computercraft.shared.pocket.items.PocketComputerItemFactory;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemPocketComputer
extends Item
implements IComputerItem,
IMedia,
IColouredItem {
    private static final String NBT_UPGRADE = "Upgrade";
    private static final String NBT_UPGRADE_INFO = "UpgradeInfo";
    public static final String NBT_LIGHT = "Light";
    private static final String NBT_INSTANCE = "Instanceid";
    private static final String NBT_SESSION = "SessionId";
    private final ComputerFamily family;

    public ItemPocketComputer(Item.Properties settings, ComputerFamily family) {
        super(settings);
        this.family = family;
    }

    public ItemStack create(int id, String label, int colour, IPocketUpgrade upgrade) {
        ItemStack result = new ItemStack((ItemLike)this);
        if (id >= 0) {
            result.m_41784_().m_128405_("ComputerId", id);
        }
        if (label != null) {
            result.m_41714_((Component)new TextComponent(label));
        }
        if (upgrade != null) {
            result.m_41784_().m_128359_(NBT_UPGRADE, upgrade.getUpgradeID().toString());
        }
        if (colour != -1) {
            result.m_41784_().m_128405_("Color", colour);
        }
        return result;
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> stacks) {
        if (!this.m_41389_(group)) {
            return;
        }
        stacks.add((Object)this.create(-1, null, -1, null));
        PocketUpgrades.getVanillaUpgrades().map(x -> this.create(-1, null, -1, (IPocketUpgrade)x)).forEach(arg_0 -> stacks.add(arg_0));
    }

    private boolean tick(@Nonnull ItemStack stack, @Nonnull Level world, @Nonnull Entity entity, @Nonnull PocketServerComputer computer) {
        String label;
        IPocketUpgrade upgrade = ItemPocketComputer.getUpgrade(stack);
        computer.setLevel(world);
        computer.updateValues(entity, stack, upgrade);
        boolean changed = false;
        int id = computer.getID();
        if (id != this.getComputerID(stack)) {
            changed = true;
            ItemPocketComputer.setComputerID(stack, id);
        }
        if (!Objects.equal((Object)(label = computer.getLabel()), (Object)this.getLabel(stack))) {
            changed = true;
            this.setLabel(stack, label);
        }
        if (upgrade != null) {
            upgrade.update(computer, computer.getPeripheral(ComputerSide.BACK));
        }
        return changed;
    }

    public void m_6883_(@Nonnull ItemStack stack, Level world, @Nonnull Entity entity, int slotNum, boolean selected) {
        if (!world.f_46443_) {
            Inventory inventory;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                inventory = player.m_150109_();
            } else {
                inventory = null;
            }
            Inventory inventory2 = inventory;
            PocketServerComputer computer = this.createServerComputer(world, entity, (Container)inventory2, stack);
            computer.keepAlive();
            boolean changed = this.tick(stack, world, entity, computer);
            if (changed && inventory2 != null) {
                inventory2.m_6596_();
            }
        } else {
            ItemPocketComputer.createClientComputer(stack);
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.f_19853_.f_46443_) {
            return false;
        }
        PocketServerComputer computer = ItemPocketComputer.getServerComputer(stack);
        if (computer != null && this.tick(stack, entity.f_19853_, (Entity)entity, computer)) {
            entity.m_32045_(stack.m_41777_());
        }
        return false;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            PocketServerComputer computer = this.createServerComputer(world, (Entity)player, (Container)player.m_150109_(), stack);
            computer.turnOn();
            boolean stop = false;
            IPocketUpgrade upgrade = ItemPocketComputer.getUpgrade(stack);
            if (upgrade != null) {
                computer.updateValues((Entity)player, stack, upgrade);
                stop = upgrade.onRightClick(world, computer, computer.getPeripheral(ComputerSide.BACK));
            }
            if (!stop) {
                boolean isTypingOnly = hand == InteractionHand.OFF_HAND;
                new ComputerContainerData(computer).open(player, new PocketComputerMenuProvider(computer, stack, this, hand, isTypingOnly));
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        String baseString = this.m_5671_(stack);
        IPocketUpgrade upgrade = ItemPocketComputer.getUpgrade(stack);
        if (upgrade != null) {
            return new TranslatableComponent(baseString + ".upgraded", new Object[]{new TranslatableComponent(upgrade.getUnlocalisedAdjective())});
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level world, @Nonnull List<Component> list, TooltipFlag flag) {
        int id;
        if ((flag.m_7050_() || this.getLabel(stack) == null) && (id = this.getComputerID(stack)) >= 0) {
            list.add((Component)new TranslatableComponent("gui.computercraft.tooltip.computer_id", new Object[]{id}).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Nullable
    public String getCreatorModId(ItemStack stack) {
        String mod;
        IPocketUpgrade upgrade = ItemPocketComputer.getUpgrade(stack);
        if (upgrade != null && (mod = PocketUpgrades.instance().getOwner(upgrade)) != null && !mod.equals("computercraft")) {
            return mod;
        }
        return super.getCreatorModId(stack);
    }

    @Nonnull
    public PocketServerComputer createServerComputer(Level world, Entity entity, @Nullable Container inventory, @Nonnull ItemStack stack) {
        PocketServerComputer computer;
        if (world.f_46443_) {
            throw new IllegalStateException("Cannot call createServerComputer on the client");
        }
        int instanceID = ItemPocketComputer.getInstanceID(stack);
        int sessionID = ItemPocketComputer.getSessionID(stack);
        int correctSessionID = ComputerCraft.serverComputerRegistry.getSessionID();
        if (instanceID >= 0 && sessionID == correctSessionID && ComputerCraft.serverComputerRegistry.contains(instanceID)) {
            computer = (PocketServerComputer)ComputerCraft.serverComputerRegistry.get(instanceID);
        } else {
            int computerID;
            if (instanceID < 0 || sessionID != correctSessionID) {
                instanceID = ComputerCraft.serverComputerRegistry.getUnusedInstanceID();
                ItemPocketComputer.setInstanceID(stack, instanceID);
                ItemPocketComputer.setSessionID(stack, correctSessionID);
            }
            if ((computerID = this.getComputerID(stack)) < 0) {
                computerID = ComputerCraftAPI.createUniqueNumberedSaveDir(world, "computer");
                ItemPocketComputer.setComputerID(stack, computerID);
            }
            computer = new PocketServerComputer(world, computerID, this.getLabel(stack), instanceID, this.getFamily());
            computer.updateValues(entity, stack, ItemPocketComputer.getUpgrade(stack));
            computer.addAPI(new PocketAPI(computer));
            ComputerCraft.serverComputerRegistry.add(instanceID, computer);
            if (inventory != null) {
                inventory.m_6596_();
            }
        }
        computer.setLevel(world);
        return computer;
    }

    @Nullable
    public static PocketServerComputer getServerComputer(@Nonnull ItemStack stack) {
        int session = ItemPocketComputer.getSessionID(stack);
        if (session != ComputerCraft.serverComputerRegistry.getSessionID()) {
            return null;
        }
        int instanceID = ItemPocketComputer.getInstanceID(stack);
        return instanceID >= 0 ? (PocketServerComputer)ComputerCraft.serverComputerRegistry.get(instanceID) : null;
    }

    @Nullable
    public static ClientComputer createClientComputer(@Nonnull ItemStack stack) {
        int instanceID = ItemPocketComputer.getInstanceID(stack);
        if (instanceID >= 0) {
            if (!ComputerCraft.clientComputerRegistry.contains(instanceID)) {
                ComputerCraft.clientComputerRegistry.add(instanceID, new ClientComputer(instanceID));
            }
            return (ClientComputer)ComputerCraft.clientComputerRegistry.get(instanceID);
        }
        return null;
    }

    @Nullable
    private static ClientComputer getClientComputer(@Nonnull ItemStack stack) {
        int instanceID = ItemPocketComputer.getInstanceID(stack);
        return instanceID >= 0 ? (ClientComputer)ComputerCraft.clientComputerRegistry.get(instanceID) : null;
    }

    private static void setComputerID(@Nonnull ItemStack stack, int computerID) {
        stack.m_41784_().m_128405_("ComputerId", computerID);
    }

    @Override
    public String getLabel(@Nonnull ItemStack stack) {
        return IComputerItem.super.getLabel(stack);
    }

    @Override
    public ComputerFamily getFamily() {
        return this.family;
    }

    @Override
    public ItemStack withFamily(@Nonnull ItemStack stack, @Nonnull ComputerFamily family) {
        return PocketComputerItemFactory.create(this.getComputerID(stack), this.getLabel(stack), this.getColour(stack), family, ItemPocketComputer.getUpgrade(stack));
    }

    @Override
    public boolean setLabel(@Nonnull ItemStack stack, String label) {
        if (label != null) {
            stack.m_41714_((Component)new TextComponent(label));
        } else {
            stack.m_41787_();
        }
        return true;
    }

    @Override
    public IMount createDataMount(@Nonnull ItemStack stack, @Nonnull Level world) {
        int id = this.getComputerID(stack);
        if (id >= 0) {
            return ComputerCraftAPI.createSaveDirMount(world, "computer/" + id, ComputerCraft.computerSpaceLimit);
        }
        return null;
    }

    private static int getInstanceID(@Nonnull ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_(NBT_INSTANCE) ? nbt.m_128451_(NBT_INSTANCE) : -1;
    }

    private static void setInstanceID(@Nonnull ItemStack stack, int instanceID) {
        stack.m_41784_().m_128405_(NBT_INSTANCE, instanceID);
    }

    private static int getSessionID(@Nonnull ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_(NBT_SESSION) ? nbt.m_128451_(NBT_SESSION) : -1;
    }

    private static void setSessionID(@Nonnull ItemStack stack, int sessionID) {
        stack.m_41784_().m_128405_(NBT_SESSION, sessionID);
    }

    public static ComputerState getState(@Nonnull ItemStack stack) {
        ClientComputer computer = ItemPocketComputer.getClientComputer(stack);
        return computer == null ? ComputerState.OFF : computer.getState();
    }

    public static int getLightState(@Nonnull ItemStack stack) {
        CompoundTag computerNBT;
        ClientComputer computer = ItemPocketComputer.getClientComputer(stack);
        if (computer != null && computer.isOn() && (computerNBT = computer.getUserData()) != null && computerNBT.m_128441_(NBT_LIGHT)) {
            return computerNBT.m_128451_(NBT_LIGHT);
        }
        return -1;
    }

    public static IPocketUpgrade getUpgrade(@Nonnull ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        return compound != null && compound.m_128441_(NBT_UPGRADE) ? PocketUpgrades.instance().get(compound.m_128461_(NBT_UPGRADE)) : null;
    }

    public static void setUpgrade(@Nonnull ItemStack stack, IPocketUpgrade upgrade) {
        CompoundTag compound = stack.m_41784_();
        if (upgrade == null) {
            compound.m_128473_(NBT_UPGRADE);
        } else {
            compound.m_128359_(NBT_UPGRADE, upgrade.getUpgradeID().toString());
        }
        compound.m_128473_(NBT_UPGRADE_INFO);
    }

    public static CompoundTag getUpgradeInfo(@Nonnull ItemStack stack) {
        return stack.m_41698_(NBT_UPGRADE_INFO);
    }
}

