/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.common.io.BaseEncoding;
import dan200.computercraft.ComputerCraft;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public final class NBTUtil {
    private static final BaseEncoding ENCODING = BaseEncoding.base16().lowerCase();

    private NBTUtil() {
    }

    private static Tag toNBTTag(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return ByteTag.m_128266_((byte)((byte)((Boolean)object != false ? 1 : 0)));
        }
        if (object instanceof Number) {
            return DoubleTag.m_128500_((double)((Number)object).doubleValue());
        }
        if (object instanceof String) {
            return StringTag.m_129297_((String)object.toString());
        }
        if (object instanceof Map) {
            Map m = (Map)object;
            CompoundTag nbt = new CompoundTag();
            int i = 0;
            for (Map.Entry entry : m.entrySet()) {
                Tag key = NBTUtil.toNBTTag(entry.getKey());
                Tag value = NBTUtil.toNBTTag(entry.getKey());
                if (key == null || value == null) continue;
                nbt.m_128365_("k" + i, key);
                nbt.m_128365_("v" + i, value);
                ++i;
            }
            nbt.m_128405_("len", m.size());
            return nbt;
        }
        return null;
    }

    public static CompoundTag encodeObjects(Object[] objects) {
        if (objects == null || objects.length <= 0) {
            return null;
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("len", objects.length);
        for (int i = 0; i < objects.length; ++i) {
            Tag child = NBTUtil.toNBTTag(objects[i]);
            if (child == null) continue;
            nbt.m_128365_(Integer.toString(i), child);
        }
        return nbt;
    }

    private static Object fromNBTTag(Tag tag) {
        if (tag == null) {
            return null;
        }
        switch (tag.m_7060_()) {
            case 1: {
                return ((ByteTag)tag).m_7063_() > 0;
            }
            case 6: {
                return ((DoubleTag)tag).m_7061_();
            }
            default: {
                return tag.m_7916_();
            }
            case 10: 
        }
        CompoundTag c = (CompoundTag)tag;
        int len = c.m_128451_("len");
        HashMap<Object, Object> map = new HashMap<Object, Object>(len);
        for (int i = 0; i < len; ++i) {
            Object key = NBTUtil.fromNBTTag(c.m_128423_("k" + i));
            Object value = NBTUtil.fromNBTTag(c.m_128423_("v" + i));
            if (key == null || value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    public static Object toLua(Tag tag) {
        if (tag == null) {
            return null;
        }
        byte typeID = tag.m_7060_();
        switch (typeID) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return ((NumericTag)tag).m_7046_();
            }
            case 5: 
            case 6: {
                return ((NumericTag)tag).m_7061_();
            }
            case 8: {
                return tag.m_7916_();
            }
            case 10: {
                CompoundTag compound = (CompoundTag)tag;
                HashMap<String, Object> map = new HashMap<String, Object>(compound.m_128440_());
                for (String key : compound.m_128431_()) {
                    Object value = NBTUtil.toLua(compound.m_128423_(key));
                    if (value == null) continue;
                    map.put(key, value);
                }
                return map;
            }
            case 9: {
                ListTag list = (ListTag)tag;
                HashMap<Integer, Object> map = new HashMap<Integer, Object>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    map.put(i, NBTUtil.toLua(list.get(i)));
                }
                return map;
            }
            case 7: {
                byte[] array = ((ByteArrayTag)tag).m_128227_();
                HashMap<Integer, Byte> map = new HashMap<Integer, Byte>(array.length);
                for (int i = 0; i < array.length; ++i) {
                    map.put(i + 1, array[i]);
                }
                return map;
            }
            case 11: {
                int[] array = ((IntArrayTag)tag).m_128648_();
                HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(array.length);
                for (int i = 0; i < array.length; ++i) {
                    map.put(i + 1, array[i]);
                }
                return map;
            }
        }
        return null;
    }

    public static Object[] decodeObjects(CompoundTag tag) {
        int len = tag.m_128451_("len");
        if (len <= 0) {
            return null;
        }
        Object[] objects = new Object[len];
        for (int i = 0; i < len; ++i) {
            String key = Integer.toString(i);
            if (!tag.m_128441_(key)) continue;
            objects[i] = NBTUtil.fromNBTTag(tag.m_128423_(key));
        }
        return objects;
    }

    @Nullable
    public static String getNBTHash(@Nullable CompoundTag tag) {
        if (tag == null) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            DataOutputStream output = new DataOutputStream(new DigestOutputStream(digest));
            NbtIo.m_128941_((CompoundTag)tag, (DataOutput)output);
            byte[] hash = digest.digest();
            return ENCODING.encode(hash);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            ComputerCraft.log.error("Cannot hash NBT", (Throwable)e);
            return null;
        }
    }

    private static final class DigestOutputStream
    extends OutputStream {
        private final MessageDigest digest;

        DigestOutputStream(MessageDigest digest) {
            this.digest = digest;
        }

        @Override
        public void write(@Nonnull byte[] b, int off, int len) {
            this.digest.update(b, off, len);
        }

        @Override
        public void write(int b) {
            this.digest.update((byte)b);
        }
    }
}

